/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.SystemJobDao;
import org.mycontroller.standalone.db.tables.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemJobDaoImpl
extends BaseAbstractDaoImpl<SystemJob, Integer>
implements SystemJobDao {
    private static final Logger _logger = LoggerFactory.getLogger(SystemJobDaoImpl.class);

    public SystemJobDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, SystemJob.class);
    }

    @Override
    public void create(SystemJob systemJob) {
        try {
            int count = this.getDao().create((Object)systemJob);
            _logger.debug("Created SystemJob:[{}], Create count:{}", (Object)systemJob, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add SystemJob:[{}]", (Object)systemJob, (Object)ex);
        }
    }

    @Override
    public void createOrUpdate(SystemJob systemJob) {
        try {
            Dao.CreateOrUpdateStatus count = this.getDao().createOrUpdate((Object)systemJob);
            _logger.debug("createOrUpdate SystemJob:[{}], Status[create:{},update:{}], Number of line changed:{}", new Object[]{systemJob, count.isCreated(), count.isUpdated(), count.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to add SystemJob:[{}]", (Object)systemJob, (Object)ex);
        }
    }

    @Override
    public void delete(SystemJob systemJob) {
        if (systemJob == null) {
            return;
        }
        try {
            this.getDao().deleteById((Object)systemJob.getId());
            _logger.debug("Job[{}] deleted from db.", (Object)systemJob);
        }
        catch (SQLException ex) {
            _logger.error("unable to get SystemJob", (Throwable)ex);
        }
    }

    @Override
    public void update(SystemJob systemJob) {
        try {
            int count = this.getDao().update((Object)systemJob);
            _logger.debug("Update SystemJob:[{}], Change Count:{}", (Object)systemJob, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("Unable to update SystemJob:[{}]", (Object)systemJob, (Object)ex);
        }
    }

    @Override
    public SystemJob get(SystemJob systemJob) {
        return this.get(systemJob.getId());
    }

    @Override
    public SystemJob get(Integer id) {
        try {
            return (SystemJob)this.getDao().queryForId((Object)id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get SystemJob", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<SystemJob> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<SystemJob> getAllEnabled() {
        try {
            return this.getDao().queryBuilder().where().eq("enabled", (Object)true).query();
        }
        catch (SQLException ex) {
            _logger.error("Unable to get list of enabled systemjobs", (Throwable)ex);
            return null;
        }
    }
}

