/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.sms;

import com.plivo.helper.api.client.RestAPI;
import com.plivo.helper.api.response.message.MessageResponse;
import com.plivo.helper.exception.PlivoException;
import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.instance.Sms;
import java.util.LinkedHashMap;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSUtils {
    private static final Logger _logger = LoggerFactory.getLogger(SMSUtils.class);
    private static TwilioRestClient clientTwilio = null;
    private static RestAPI clientPlivo = null;
    private static LinkedHashMap<String, String> smsParameters = new LinkedHashMap();

    private SMSUtils() {
    }

    public static synchronized void sendSmsPlivo(String toPhoneNumbers, String message) {
        clientPlivo = new RestAPI(ObjectFactory.getAppProperties().getSmsSettings().getAuthSid(), ObjectFactory.getAppProperties().getSmsSettings().getAuthToken(), "v1");
        smsParameters.clear();
        smsParameters.put("src", ObjectFactory.getAppProperties().getSmsSettings().getFromNumber());
        smsParameters.put("dst", toPhoneNumbers.replaceAll(",", "<").replace("+", ""));
        smsParameters.put("text", message);
        if (message.length() > 160) {
            _logger.info("Message size bigger than 160 characters, Size:[{}], Message:[{}]", (Object)message.length(), (Object)message);
        }
        try {
            MessageResponse msgResponse = clientPlivo.sendMessage(smsParameters);
            if (msgResponse.serverCode == 202) {
                _logger.debug("SMS sent successfully...");
            } else {
                _logger.warn("Error SMS:[apiId:{}, error:{}, serverCode:{}, message:{}, messageUuids:{}]", new Object[]{msgResponse.apiId, msgResponse.error, msgResponse.serverCode, msgResponse.message, msgResponse.messageUuids});
            }
        }
        catch (PlivoException ex) {
            _logger.error("Error, ", (Throwable)ex);
        }
    }

    public static synchronized void sendSmsTwilio(String toPhoneNumbers, String message) {
        if (clientTwilio == null) {
            clientTwilio = new TwilioRestClient(ObjectFactory.getAppProperties().getSmsSettings().getAuthSid(), ObjectFactory.getAppProperties().getSmsSettings().getAuthToken());
            clientTwilio = new TwilioRestClient(ObjectFactory.getAppProperties().getSmsSettings().getAuthSid(), ObjectFactory.getAppProperties().getSmsSettings().getAuthToken());
        }
        smsParameters.clear();
        smsParameters.put("From", ObjectFactory.getAppProperties().getSmsSettings().getFromNumber());
        if (message.length() > 1600) {
            _logger.warn("Maximum allowed chars limit 1600, this message has {} chars. Dropping part of message", (Object)message.length());
            message = message.substring(0, 1600);
        }
        smsParameters.put("Body", message);
        for (String toPhoneNumber : toPhoneNumbers.split(",")) {
            smsParameters.put("To", toPhoneNumber);
            try {
                Sms sms = clientTwilio.getAccount().getSmsFactory().create(smsParameters);
                _logger.info("SMS json string", (Object)sms.toJSON());
                if (sms.getProperty("ErrorCode") == null) continue;
                _logger.warn("Message sending failed! Erro code:{}, Error message:{}", (Object)sms.getProperty("ErrorCode"), (Object)sms.getProperty("ErrorMessage"));
            }
            catch (TwilioRestException ex) {
                _logger.error("Error while sending SMS, ", (Throwable)ex);
            }
        }
    }

    public static synchronized void sendSMS(String toPhoneNumbers, String message) {
        if (ObjectFactory.getAppProperties().getSmsSettings().getAuthSid() == null || ObjectFactory.getAppProperties().getSmsSettings().getAuthToken() == null || ObjectFactory.getAppProperties().getSmsSettings().getFromNumber() == null || ObjectFactory.getAppProperties().getSmsSettings().getVendor() == null || toPhoneNumbers == null || message == null) {
            _logger.warn("Sms sending failed! Sms settings value should not be null. ToPhoneNumbers:{},Message:{},SmsSettings:{}", new Object[]{toPhoneNumbers, message, ObjectFactory.getAppProperties().getSmsSettings()});
            return;
        }
        switch (AppProperties.SMS_VENDOR.fromString(ObjectFactory.getAppProperties().getSmsSettings().getVendor())) {
            case PLIVO: {
                SMSUtils.sendSmsPlivo(toPhoneNumbers, message);
                break;
            }
            case TWILIO: {
                SMSUtils.sendSmsTwilio(toPhoneNumbers, message);
                break;
            }
            default: {
                _logger.warn("This type of vendor not implemented yet! Vendor:{}", (Object)ObjectFactory.getAppProperties().getSmsSettings().getVendor());
            }
        }
    }

    public static void clearClients() {
        clientTwilio = null;
        clientPlivo = null;
    }
}

