/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.mycontroller.standalone.api.jaxrs.mapper.AuthenticationJson;
import org.mycontroller.standalone.api.jaxrs.mapper.UserCredential;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.auth.BasicAthenticationSecurityDomain;
import org.mycontroller.standalone.db.DaoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest/authentication")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermitAll
public class AuthenticationHandler {
    private static final Logger _logger = LoggerFactory.getLogger(AuthenticationHandler.class);
    @Context
    HttpRequest request;

    @POST
    @Path(value="/login")
    public Response login(UserCredential userCredential) throws InterruptedException {
        _logger.debug("User Detail:{}", (Object)RestUtils.getUser(this.request));
        _logger.debug("Login user: " + userCredential.getUsername());
        if (BasicAthenticationSecurityDomain.login(userCredential.getUsername(), userCredential.getPassword())) {
            AuthenticationJson authJson = AuthenticationJson.builder().success(true).user(DaoUtils.getUserDao().get(userCredential.getUsername())).build();
            return RestUtils.getResponse(Response.Status.OK, authJson);
        }
        return RestUtils.getResponse(Response.Status.UNAUTHORIZED, AuthenticationJson.builder().success(false).message("Invalid user or passowrd!").build());
    }
}

