/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.mapper.MetricsChartDataGroupNVD3;
import org.mycontroller.standalone.api.jaxrs.mapper.MetricsChartDataNVD3;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.MetricsBatteryUsage;
import org.mycontroller.standalone.db.tables.MetricsBinaryTypeDevice;
import org.mycontroller.standalone.db.tables.MetricsDoubleTypeDevice;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.metrics.MetricsCsvEngine;
import org.mycontroller.standalone.model.ResourceCountModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest/metrics")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class MetricsHandler {
    private static final Logger _logger = LoggerFactory.getLogger((String)MetricsHandler.class.getName());
    public static final String MINUMUM = "Minimum";
    public static final String MAXIMUM = "Maximum";
    public static final String AVERAGE = "Average";

    @GET
    @Path(value="/resourceCount")
    public Response getResourceCount(@QueryParam(value="resourceType") AppProperties.RESOURCE_TYPE resourceType, @QueryParam(value="resourceId") Integer resourceId) {
        return RestUtils.getResponse(Response.Status.OK, new ResourceCountModel(resourceType, resourceId));
    }

    @GET
    @Path(value="/metricsData")
    public Response getMetricsData(@QueryParam(value="sensorId") Integer sensorId, @QueryParam(value="timestampFrom") Long timestampFrom, @QueryParam(value="timestampTo") Long timestampTo, @QueryParam(value="withMinMax") Boolean withMinMax) {
        return RestUtils.getResponse(Response.Status.OK, this.getMetricsDataJsonNVD3(sensorId, timestampFrom, timestampTo, withMinMax != null ? withMinMax : false));
    }

    @GET
    @Path(value="/csvFile")
    public Response getCsvFile(@QueryParam(value="variableTypeId") int variableTypeId, @QueryParam(value="aggregationType") int aggregationType) {
        try {
            return RestUtils.getResponse(Response.Status.OK, new MetricsCsvEngine().getMetricsCSV(variableTypeId, aggregationType));
        }
        catch (Exception ex) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError(ex.getMessage()));
        }
    }

    @GET
    @Path(value="/batteryUsage")
    public Response getBatteryUsageDetails(@QueryParam(value="nodeId") Integer nodeId) {
        return RestUtils.getResponse(Response.Status.OK, this.getBatterUsage(nodeId));
    }

    private ArrayList<MetricsChartDataNVD3> getBatterUsage(int nodeId) {
        ArrayList<MetricsChartDataNVD3> finalData = new ArrayList<MetricsChartDataNVD3>();
        List<MetricsBatteryUsage> metrics = DaoUtils.getMetricsBatteryUsageDao().getAll(nodeId);
        if (metrics == null) {
            _logger.debug("No data");
            return null;
        }
        ArrayList<Object> batteryMetrics = new ArrayList<Object>();
        for (MetricsBatteryUsage metric : metrics) {
            batteryMetrics.add(new Object[]{metric.getTimestamp(), metric.getValue()});
        }
        finalData.add(MetricsChartDataNVD3.builder().key("Battery Level").values(batteryMetrics).build());
        return finalData;
    }

    private ArrayList<MetricsChartDataGroupNVD3> getMetricsDataJsonNVD3(Integer sensorId, Long timestampFrom, Long timestampTo, Boolean withMinMax) {
        List<SensorVariable> sensorVariables = DaoUtils.getSensorVariableDao().getAll(sensorId);
        if (sensorVariables == null || sensorVariables.size() == 0) {
            return null;
        }
        ArrayList<MetricsChartDataGroupNVD3> finalData = new ArrayList<MetricsChartDataGroupNVD3>();
        for (SensorVariable sensorVariable : sensorVariables) {
            switch (sensorVariable.getMetricType()) {
                case DOUBLE: {
                    ArrayList<MetricsChartDataNVD3> preDoubleData = new ArrayList<MetricsChartDataNVD3>();
                    MetricsDoubleTypeDevice metricQueryDouble = MetricsDoubleTypeDevice.builder().timestampFrom(timestampFrom).timestampTo(timestampTo).sensorVariable(sensorVariable).build();
                    List<MetricsDoubleTypeDevice> doubleMetrics = DaoUtils.getMetricsDoubleTypeDeviceDao().getAll(metricQueryDouble);
                    ArrayList<Object> avgMetricDoubleValues = new ArrayList<Object>();
                    ArrayList<Object> minMetricDoubleValues = new ArrayList<Object>();
                    ArrayList<Object> maxMetricDoubleValues = new ArrayList<Object>();
                    for (MetricsDoubleTypeDevice metric : doubleMetrics) {
                        avgMetricDoubleValues.add(new Object[]{metric.getTimestamp(), metric.getAvg()});
                        if (!withMinMax.booleanValue()) continue;
                        minMetricDoubleValues.add(new Object[]{metric.getTimestamp(), metric.getMin()});
                        maxMetricDoubleValues.add(new Object[]{metric.getTimestamp(), metric.getMax()});
                    }
                    preDoubleData.add(MetricsChartDataNVD3.builder().key(AVERAGE).values(avgMetricDoubleValues).type("lineChart").interpolate("linear").area(false).build());
                    if (withMinMax.booleanValue()) {
                        preDoubleData.add(MetricsChartDataNVD3.builder().key(MINUMUM).values(minMetricDoubleValues).type("lineChart").interpolate("linear").area(false).build());
                        preDoubleData.add(MetricsChartDataNVD3.builder().key(MAXIMUM).values(maxMetricDoubleValues).type("lineChart").interpolate("linear").area(false).build());
                    }
                    finalData.add(MetricsChartDataGroupNVD3.builder().metricsChartDataNVD3(preDoubleData).id(sensorVariable.getId()).unit(sensorVariable.getUnit()).variableType(sensorVariable.getVariableType().getText()).dataType(sensorVariable.getMetricType().getText()).build());
                    break;
                }
                case BINARY: {
                    ArrayList<MetricsChartDataNVD3> preBinaryData = new ArrayList<MetricsChartDataNVD3>();
                    MetricsBinaryTypeDevice metricQueryBinary = MetricsBinaryTypeDevice.builder().timestampFrom(timestampFrom).timestampTo(timestampTo).sensorVariable(sensorVariable).build();
                    List<MetricsBinaryTypeDevice> binaryMetrics = DaoUtils.getMetricsBinaryTypeDeviceDao().getAll(metricQueryBinary);
                    ArrayList<Object> metricBinaryValues = new ArrayList<Object>();
                    for (MetricsBinaryTypeDevice metric : binaryMetrics) {
                        metricBinaryValues.add(new Object[]{metric.getTimestamp(), metric.getState() != false ? 1 : 0});
                    }
                    preBinaryData.add(MetricsChartDataNVD3.builder().key(sensorVariable.getVariableType().getText()).values(metricBinaryValues).type("lineChart").interpolate("step-after").area(false).build());
                    finalData.add(MetricsChartDataGroupNVD3.builder().metricsChartDataNVD3(preBinaryData).id(sensorVariable.getId()).unit(sensorVariable.getUnit()).variableType(sensorVariable.getVariableType().getText()).dataType(sensorVariable.getMetricType().getText()).build());
                    break;
                }
            }
        }
        return finalData;
    }
}

