/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAbstractDaoImpl<Tdao, Tid> {
    public static final Logger _logger = LoggerFactory.getLogger(BaseAbstractDaoImpl.class);
    private Dao<Tdao, Tid> dao;

    public BaseAbstractDaoImpl(ConnectionSource connectionSource, Class<Tdao> entity) throws SQLException {
        this.dao = DaoManager.createDao((ConnectionSource)connectionSource, entity);
        TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, entity);
        _logger.debug("Create Table If Not Exists, executed for {}", (Object)entity.getName());
    }

    public Dao<Tdao, Tid> getDao() {
        return this.dao;
    }

    public QueryResponse getQueryResponse(Query query, String idColumn, String isAlterdTotalCountKey) throws SQLException {
        QueryBuilder queryBuilder = this.getDao().queryBuilder();
        Where where = queryBuilder.where();
        where.isNotNull(idColumn);
        block0: for (String key : query.getFilters().keySet()) {
            if (query.getFilters().get(key) == null) continue;
            if (query.getFilters().get(key) instanceof List) {
                for (Object value : (List)query.getFilters().get(key)) {
                    if (value instanceof String) {
                        where.and().like(key, (Object)("%" + value + "%"));
                        continue;
                    }
                    where.and().in(key, new Object[]{query.getFilters().get(key)});
                    continue block0;
                }
                continue;
            }
            where.and().eq(key, query.getFilters().get(key));
        }
        QueryBuilder queryBuilderFilteredCount = this.getDao().queryBuilder();
        queryBuilderFilteredCount.setWhere(where);
        query.setFilteredCount(queryBuilderFilteredCount.countOf());
        if (isAlterdTotalCountKey != null) {
            if (query.getFilters().get(isAlterdTotalCountKey) != null) {
                QueryBuilder totalItemsBuilder = this.getDao().queryBuilder();
                totalItemsBuilder.where().eq(isAlterdTotalCountKey, query.getFilters().get(isAlterdTotalCountKey));
                query.setTotalItems(totalItemsBuilder.countOf());
            } else {
                query.setTotalItems(this.getDao().countOf());
            }
        } else {
            query.setTotalItems(this.getDao().countOf());
        }
        queryBuilder.offset(query.getStartingRow()).limit(Long.valueOf(query.getPageLimit())).orderBy(query.getOrderBy(), query.getOrder().equalsIgnoreCase("asc"));
        return QueryResponse.builder().data(queryBuilder.query()).query(query).build();
    }

    public QueryResponse getQueryResponse(Query query, String idColumn) throws SQLException {
        return this.getQueryResponse(query, idColumn, null);
    }

    public void create(Tdao tdao) {
        try {
            Integer count = this.getDao().create(tdao);
            _logger.debug("Created new item:[{}], Create count:{}", tdao, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add new item:[{}]", tdao, (Object)ex);
        }
    }

    public void createOrUpdate(Tdao tdao) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate(tdao);
            _logger.debug("CreateOrUpdate item:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{tdao, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate item:[{}]", tdao, (Object)ex);
        }
    }

    public void delete(Tdao tdao) {
        try {
            Integer count = this.getDao().delete(tdao);
            _logger.debug("item:[{}] deleted, Delete count:{}", tdao, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete item:[{}]", tdao, (Object)ex);
        }
    }

    public void update(Tdao tdao) {
        try {
            Integer count = this.getDao().update(tdao);
            _logger.debug("Updated item:[{}], Update count:{}", tdao, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update item:[{}]", tdao, (Object)ex);
        }
    }

    public List<Tdao> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all items", (Throwable)ex);
            return null;
        }
    }

    public Tdao getById(Tid id) {
        try {
            return (Tdao)this.getDao().queryForId(id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get item[id:{}]", id, (Object)ex);
            return null;
        }
    }

    public void deleteByIds(List<Tid> ids) {
        try {
            Integer count = this.getDao().deleteIds(ids);
            _logger.debug("Ids:[{}] deleted, Delete count:{}", ids, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete Ids:[{}]", ids, (Object)ex);
        }
    }

    public void deleteById(Tid id) {
        try {
            this.getDao().deleteById(id);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete item, id:[{}]", id, (Object)ex);
        }
    }

    public List<Tdao> getAll(String key, List<Tid> ids) {
        try {
            return this.getDao().queryBuilder().where().in(key, ids).query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all items ids:{}", ids, (Object)ex);
            return null;
        }
    }

    public List<Tdao> getAll(String key, Object value) {
        try {
            return this.getDao().queryBuilder().where().eq(key, value).query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all items value:{}", value, (Object)ex);
            return null;
        }
    }

    public Long countOf() {
        try {
            return this.getDao().countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get count,", (Throwable)ex);
            return null;
        }
    }

    public long countOf(HashMap<String, List<Object>> columnValues) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            Where where = queryBuilder.where();
            boolean appendAND = false;
            for (String key : columnValues.keySet()) {
                if (appendAND) {
                    where.and();
                } else {
                    appendAND = true;
                }
                where.in(key, (Iterable)columnValues.get(key));
            }
            return queryBuilder.countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get count for query, input[{}]", columnValues, (Object)ex);
            return 0L;
        }
    }
}

