/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.email;

import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.mycontroller.standalone.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger _logger = LoggerFactory.getLogger(EmailUtils.class);
    public static final String ALARM_INFO = "\\$alarmInfo";
    private static HtmlEmail email = null;

    private EmailUtils() {
    }

    public static void sendSimpleEmail(String emails, String subject, String message) throws EmailException {
        EmailUtils.initializeEmail();
        email.setSubject(subject);
        email.setHtmlMsg(message);
        email.addTo(emails.split(","));
        String sendReturn = email.send();
        _logger.debug("Send Status:[{}]", (Object)sendReturn);
        _logger.debug("EmailSettings successfully sent to [{}], Message:[{}]", (Object)emails, (Object)message);
    }

    public static void initializeEmail() throws EmailException {
        email = new HtmlEmail();
        email.setHostName(ObjectFactory.getAppProperties().getEmailSettings().getSmtpHost());
        email.setSmtpPort(ObjectFactory.getAppProperties().getEmailSettings().getSmtpPort().intValue());
        if (ObjectFactory.getAppProperties().getEmailSettings().getSmtpUsername() != null && ObjectFactory.getAppProperties().getEmailSettings().getSmtpUsername().length() > 0) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(ObjectFactory.getAppProperties().getEmailSettings().getSmtpUsername(), ObjectFactory.getAppProperties().getEmailSettings().getSmtpPassword()));
        }
        email.setSSLOnConnect(ObjectFactory.getAppProperties().getEmailSettings().getEnableSsl().booleanValue());
        email.setFrom(ObjectFactory.getAppProperties().getEmailSettings().getFromAddress());
    }
}

