/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.serialport.SerialPortMonitoringThread;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MYCSerialPort
implements IGateway {
    private static final Logger _logger = LoggerFactory.getLogger((String)MYCSerialPort.class.getName());
    public static final long THREAD_TERMINATION_WAIT_TIME = 5000L;
    public static final int SERIAL_DATA_MAX_SIZE = 1000;
    private SerialPortMonitoringThread monitoringThread = null;

    public MYCSerialPort(Gateway gateway) {
        this.monitoringThread = new SerialPortMonitoringThread(gateway);
        new Thread(this.monitoringThread).start();
    }

    @Override
    public synchronized void write(RawMessage rawMessage) throws GatewayException {
        this.monitoringThread.write(rawMessage);
    }

    @Override
    public synchronized void close() {
        this.monitoringThread.setTerminate(true);
        long waitTime = 5000L;
        while (!this.monitoringThread.isTerminated() && waitTime > 0L) {
            try {
                Thread.sleep(100L);
                waitTime -= 100L;
            }
            catch (InterruptedException ex) {
                _logger.error("Error,", (Throwable)ex);
            }
        }
        if (waitTime <= 0L) {
            _logger.warn("Terminating abnormally SerialPortMonitoringThread!");
        }
        this.monitoringThread.close();
    }

    @Override
    public synchronized GatewaySerial getGateway() {
        return this.monitoringThread.getGateway();
    }
}

