/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mysensors;

import java.util.List;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.mysensors.MySensorsRawMessage;
import org.mycontroller.standalone.mysensors.MySensorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySensorsNodeDiscover
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger((String)MySensorsNodeDiscover.class.getName());
    private int gatewayId;

    public MySensorsNodeDiscover(int gatewayId) {
        this.gatewayId = gatewayId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverNodes() {
        if (MySensorsUtils.isDiscoverRunning(this.gatewayId)) {
            _logger.warn("Node discover already running! nothing to do..");
            return;
        }
        MySensorsUtils.updateDiscoverRunning(this.gatewayId, true);
        try {
            _logger.debug("Starting Node discover util");
            List<Node> nodes = DaoUtils.getNodeDao().getAll(this.gatewayId);
            for (Node node : nodes) {
                MySensorsRawMessage mySensorsRawMessage = new MySensorsRawMessage(this.gatewayId, node.getEuiInt(), 255, MYCMessages.MESSAGE_TYPE.C_INTERNAL.ordinal(), 0, MYCMessages.MESSAGE_TYPE_INTERNAL.I_PRESENTATION.ordinal(), "", true);
                ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
            }
            _logger.debug("Node discover util completed");
        }
        finally {
            MySensorsUtils.updateDiscoverRunning(this.gatewayId, false);
        }
    }

    @Override
    public void run() {
        try {
            this.discoverNodes();
        }
        catch (Exception ex) {
            _logger.error("Error on node discover, ", (Throwable)ex);
        }
    }
}

