/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mysensors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayMQTT;
import org.mycontroller.standalone.message.RawMessage;
import org.mycontroller.standalone.message.RawMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MySensorsRawMessage {
    private static final Logger _logger = LoggerFactory.getLogger((String)MySensorsRawMessage.class.getName());
    private int gatewayId;
    private int nodeId;
    private int childSensorId;
    private int messageType;
    private int ack;
    private int subType;
    private String payload;
    private boolean isTxMessage = false;

    public MySensorsRawMessage(int gatewayId) {
        this.gatewayId = gatewayId;
    }

    public MySensorsRawMessage(RawMessage rawMessage) throws RawMessageException {
        this.gatewayId = rawMessage.getGatewayId();
        this.isTxMessage = rawMessage.isTxMessage();
        switch (ObjectFactory.getGateway(rawMessage.getGatewayId()).getGateway().getType()) {
            case MQTT: {
                this.updateMQTTMessage(rawMessage.getSubData(), rawMessage.getData());
                break;
            }
            case ETHERNET: 
            case SERIAL: {
                this.updateSerialMessage(rawMessage.getData());
                break;
            }
            default: {
                _logger.warn("This type not implemented yet, Type:[{}]", (Object)ObjectFactory.getGateway(rawMessage.getGatewayId()).getGateway().getType());
            }
        }
    }

    private void updateMQTTMessage(String topic, String message) throws RawMessageException {
        String[] msgArry;
        if (message != null) {
            this.payload = message;
        }
        if ((msgArry = topic.split("/")).length != 6) {
            _logger.debug("Unknown message format, Topic:[{}], PayLoad:[{}]", (Object)topic, (Object)message);
            throw new RawMessageException("Unknown message format, Topic:" + topic + ", PayLoad:" + message);
        }
        this.nodeId = Integer.valueOf(msgArry[1]);
        this.childSensorId = Integer.valueOf(msgArry[2]);
        this.messageType = Integer.valueOf(msgArry[3]);
        this.ack = Integer.valueOf(msgArry[4]);
        this.subType = Integer.valueOf(msgArry[5]);
        _logger.debug("Message: {}", (Object)this.toString());
    }

    private void updateSerialMessage(String gateWayMessage) throws RawMessageException {
        String[] msgArry;
        if (gateWayMessage.endsWith("\n")) {
            gateWayMessage = gateWayMessage.substring(0, gateWayMessage.length() - 1);
        }
        if ((msgArry = gateWayMessage.split(";")).length == 6) {
            this.payload = msgArry[5];
        }
        if (msgArry.length < 5) {
            _logger.debug("Unknown message format: [{}]", (Object)gateWayMessage);
            throw new RawMessageException("Unknown message format:[" + gateWayMessage + "]");
        }
        this.nodeId = Integer.valueOf(msgArry[0]);
        this.childSensorId = Integer.valueOf(msgArry[1]);
        this.messageType = Integer.valueOf(msgArry[2]);
        this.ack = Integer.valueOf(msgArry[3]);
        this.subType = Integer.valueOf(msgArry[4]);
        _logger.debug("Message: {}", (Object)this.toString());
    }

    public MySensorsRawMessage(int gatewayId, int nodeId, int childSensorId, int messageType, int ack, int subType, String payload, boolean isTxMessage) {
        this.gatewayId = gatewayId;
        this.nodeId = nodeId;
        this.childSensorId = childSensorId;
        this.messageType = messageType;
        this.ack = ack;
        this.subType = subType;
        this.payload = payload;
        this.isTxMessage = isTxMessage;
    }

    public MySensorsRawMessage(int gatewayId, int nodeId, int childSensorId, int messageType, int ack, int subType, String payload) {
        this(gatewayId, nodeId, childSensorId, messageType, ack, subType, payload, false);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getNodeEui() {
        return String.valueOf(this.nodeId);
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getChildSensorId() {
        return this.childSensorId;
    }

    public void setChildSensorId(int childSensorId) {
        this.childSensorId = childSensorId;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getAck() {
        return this.ack;
    }

    public void setAck(int ack) {
        this.ack = ack;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    public String getPayload() {
        return this.payload;
    }

    @JsonSetter
    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(Object payload) {
        this.payload = String.valueOf(payload);
    }

    public void setPayload(boolean payload) {
        this.payload = payload ? "1" : "0";
    }

    public Boolean getPayloadBoolean() {
        if (this.payload.trim().equalsIgnoreCase("0")) {
            return false;
        }
        if (Integer.valueOf(this.payload.trim()) > 0) {
            return true;
        }
        _logger.warn("Unable to convert as boolean, Unknown format:{}", (Object)this.payload);
        return null;
    }

    public Integer getPayloadInteger() {
        return Integer.valueOf(this.payload);
    }

    public String getPayloadString() {
        return this.payload;
    }

    public Double getPayloadDouble() {
        return Double.valueOf(this.payload);
    }

    public Float getPayloadFloat() {
        return Float.valueOf(this.payload);
    }

    public Byte getPayloadByte() {
        return Byte.valueOf(this.payload);
    }

    public byte[] getPayloadBytes() {
        return this.payload.getBytes();
    }

    public String toString() {
        StringBuffer message = new StringBuffer();
        message.append("NodeId:").append(this.nodeId).append(",");
        message.append("ChildSensorId:").append(this.childSensorId).append(",");
        message.append("MessageType:").append(this.messageType).append(",");
        message.append("Ack:").append(this.ack).append(",");
        message.append("SubType:").append(this.subType).append(",");
        message.append("Payload:").append(this.payload);
        return message.toString();
    }

    public String getGWString() {
        StringBuffer message = new StringBuffer();
        message.append(this.nodeId).append(";");
        message.append(this.childSensorId).append(";");
        message.append(this.messageType).append(";");
        message.append(this.ack).append(";");
        message.append(this.subType).append(";");
        message.append(this.payload).append("\n");
        return message.toString();
    }

    public String getMqttTopic() {
        StringBuilder builder = new StringBuilder();
        builder.append(((GatewayMQTT)ObjectFactory.getGateway(this.gatewayId).getGateway()).getTopicPublish());
        builder.append("/").append(this.getNodeId());
        builder.append("/").append(this.getChildSensorId());
        builder.append("/").append(this.getMessageType());
        builder.append("/").append(this.getAck());
        builder.append("/").append(this.getSubType());
        return builder.toString();
    }

    public byte[] getGWBytes() {
        return this.getGWString().getBytes();
    }

    public boolean isTxMessage() {
        return this.isTxMessage;
    }

    public void setTxMessage(boolean isTxMessage) {
        this.isTxMessage = isTxMessage;
    }

    public int getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(int gatewayId) {
        this.gatewayId = gatewayId;
    }

    public RawMessage getRawMessage() {
        Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(this.gatewayId);
        switch (gateway.getType()) {
            case MQTT: {
                return new RawMessage(this.gatewayId, this.getMqttTopic(), this.getPayload(), this.isTxMessage());
            }
            case ETHERNET: 
            case SERIAL: {
                return new RawMessage(this.gatewayId, this.getGWString(), null, this.isTxMessage());
            }
        }
        _logger.warn("This type not implemented yet, Type:[{}]", (Object)gateway.getType().name());
        return null;
    }
}

