/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.settings.SettingsUtils;

@JsonTypeName(value="mySensorsSettings")
public class MySensorsSettings {
    public static final String KEY_MY_SENSORS = "mySensors";
    public static final String SKEY_DEFAULT_FIRMWARE = "defaultFirmware";
    public static final String SKEY_ENABLE_DEFAULT_ON_NO_FIRMWARE = "enableDefaultOnNoFirmware";
    private Integer defaultFirmware;
    private Boolean enbaledDefaultOnNoFirmware;

    public static MySensorsSettings get() {
        return MySensorsSettings.builder().defaultFirmware(NumericUtils.getInteger(MySensorsSettings.getValue(SKEY_DEFAULT_FIRMWARE))).enbaledDefaultOnNoFirmware(NumericUtils.getBoolean(MySensorsSettings.getValue(SKEY_ENABLE_DEFAULT_ON_NO_FIRMWARE))).build();
    }

    public void save() {
        this.updateValue(SKEY_DEFAULT_FIRMWARE, this.defaultFirmware);
        this.updateValue(SKEY_ENABLE_DEFAULT_ON_NO_FIRMWARE, this.enbaledDefaultOnNoFirmware);
    }

    private static String getValue(String subKey) {
        return SettingsUtils.getValue(KEY_MY_SENSORS, subKey);
    }

    private void updateValue(String subKey, Object value) {
        SettingsUtils.updateValue(KEY_MY_SENSORS, subKey, value);
    }

    public static MySensorsSettingsBuilder builder() {
        return new MySensorsSettingsBuilder();
    }

    public String toString() {
        return "MySensorsSettings(defaultFirmware=" + this.getDefaultFirmware() + ", enbaledDefaultOnNoFirmware=" + this.getEnbaledDefaultOnNoFirmware() + ")";
    }

    public Integer getDefaultFirmware() {
        return this.defaultFirmware;
    }

    public Boolean getEnbaledDefaultOnNoFirmware() {
        return this.enbaledDefaultOnNoFirmware;
    }

    public MySensorsSettings() {
    }

    @ConstructorProperties(value={"defaultFirmware", "enbaledDefaultOnNoFirmware"})
    public MySensorsSettings(Integer defaultFirmware, Boolean enbaledDefaultOnNoFirmware) {
        this.defaultFirmware = defaultFirmware;
        this.enbaledDefaultOnNoFirmware = enbaledDefaultOnNoFirmware;
    }

    public static class MySensorsSettingsBuilder {
        private Integer defaultFirmware;
        private Boolean enbaledDefaultOnNoFirmware;

        MySensorsSettingsBuilder() {
        }

        public MySensorsSettingsBuilder defaultFirmware(Integer defaultFirmware) {
            this.defaultFirmware = defaultFirmware;
            return this;
        }

        public MySensorsSettingsBuilder enbaledDefaultOnNoFirmware(Boolean enbaledDefaultOnNoFirmware) {
            this.enbaledDefaultOnNoFirmware = enbaledDefaultOnNoFirmware;
            return this;
        }

        public MySensorsSettings build() {
            return new MySensorsSettings(this.defaultFirmware, this.enbaledDefaultOnNoFirmware);
        }

        public String toString() {
            return "MySensorsSettings.MySensorsSettingsBuilder(defaultFirmware=" + this.defaultFirmware + ", enbaledDefaultOnNoFirmware=" + this.enbaledDefaultOnNoFirmware + ")";
        }
    }
}

