/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.db.tables.Settings;
import org.mycontroller.standalone.settings.SettingsUtils;
import org.mycontroller.standalone.settings.Unit;

@JsonTypeName(value="unitSettings")
public class UnitsSettings {
    public static final String KEY_VARIABLE_UNIT = "variableUnit";
    private List<Unit> variables;

    public static UnitsSettings get() {
        ArrayList<Unit> variables = new ArrayList<Unit>();
        Settings settings = null;
        for (MYCMessages.MESSAGE_TYPE_SET_REQ sVariable : Unit.variables) {
            settings = UnitsSettings.getSettings(sVariable.getText());
            if (settings == null) continue;
            variables.add(new Unit(sVariable.getText(), settings.getValue(), settings.getAltValue()));
        }
        return UnitsSettings.builder().variables(variables).build();
    }

    public void save() {
        for (Unit unit : this.variables) {
            if (!Unit.variables.contains((Object)MYCMessages.MESSAGE_TYPE_SET_REQ.fromString(unit.getVariable()))) continue;
            this.updateValue(unit.getVariable(), unit.getMetric(), unit.getImperial());
        }
    }

    private static Settings getSettings(String subKey) {
        return SettingsUtils.getSettings(KEY_VARIABLE_UNIT, subKey);
    }

    private void updateValue(String subKey, Object value, Object altValue) {
        SettingsUtils.updateValue(KEY_VARIABLE_UNIT, subKey, value, altValue);
    }

    public static UnitsSettingsBuilder builder() {
        return new UnitsSettingsBuilder();
    }

    public String toString() {
        return "UnitsSettings(variables=" + this.getVariables() + ")";
    }

    public List<Unit> getVariables() {
        return this.variables;
    }

    public UnitsSettings() {
    }

    @ConstructorProperties(value={"variables"})
    public UnitsSettings(List<Unit> variables) {
        this.variables = variables;
    }

    public static class UnitsSettingsBuilder {
        private List<Unit> variables;

        UnitsSettingsBuilder() {
        }

        public UnitsSettingsBuilder variables(List<Unit> variables) {
            this.variables = variables;
            return this;
        }

        public UnitsSettings build() {
            return new UnitsSettings(this.variables);
        }

        public String toString() {
            return "UnitsSettings.UnitsSettingsBuilder(variables=" + this.variables + ")";
        }
    }
}

