/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.AppShutdownHook;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.AlarmHandler;
import org.mycontroller.standalone.api.jaxrs.AuthenticationHandler;
import org.mycontroller.standalone.api.jaxrs.FirmwareHandler;
import org.mycontroller.standalone.api.jaxrs.ForwardPayloadHandler;
import org.mycontroller.standalone.api.jaxrs.GatewayHandler;
import org.mycontroller.standalone.api.jaxrs.MetricsHandler;
import org.mycontroller.standalone.api.jaxrs.MyControllerHandler;
import org.mycontroller.standalone.api.jaxrs.NodeHandler;
import org.mycontroller.standalone.api.jaxrs.PermitAllHandler;
import org.mycontroller.standalone.api.jaxrs.ResourcesGroupHandler;
import org.mycontroller.standalone.api.jaxrs.ResourcesLogsHandler;
import org.mycontroller.standalone.api.jaxrs.SensorHandler;
import org.mycontroller.standalone.api.jaxrs.SettingsHandler;
import org.mycontroller.standalone.api.jaxrs.TimerHandler;
import org.mycontroller.standalone.api.jaxrs.TypesHandler;
import org.mycontroller.standalone.api.jaxrs.UidTagHandler;
import org.mycontroller.standalone.api.jaxrs.UserHandler;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.ApplicationExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.BadRequestExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.DefaultOptionsMethodExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.ForbiddenExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.NotAcceptableExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.NotAllowedExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.NotFoundExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.exception.mappers.NotSupportedExceptionMapper;
import org.mycontroller.standalone.api.jaxrs.mixins.McJacksonJson2Provider;
import org.mycontroller.standalone.auth.BasicAthenticationSecurityDomain;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DataBaseUtils;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.message.MessageMonitorThread;
import org.mycontroller.standalone.message.RawMessageQueue;
import org.mycontroller.standalone.mqttbroker.MoquetteMqttBroker;
import org.mycontroller.standalone.mysensors.MySensorsIActionEngine;
import org.mycontroller.standalone.scheduler.SchedulerUtils;
import org.mycontroller.standalone.timer.TimerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartApp {
    private static final Logger _logger = LoggerFactory.getLogger((String)StartApp.class.getName());
    static final TJWSEmbeddedJaxrsServer server = new TJWSEmbeddedJaxrsServer();
    static ResteasyDeployment deployment;
    static long start;

    public static void main(String[] args) {
        try {
            start = System.currentTimeMillis();
            StartApp.loadInitialProperties();
            _logger.debug("App Properties: {}", (Object)ObjectFactory.getAppProperties().toString());
            _logger.debug("Operating System detail:[os:{},arch:{},version:{}]", new Object[]{AppProperties.getOsName(), AppProperties.getOsArch(), AppProperties.getOsVersion()});
            StartApp.startServices();
            _logger.info("MyController.org server started in [{}] ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception ex) {
            _logger.error("Unable to start application, refer error log,", (Throwable)ex);
            System.exit(1);
        }
    }

    private static void addGateway() {
        if (DaoUtils.getGatewayDao().getAll().isEmpty()) {
            GatewaySerial gateway = new GatewaySerial();
            gateway.setEnabled(true);
            gateway.setType(GatewayUtils.TYPE.SERIAL);
            gateway.setNetworkType(AppProperties.NETWORK_TYPE.MY_SENSORS);
            gateway.setName("Serial-gateway");
            gateway.setPortName("/dev/ttyUSB0");
            gateway.setBaudRate(115200);
            gateway.setDriver(GatewayUtils.SERIAL_PORT_DRIVER.AUTO);
            gateway.setRetryFrequency(60);
            DaoUtils.getGatewayDao().create(gateway.getGateway());
        }
    }

    private static void loadStartingValues() {
        try {
            TimerUtils.updateSunriseSunset();
            _logger.debug("Sunrise[{}], Sunset[{}] time updated", (Object)TimerUtils.getSunriseTime(), (Object)TimerUtils.getSunsetTime());
            ObjectFactory.addIActionEngine(AppProperties.NETWORK_TYPE.MY_SENSORS, new MySensorsIActionEngine());
        }
        catch (Exception ex) {
            _logger.error("Failed to update sunrise/sunset time", (Throwable)ex);
        }
    }

    private static ResteasyDeployment getResteasyDeployment() {
        if (deployment == null) {
            deployment = new ResteasyDeployment();
        }
        ArrayList<String> resources = new ArrayList<String>();
        resources.add(MyControllerHandler.class.getName());
        resources.add(NodeHandler.class.getName());
        resources.add(SensorHandler.class.getName());
        resources.add(TypesHandler.class.getName());
        resources.add(MetricsHandler.class.getName());
        resources.add(AuthenticationHandler.class.getName());
        resources.add(UserHandler.class.getName());
        resources.add(AlarmHandler.class.getName());
        resources.add(ResourcesLogsHandler.class.getName());
        resources.add(TimerHandler.class.getName());
        resources.add(ForwardPayloadHandler.class.getName());
        resources.add(UidTagHandler.class.getName());
        resources.add(FirmwareHandler.class.getName());
        resources.add(SettingsHandler.class.getName());
        resources.add(GatewayHandler.class.getName());
        resources.add(ResourcesGroupHandler.class.getName());
        resources.add(PermitAllHandler.class.getName());
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new BadRequestExceptionMapper());
        providers.add(new NotAcceptableExceptionMapper());
        providers.add(new NotAllowedExceptionMapper());
        providers.add(new NotFoundExceptionMapper());
        providers.add(new NotSupportedExceptionMapper());
        providers.add(new DefaultOptionsMethodExceptionMapper());
        providers.add(new ForbiddenExceptionMapper());
        providers.add(new ApplicationExceptionMapper());
        providers.add((Object)new McJacksonJson2Provider());
        deployment.setResourceClasses(resources);
        deployment.setProviders(providers);
        return deployment;
    }

    private static void startHTTPWebServer() {
        if (ObjectFactory.getAppProperties().isWebHttpsEnabled()) {
            server.setSSLPort(ObjectFactory.getAppProperties().getWebHttpPort());
            server.setSSLKeyStoreFile(ObjectFactory.getAppProperties().getWebSslKeystoreFile());
            server.setSSLKeyStorePass(ObjectFactory.getAppProperties().getWebSslKeystorePassword());
            server.setSSLKeyStoreType(ObjectFactory.getAppProperties().getWebSslKeystoreType());
        } else {
            server.setPort(ObjectFactory.getAppProperties().getWebHttpPort());
        }
        if (ObjectFactory.getAppProperties().getWebBindAddress() != null) {
            server.setBindAddress(ObjectFactory.getAppProperties().getWebBindAddress());
        }
        server.setDeployment(StartApp.getResteasyDeployment());
        server.addFileMapping("/", new File(ObjectFactory.getAppProperties().getWebFileLocation()));
        server.setSecurityDomain((SecurityDomain)new BasicAthenticationSecurityDomain());
        server.getDeployment().setSecurityEnabled(true);
        server.setRootResourcePath("/mc");
        server.start();
        _logger.info("TJWS server started successfully, HTTPS Enabled?:{}, HTTP(S) Port: [{}]", (Object)ObjectFactory.getAppProperties().isWebHttpsEnabled(), (Object)ObjectFactory.getAppProperties().getWebHttpPort());
    }

    private static boolean startServices() throws ClassNotFoundException, SQLException {
        new AppShutdownHook().attachShutDownHook();
        DataBaseUtils.loadDatabase();
        ObjectFactory.setRawMessageQueue(new RawMessageQueue());
        MessageMonitorThread messageMonitorThread = new MessageMonitorThread();
        Thread thread = new Thread(messageMonitorThread);
        thread.start();
        StartApp.loadStartingValues();
        MoquetteMqttBroker.start();
        StartApp.addGateway();
        GatewayUtils.loadAllGateways();
        SchedulerUtils.startScheduler();
        StartApp.startHTTPWebServer();
        return true;
    }

    public static synchronized void stopServices() {
        SchedulerUtils.stop();
        GatewayUtils.unloadAllGateways();
        MoquetteMqttBroker.stop();
        MessageMonitorThread.setTerminationIssued(true);
        DataBaseUtils.stop();
        _logger.debug("All services stopped. Shutting down...");
        _logger.info("Bye, Have a nice day! See you soon");
    }

    private static boolean loadInitialProperties() {
        String propertiesFile = System.getProperty("mc.conf.file");
        try {
            Properties properties = new Properties();
            if (propertiesFile == null) {
                properties.load(ClassLoader.getSystemClassLoader().getResourceAsStream("mycontroller.properties"));
            } else {
                properties.load(new FileReader(propertiesFile));
            }
            AppProperties appProperties = new AppProperties(properties);
            ObjectFactory.setAppProperties(appProperties);
            _logger.debug("Properties are loaded successfuly...");
            return true;
        }
        catch (IOException ex) {
            _logger.error("Exception while loading properties file, ", (Throwable)ex);
            return false;
        }
    }
}

