/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs.utils;

import org.mycontroller.standalone.api.jaxrs.utils.StatusBase;

public class StatusOS
extends StatusBase {
    public String getName() {
        return operatingSystemMXBean.getName();
    }

    public String getUserWorkingDir() {
        return System.getProperty("user.dir");
    }

    public String getJavaHome() {
        return System.getProperty("java.home");
    }

    public String getJavaVendorUrl() {
        return System.getProperty("java.vendor.url");
    }

    public String getArch() {
        return operatingSystemMXBean.getArch();
    }

    public String getVersion() {
        return operatingSystemMXBean.getVersion();
    }

    public int getAvailableProcess() {
        return operatingSystemMXBean.getAvailableProcessors();
    }

    public String getSystemLoadAverage() {
        if (operatingSystemMXBean.getSystemLoadAverage() >= 0.0) {
            return String.format("%.2f %%", operatingSystemMXBean.getSystemLoadAverage() * 100.0);
        }
        return "n/a";
    }

    public long getCommittedVirtualMemorySize() {
        return operatingSystemMXBean.getCommittedVirtualMemorySize();
    }

    public long getFreePhysicalMemorySize() {
        return operatingSystemMXBean.getFreePhysicalMemorySize();
    }

    public long getFreeSwapSpaceSize() {
        return operatingSystemMXBean.getFreeSwapSpaceSize();
    }

    public String getProcessCpuLoad() {
        if (operatingSystemMXBean.getProcessCpuLoad() >= 0.0) {
            return String.format("%.2f %%", operatingSystemMXBean.getProcessCpuLoad() * 100.0);
        }
        return "n/a";
    }

    public String getProcessCpuTime() {
        if (operatingSystemMXBean.getProcessCpuTime() >= 0L) {
            return String.format("%d milliseconds", operatingSystemMXBean.getProcessCpuTime() / 1000000L);
        }
        return "n/a";
    }

    public String getSystemCpuLoad() {
        if (operatingSystemMXBean.getSystemCpuLoad() >= 0.0) {
            return String.format("%.2f %%", operatingSystemMXBean.getSystemCpuLoad() * 100.0);
        }
        return "n/a";
    }

    public long getTotalPhysicalMemorySize() {
        return operatingSystemMXBean.getTotalPhysicalMemorySize();
    }

    public long getTotalSwapSpaceSize() {
        return operatingSystemMXBean.getTotalSwapSpaceSize();
    }
}

