/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.auth;

import java.security.Principal;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.mycontroller.standalone.auth.USER_ROLE;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAthenticationSecurityDomain
implements SecurityDomain {
    private static final Logger _logger = LoggerFactory.getLogger((String)BasicAthenticationSecurityDomain.class.getName());

    public Principal authenticate(String aUsername, String aPassword) throws SecurityException {
        _logger.debug("HTTP authentication: User:{}", (Object)aUsername);
        User user = DaoUtils.getUserDao().get(aUsername);
        if (user != null) {
            _logger.debug("User Found...User:{}", (Object)user);
            if (user.getPassword().equals(aPassword)) {
                user.setPassword(null);
                return user;
            }
        }
        throw new SecurityException("Access denied to user " + aUsername);
    }

    public boolean isUserInRole(Principal principal, String role) {
        User user = (User)principal;
        _logger.debug("isUserInRole called with role[{}], user[{}]", (Object)role, (Object)user);
        if (USER_ROLE.ADMIN.toString().equalsIgnoreCase(user.getRole())) {
            return true;
        }
        if (role.equalsIgnoreCase(user.getRole())) {
            return true;
        }
        _logger.info("Roles Mismatch, api role[{}], user role[{}]", (Object)role, (Object)user.getRole());
        return false;
    }

    public static boolean login(String aUsername, String aPassword) {
        if (aUsername == null || aPassword == null) {
            return false;
        }
        _logger.debug("User:{},Password:{}", (Object)aUsername, (Object)aPassword);
        User user = DaoUtils.getUserDao().get(aUsername);
        if (user != null) {
            _logger.debug("User Found...User:{}", (Object)user);
            if (user.getPassword().equals(aPassword)) {
                return true;
            }
        }
        return false;
    }
}

