/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.MetricsDoubleTypeDeviceDao;
import org.mycontroller.standalone.db.tables.MetricsDoubleTypeDevice;
import org.mycontroller.standalone.metrics.MetricsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsDoubleTypeDeviceDaoImpl
extends BaseAbstractDaoImpl<MetricsDoubleTypeDevice, Object>
implements MetricsDoubleTypeDeviceDao {
    private static final Logger _logger = LoggerFactory.getLogger(MetricsDoubleTypeDeviceDaoImpl.class);

    public MetricsDoubleTypeDeviceDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, MetricsDoubleTypeDevice.class);
    }

    @Override
    public void deletePrevious(MetricsDoubleTypeDevice metric) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("aggregationType", (Object)metric.getAggregationType()).and().le("timestamp", (Object)metric.getTimestamp());
            int count = this.getDao().delete(deleteBuilder.prepare());
            _logger.debug("Metric:[{}] deleted, Delete count:{}", (Object)metric, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete metric:[{}]", (Object)metric, (Object)ex);
        }
    }

    @Override
    public void deleteBySensorVariableRefId(int sensorValueRefId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("sensorVariableId", (Object)sensorValueRefId);
            int count = deleteBuilder.delete();
            _logger.debug("Metric-sensorValueRefId:[{}] deleted, Delete count:{}", (Object)sensorValueRefId, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete metric-sensorValueRefId:[{}]", (Object)sensorValueRefId, (Object)ex);
        }
    }

    @Override
    public List<MetricsDoubleTypeDevice> getAll(MetricsDoubleTypeDevice metric) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            Where whereBuilder = queryBuilder.where();
            whereBuilder.eq("sensorVariableId", (Object)metric.getSensorVariable().getId());
            if (metric.getAggregationType() != null) {
                whereBuilder.and().eq("aggregationType", (Object)metric.getAggregationType());
            }
            if (metric.getTimestampFrom() != null) {
                whereBuilder.and().gt("timestamp", (Object)metric.getTimestampFrom());
            }
            if (metric.getTimestampTo() != null) {
                whereBuilder.and().le("timestamp", (Object)metric.getTimestampTo());
            }
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get, metric:{}", (Object)metric, (Object)ex);
            return null;
        }
    }

    @Override
    public MetricsDoubleTypeDevice get(MetricsDoubleTypeDevice metric) {
        try {
            return (MetricsDoubleTypeDevice)this.getDao().queryForFirst(this.getDao().queryBuilder().where().eq("sensorVariableId", (Object)metric.getSensorVariable().getId()).and().eq("aggregationType", (Object)metric.getAggregationType()).and().eq("timestamp", (Object)metric.getTimestamp()).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get, metric:{}", (Object)metric, (Object)ex);
            return null;
        }
    }

    @Override
    public List<MetricsDoubleTypeDevice> getAll(List<Object> ids) {
        return null;
    }

    @Override
    public List<MetricsDoubleTypeDevice> getAggregationRequiredVariableIds(MetricsUtils.AGGREGATION_TYPE aggregationType, Long fromTimestamp, Long toTimestamp) {
        QueryBuilder queryBuilder = this.getDao().queryBuilder();
        try {
            return queryBuilder.distinct().selectColumns(new String[]{"sensorVariableId"}).where().eq("aggregationType", (Object)aggregationType).and().gt("timestamp", (Object)fromTimestamp).and().le("timestamp", (Object)toTimestamp).query();
        }
        catch (SQLException ex) {
            _logger.error("Exception,", (Throwable)ex);
            return null;
        }
    }
}

