/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import java.util.List;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.db.SensorUtils;
import org.mycontroller.standalone.db.tables.Node;

@DatabaseTable(tableName="sensor")
public class Sensor {
    public static final String KEY_ID = "id";
    public static final String KEY_SENSOR_ID = "sensorId";
    public static final String KEY_NODE_ID = "nodeId";
    public static final String KEY_NODE_NAME = "nodeName";
    public static final String KEY_NAME = "name";
    public static final String KEY_LAST_SEEN = "lastSeen";
    public static final String KEY_TYPE = "type";
    @DatabaseField(generatedId=true, columnName="id")
    private Integer id;
    @DatabaseField(canBeNull=false, index=true, uniqueCombo=true, columnName="sensorId")
    private Integer sensorId;
    @DatabaseField(dataType=DataType.ENUM_STRING, columnName="type")
    private MYCMessages.MESSAGE_TYPE_PRESENTATION type;
    @DatabaseField(columnName="name")
    private String name;
    @DatabaseField(columnName="lastSeen")
    private Long lastSeen;
    @DatabaseField(canBeNull=false, foreign=true, uniqueCombo=true, columnName="nodeId", foreignAutoRefresh=true, maxForeignAutoRefreshLevel=2)
    private Node node;
    private List<String> variableTypes;

    public List<String> getVariableTypes() {
        if (this.variableTypes == null) {
            this.variableTypes = SensorUtils.getVariableTypes(this);
        }
        return this.variableTypes;
    }

    @JsonGetter
    private Integer getIdforVariables() {
        return this.id;
    }

    public static SensorBuilder builder() {
        return new SensorBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getSensorId() {
        return this.sensorId;
    }

    public MYCMessages.MESSAGE_TYPE_PRESENTATION getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Long getLastSeen() {
        return this.lastSeen;
    }

    public Node getNode() {
        return this.node;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSensorId(Integer sensorId) {
        this.sensorId = sensorId;
    }

    public void setType(MYCMessages.MESSAGE_TYPE_PRESENTATION type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setVariableTypes(List<String> variableTypes) {
        this.variableTypes = variableTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sensor)) {
            return false;
        }
        Sensor other = (Sensor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$sensorId = this.getSensorId();
        Integer other$sensorId = other.getSensorId();
        if (this$sensorId == null ? other$sensorId != null : !((Object)this$sensorId).equals(other$sensorId)) {
            return false;
        }
        MYCMessages.MESSAGE_TYPE_PRESENTATION this$type = this.getType();
        MYCMessages.MESSAGE_TYPE_PRESENTATION other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Long this$lastSeen = this.getLastSeen();
        Long other$lastSeen = other.getLastSeen();
        if (this$lastSeen == null ? other$lastSeen != null : !((Object)this$lastSeen).equals(other$lastSeen)) {
            return false;
        }
        Node this$node = this.getNode();
        Node other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        List<String> this$variableTypes = this.getVariableTypes();
        List<String> other$variableTypes = other.getVariableTypes();
        return !(this$variableTypes == null ? other$variableTypes != null : !((Object)this$variableTypes).equals(other$variableTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sensor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $sensorId = this.getSensorId();
        result = result * 59 + ($sensorId == null ? 43 : ((Object)$sensorId).hashCode());
        MYCMessages.MESSAGE_TYPE_PRESENTATION $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Long $lastSeen = this.getLastSeen();
        result = result * 59 + ($lastSeen == null ? 43 : ((Object)$lastSeen).hashCode());
        Node $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        List<String> $variableTypes = this.getVariableTypes();
        result = result * 59 + ($variableTypes == null ? 43 : ((Object)$variableTypes).hashCode());
        return result;
    }

    public Sensor() {
    }

    @ConstructorProperties(value={"id", "sensorId", "type", "name", "lastSeen", "node", "variableTypes"})
    public Sensor(Integer id, Integer sensorId, MYCMessages.MESSAGE_TYPE_PRESENTATION type, String name, Long lastSeen, Node node, List<String> variableTypes) {
        this.id = id;
        this.sensorId = sensorId;
        this.type = type;
        this.name = name;
        this.lastSeen = lastSeen;
        this.node = node;
        this.variableTypes = variableTypes;
    }

    public String toString() {
        return "Sensor(id=" + this.getId() + ", sensorId=" + this.getSensorId() + ", type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", lastSeen=" + this.getLastSeen() + ", node=" + this.getNode() + ", variableTypes=" + this.getVariableTypes() + ")";
    }

    public static class SensorBuilder {
        private Integer id;
        private Integer sensorId;
        private MYCMessages.MESSAGE_TYPE_PRESENTATION type;
        private String name;
        private Long lastSeen;
        private Node node;
        private List<String> variableTypes;

        SensorBuilder() {
        }

        public SensorBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public SensorBuilder sensorId(Integer sensorId) {
            this.sensorId = sensorId;
            return this;
        }

        public SensorBuilder type(MYCMessages.MESSAGE_TYPE_PRESENTATION type) {
            this.type = type;
            return this;
        }

        public SensorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SensorBuilder lastSeen(Long lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public SensorBuilder node(Node node) {
            this.node = node;
            return this;
        }

        public SensorBuilder variableTypes(List<String> variableTypes) {
            this.variableTypes = variableTypes;
            return this;
        }

        public Sensor build() {
            return new Sensor(this.id, this.sensorId, this.type, this.name, this.lastSeen, this.node, this.variableTypes);
        }

        public String toString() {
            return "Sensor.SensorBuilder(id=" + this.id + ", sensorId=" + this.sensorId + ", type=" + (Object)((Object)this.type) + ", name=" + this.name + ", lastSeen=" + this.lastSeen + ", node=" + this.node + ", variableTypes=" + this.variableTypes + ")";
        }
    }
}

