/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.db.PayloadOperation;
import org.mycontroller.standalone.db.PayloadOperationUtils;
import org.mycontroller.standalone.model.ResourceModel;
import org.mycontroller.standalone.timer.TimerUtils;

@DatabaseTable(tableName="timer")
public class Timer {
    public static final String KEY_ID = "id";
    public static final String KEY_NAME = "name";
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_RESOURCE_TYPE = "resourceType";
    public static final String KEY_RESOURCE_ID = "resourceId";
    public static final String KEY_TIMER_TYPE = "timerType";
    public static final String KEY_FREQUENCY = "frequency";
    public static final String KEY_LAST_FIRED = "lastFired";
    @DatabaseField(generatedId=true)
    private Integer id;
    @DatabaseField(canBeNull=false, columnName="enabled")
    private Boolean enabled;
    @DatabaseField(canBeNull=false, uniqueCombo=true, columnName="name")
    private String name;
    @DatabaseField(dataType=DataType.ENUM_INTEGER, canBeNull=false, columnName="resourceType")
    private AppProperties.RESOURCE_TYPE resourceType;
    @DatabaseField(canBeNull=false, columnName="resourceId")
    private Integer resourceId;
    @DatabaseField(dataType=DataType.ENUM_STRING, canBeNull=false, columnName="timerType")
    private TimerUtils.TIMER_TYPE timerType;
    @DatabaseField(dataType=DataType.ENUM_STRING, canBeNull=true, columnName="frequency")
    private TimerUtils.FREQUENCY_TYPE frequencyType;
    @DatabaseField(canBeNull=true)
    private String frequencyData;
    @DatabaseField(canBeNull=true)
    private Long triggerTime;
    @DatabaseField(canBeNull=true)
    private Long validityFrom;
    @DatabaseField(canBeNull=true)
    private Long validityTo;
    @DatabaseField(canBeNull=false)
    private String payload;
    @DatabaseField(canBeNull=true, columnName="lastFired")
    private Long lastFired;
    @DatabaseField(canBeNull=true)
    private String internalVariable1;

    public String getTimerDataString() {
        try {
            return TimerUtils.getTimerDataString(this);
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }

    public String getValidityString() {
        return TimerUtils.getValidityString(this);
    }

    public void setFrequencyData(String frequencyData) {
        if (frequencyData != null && frequencyData.length() > 0) {
            this.frequencyData = frequencyData;
        }
    }

    public void setValidityFrom(Long validFrom) {
        this.validityFrom = validFrom;
    }

    public void setValidityTo(Long validTo) {
        this.validityTo = validTo;
    }

    public String getPayloadFormatted() {
        StringBuilder builder = new StringBuilder();
        PayloadOperation specialOperation = new PayloadOperation(this.payload);
        if (specialOperation.getOperationType() != null) {
            if (specialOperation.getOperationType() == PayloadOperationUtils.SEND_PAYLOAD_OPERATIONS.REBOOT) {
                builder.append(" ").append(specialOperation.getOperationType().getText());
            } else if (specialOperation.getValue() != null) {
                builder.append(" {resource.value} ").append(specialOperation.getOperationType().getText()).append(" ").append(NumericUtils.getDoubleAsString(specialOperation.getValue()));
            } else {
                builder.append(specialOperation.getOperationType().getText());
            }
        } else {
            builder.append(this.payload);
        }
        return builder.toString();
    }

    public String getResource() {
        ResourceModel resourceModel = new ResourceModel(this.resourceType, this.resourceId);
        return resourceModel.getResourceLessDetails();
    }

    public static TimerBuilder builder() {
        return new TimerBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public AppProperties.RESOURCE_TYPE getResourceType() {
        return this.resourceType;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public TimerUtils.TIMER_TYPE getTimerType() {
        return this.timerType;
    }

    public TimerUtils.FREQUENCY_TYPE getFrequencyType() {
        return this.frequencyType;
    }

    public String getFrequencyData() {
        return this.frequencyData;
    }

    public Long getTriggerTime() {
        return this.triggerTime;
    }

    public Long getValidityFrom() {
        return this.validityFrom;
    }

    public Long getValidityTo() {
        return this.validityTo;
    }

    public String getPayload() {
        return this.payload;
    }

    public Long getLastFired() {
        return this.lastFired;
    }

    public String getInternalVariable1() {
        return this.internalVariable1;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResourceType(AppProperties.RESOURCE_TYPE resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public void setTimerType(TimerUtils.TIMER_TYPE timerType) {
        this.timerType = timerType;
    }

    public void setFrequencyType(TimerUtils.FREQUENCY_TYPE frequencyType) {
        this.frequencyType = frequencyType;
    }

    public void setTriggerTime(Long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setLastFired(Long lastFired) {
        this.lastFired = lastFired;
    }

    public void setInternalVariable1(String internalVariable1) {
        this.internalVariable1 = internalVariable1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Timer)) {
            return false;
        }
        Timer other = (Timer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AppProperties.RESOURCE_TYPE this$resourceType = this.getResourceType();
        AppProperties.RESOURCE_TYPE other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        Integer this$resourceId = this.getResourceId();
        Integer other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !((Object)this$resourceId).equals(other$resourceId)) {
            return false;
        }
        TimerUtils.TIMER_TYPE this$timerType = this.getTimerType();
        TimerUtils.TIMER_TYPE other$timerType = other.getTimerType();
        if (this$timerType == null ? other$timerType != null : !((Object)((Object)this$timerType)).equals((Object)other$timerType)) {
            return false;
        }
        TimerUtils.FREQUENCY_TYPE this$frequencyType = this.getFrequencyType();
        TimerUtils.FREQUENCY_TYPE other$frequencyType = other.getFrequencyType();
        if (this$frequencyType == null ? other$frequencyType != null : !((Object)((Object)this$frequencyType)).equals((Object)other$frequencyType)) {
            return false;
        }
        String this$frequencyData = this.getFrequencyData();
        String other$frequencyData = other.getFrequencyData();
        if (this$frequencyData == null ? other$frequencyData != null : !this$frequencyData.equals(other$frequencyData)) {
            return false;
        }
        Long this$triggerTime = this.getTriggerTime();
        Long other$triggerTime = other.getTriggerTime();
        if (this$triggerTime == null ? other$triggerTime != null : !((Object)this$triggerTime).equals(other$triggerTime)) {
            return false;
        }
        Long this$validityFrom = this.getValidityFrom();
        Long other$validityFrom = other.getValidityFrom();
        if (this$validityFrom == null ? other$validityFrom != null : !((Object)this$validityFrom).equals(other$validityFrom)) {
            return false;
        }
        Long this$validityTo = this.getValidityTo();
        Long other$validityTo = other.getValidityTo();
        if (this$validityTo == null ? other$validityTo != null : !((Object)this$validityTo).equals(other$validityTo)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Long this$lastFired = this.getLastFired();
        Long other$lastFired = other.getLastFired();
        if (this$lastFired == null ? other$lastFired != null : !((Object)this$lastFired).equals(other$lastFired)) {
            return false;
        }
        String this$internalVariable1 = this.getInternalVariable1();
        String other$internalVariable1 = other.getInternalVariable1();
        return !(this$internalVariable1 == null ? other$internalVariable1 != null : !this$internalVariable1.equals(other$internalVariable1));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Timer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AppProperties.RESOURCE_TYPE $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        Integer $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : ((Object)$resourceId).hashCode());
        TimerUtils.TIMER_TYPE $timerType = this.getTimerType();
        result = result * 59 + ($timerType == null ? 43 : ((Object)((Object)$timerType)).hashCode());
        TimerUtils.FREQUENCY_TYPE $frequencyType = this.getFrequencyType();
        result = result * 59 + ($frequencyType == null ? 43 : ((Object)((Object)$frequencyType)).hashCode());
        String $frequencyData = this.getFrequencyData();
        result = result * 59 + ($frequencyData == null ? 43 : $frequencyData.hashCode());
        Long $triggerTime = this.getTriggerTime();
        result = result * 59 + ($triggerTime == null ? 43 : ((Object)$triggerTime).hashCode());
        Long $validityFrom = this.getValidityFrom();
        result = result * 59 + ($validityFrom == null ? 43 : ((Object)$validityFrom).hashCode());
        Long $validityTo = this.getValidityTo();
        result = result * 59 + ($validityTo == null ? 43 : ((Object)$validityTo).hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Long $lastFired = this.getLastFired();
        result = result * 59 + ($lastFired == null ? 43 : ((Object)$lastFired).hashCode());
        String $internalVariable1 = this.getInternalVariable1();
        result = result * 59 + ($internalVariable1 == null ? 43 : $internalVariable1.hashCode());
        return result;
    }

    public Timer() {
    }

    @ConstructorProperties(value={"id", "enabled", "name", "resourceType", "resourceId", "timerType", "frequencyType", "frequencyData", "triggerTime", "validityFrom", "validityTo", "payload", "lastFired", "internalVariable1"})
    public Timer(Integer id, Boolean enabled, String name, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, TimerUtils.TIMER_TYPE timerType, TimerUtils.FREQUENCY_TYPE frequencyType, String frequencyData, Long triggerTime, Long validityFrom, Long validityTo, String payload, Long lastFired, String internalVariable1) {
        this.id = id;
        this.enabled = enabled;
        this.name = name;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.timerType = timerType;
        this.frequencyType = frequencyType;
        this.frequencyData = frequencyData;
        this.triggerTime = triggerTime;
        this.validityFrom = validityFrom;
        this.validityTo = validityTo;
        this.payload = payload;
        this.lastFired = lastFired;
        this.internalVariable1 = internalVariable1;
    }

    public String toString() {
        return "Timer(id=" + this.getId() + ", enabled=" + this.getEnabled() + ", name=" + this.getName() + ", resourceType=" + (Object)((Object)this.getResourceType()) + ", resourceId=" + this.getResourceId() + ", timerType=" + (Object)((Object)this.getTimerType()) + ", frequencyType=" + (Object)((Object)this.getFrequencyType()) + ", frequencyData=" + this.getFrequencyData() + ", triggerTime=" + this.getTriggerTime() + ", validityFrom=" + this.getValidityFrom() + ", validityTo=" + this.getValidityTo() + ", payload=" + this.getPayload() + ", lastFired=" + this.getLastFired() + ", internalVariable1=" + this.getInternalVariable1() + ")";
    }

    public static class TimerBuilder {
        private Integer id;
        private Boolean enabled;
        private String name;
        private AppProperties.RESOURCE_TYPE resourceType;
        private Integer resourceId;
        private TimerUtils.TIMER_TYPE timerType;
        private TimerUtils.FREQUENCY_TYPE frequencyType;
        private String frequencyData;
        private Long triggerTime;
        private Long validityFrom;
        private Long validityTo;
        private String payload;
        private Long lastFired;
        private String internalVariable1;

        TimerBuilder() {
        }

        public TimerBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public TimerBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TimerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TimerBuilder resourceType(AppProperties.RESOURCE_TYPE resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public TimerBuilder resourceId(Integer resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public TimerBuilder timerType(TimerUtils.TIMER_TYPE timerType) {
            this.timerType = timerType;
            return this;
        }

        public TimerBuilder frequencyType(TimerUtils.FREQUENCY_TYPE frequencyType) {
            this.frequencyType = frequencyType;
            return this;
        }

        public TimerBuilder frequencyData(String frequencyData) {
            this.frequencyData = frequencyData;
            return this;
        }

        public TimerBuilder triggerTime(Long triggerTime) {
            this.triggerTime = triggerTime;
            return this;
        }

        public TimerBuilder validityFrom(Long validityFrom) {
            this.validityFrom = validityFrom;
            return this;
        }

        public TimerBuilder validityTo(Long validityTo) {
            this.validityTo = validityTo;
            return this;
        }

        public TimerBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public TimerBuilder lastFired(Long lastFired) {
            this.lastFired = lastFired;
            return this;
        }

        public TimerBuilder internalVariable1(String internalVariable1) {
            this.internalVariable1 = internalVariable1;
            return this;
        }

        public Timer build() {
            return new Timer(this.id, this.enabled, this.name, this.resourceType, this.resourceId, this.timerType, this.frequencyType, this.frequencyData, this.triggerTime, this.validityFrom, this.validityTo, this.payload, this.lastFired, this.internalVariable1);
        }

        public String toString() {
            return "Timer.TimerBuilder(id=" + this.id + ", enabled=" + this.enabled + ", name=" + this.name + ", resourceType=" + (Object)((Object)this.resourceType) + ", resourceId=" + this.resourceId + ", timerType=" + (Object)((Object)this.timerType) + ", frequencyType=" + (Object)((Object)this.frequencyType) + ", frequencyData=" + this.frequencyData + ", triggerTime=" + this.triggerTime + ", validityFrom=" + this.validityFrom + ", validityTo=" + this.validityTo + ", payload=" + this.payload + ", lastFired=" + this.lastFired + ", internalVariable1=" + this.internalVariable1 + ")";
        }
    }
}

