/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.security.Principal;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.mycontroller.standalone.auth.USER_ROLE;

@DatabaseTable(tableName="user")
@JsonIgnoreProperties(ignoreUnknown=true)
public class User
implements Principal {
    public static final String NAME = "name";
    public static final String EMAIL = "email";
    @DatabaseField(generatedId=true, unique=true)
    private Integer id;
    @DatabaseField(canBeNull=false)
    private String fullName;
    @DatabaseField(unique=true, index=true, columnName="name", canBeNull=false)
    private String name;
    @DatabaseField(unique=true, columnName="email", canBeNull=false)
    private String email;
    @DatabaseField(canBeNull=false)
    private String password;
    @DatabaseField(canBeNull=false)
    private Integer roleId;

    public User() {
    }

    public User(int id) {
        this.id = id;
    }

    public User(String userName) {
        this.name = userName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String username) {
        this.name = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer role) {
        this.roleId = role;
    }

    public String getRole() {
        if (this.roleId != null) {
            return USER_ROLE.get(this.roleId).toString();
        }
        return null;
    }

    public void setRole(String roleName) {
        if (roleName != null) {
            this.roleId = USER_ROLE.valueOf(roleName).ordinal();
        }
    }
}

