/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.metrics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.mycontroller.standalone.api.jaxrs.mapper.MetricsCsvDownload;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.MetricsBinaryTypeDevice;
import org.mycontroller.standalone.db.tables.MetricsDoubleTypeDevice;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.metrics.MetricsAggregationBase;
import org.mycontroller.standalone.metrics.MetricsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCsvEngine {
    private static final Logger _logger = LoggerFactory.getLogger((String)MetricsCsvEngine.class.getName());
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss a");

    public MetricsCsvDownload getMetricsCSV(int sensorValueId, int aggregationTypeId) {
        SensorVariable sensorVariable = DaoUtils.getSensorVariableDao().get(sensorValueId);
        MetricsUtils.AGGREGATION_TYPE aggrType = MetricsUtils.AGGREGATION_TYPE.get(aggregationTypeId);
        return new MetricsCsvDownload(this.getFileName(sensorVariable, aggrType), this.getData(sensorVariable, aggrType));
    }

    private String getFileName(SensorVariable sensorVariable, MetricsUtils.AGGREGATION_TYPE aggrType) {
        Sensor sensor = (Sensor)DaoUtils.getSensorDao().getById(sensorVariable.getSensor().getId());
        StringBuilder builder = new StringBuilder();
        builder.append(sensor.getNode().getName()).append("_").append(sensor.getName()).append("_Nid-").append(sensor.getNode().getEui()).append("_Sid-").append(sensor.getSensorId()).append("_").append(sensorVariable.getVariableType().getText());
        if (sensorVariable.getMetricType() == MetricsUtils.METRIC_TYPE.DOUBLE) {
            builder.append("_").append("SampleType_").append((Object)aggrType);
        }
        builder.append("_").append(new SimpleDateFormat("yyyy-MMM-dd_hh-mm-ss").format(new Date())).append(".csv");
        return builder.toString().replaceAll(" ", "_");
    }

    private String getData(SensorVariable sensorVariable, MetricsUtils.AGGREGATION_TYPE aggrType) {
        MetricsUtils.METRIC_TYPE type = sensorVariable.getMetricType();
        switch (type) {
            case BINARY: {
                return this.getBinaryData(sensorVariable, aggrType);
            }
            case DOUBLE: {
                return this.getDoubleData(sensorVariable, aggrType);
            }
        }
        _logger.debug("Unknown Metric Type[{}]", (Object)type);
        throw new RuntimeException("Unknown Metric Type[" + (Object)((Object)type) + "]");
    }

    private String getBinaryData(SensorVariable sensorVariable, MetricsUtils.AGGREGATION_TYPE aggrType) {
        Long fromTime = null;
        switch (aggrType) {
            case RAW: {
                fromTime = System.currentTimeMillis() - 3600000L;
                break;
            }
            case ONE_MINUTE: {
                fromTime = System.currentTimeMillis() - 21600000L;
                break;
            }
            case FIVE_MINUTES: {
                fromTime = System.currentTimeMillis() - 86400000L;
                break;
            }
            case ONE_HOUR: {
                fromTime = System.currentTimeMillis() - 2592000000L;
                break;
            }
        }
        List<MetricsBinaryTypeDevice> metrics = MetricsAggregationBase.getMetricsBinaryData(sensorVariable, fromTime);
        StringBuilder builder = new StringBuilder();
        builder.append("Timestamp").append(",");
        builder.append("Time").append(",");
        builder.append("Status");
        for (MetricsBinaryTypeDevice metric : metrics) {
            builder.append("\n");
            builder.append(metric.getTimestamp());
            builder.append(",").append(timeFormat.format(new Date(metric.getTimestamp())));
            builder.append(",").append(metric.getState());
        }
        return builder.toString();
    }

    private String getDoubleData(SensorVariable sensorVariable, MetricsUtils.AGGREGATION_TYPE aggrType) {
        List<MetricsDoubleTypeDevice> metrics = MetricsAggregationBase.getMetricsDoubleData(sensorVariable, null, null);
        StringBuilder builder = new StringBuilder();
        if (aggrType == MetricsUtils.AGGREGATION_TYPE.RAW) {
            builder.append("Timestamp").append(",");
            builder.append("Time").append(",");
            builder.append("Value");
            for (MetricsDoubleTypeDevice metric : metrics) {
                builder.append("\n");
                builder.append(metric.getTimestamp());
                builder.append(",").append(timeFormat.format(new Date(metric.getTimestamp())));
                builder.append(",").append(metric.getAvg());
            }
        } else {
            builder.append("Timestamp").append(",");
            builder.append("Time").append(",");
            builder.append("Samples").append(",");
            builder.append("Minimum").append(",");
            builder.append("Average").append(",");
            builder.append("Maximum");
            for (MetricsDoubleTypeDevice metric : metrics) {
                builder.append("\n");
                builder.append(metric.getTimestamp());
                builder.append(",").append(timeFormat.format(new Date(metric.getTimestamp())));
                builder.append(",").append(metric.getSamples());
                builder.append(",").append(metric.getMin());
                builder.append(",").append(metric.getAvg());
                builder.append(",").append(metric.getMax());
            }
        }
        return builder.toString();
    }
}

