/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.settings.SettingsUtils;

@JsonTypeName(value="metricsSettings")
public class MetricsSettings {
    public static final String KEY_METRICS = "metrics";
    public static final String SKEY_LAST_AGGREGATION_RAW_DATA = "lastAggregationRawData";
    public static final String SKEY_LAST_AGGREGATION_ONE_MINUTE = "lastAggregationOneMinute";
    public static final String SKEY_LAST_AGGREGATION_FIVE_MINUTES = "lastAggregationFiveMinutes";
    public static final String SKEY_LAST_AGGREGATION_ONE_HOUR = "lastAggregationOneHour";
    public static final String SKEY_LAST_AGGREGATION_SIX_HOURS = "lastAggregationSixHours";
    public static final String SKEY_LAST_AGGREGATION_TWELVE_HOURS = "lastAggregationTwelveHours";
    public static final String SKEY_LAST_AGGREGATION_ONE_DAY = "lastAggregationOneDay";
    private Long lastAggregationRawData;
    private Long lastAggregationOneMinute;
    private Long lastAggregationFiveMinutes;
    private Long lastAggregationOneHour;
    private Long lastAggregationSixHours;
    private Long lastAggregationTwelveHours;
    private Long lastAggregationOneDay;

    public static MetricsSettings get() {
        return MetricsSettings.builder().lastAggregationRawData(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_RAW_DATA))).lastAggregationOneMinute(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_ONE_MINUTE))).lastAggregationFiveMinutes(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_FIVE_MINUTES))).lastAggregationOneHour(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_ONE_HOUR))).lastAggregationSixHours(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_SIX_HOURS))).lastAggregationTwelveHours(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_TWELVE_HOURS))).lastAggregationOneDay(NumericUtils.getLong(MetricsSettings.getValue(SKEY_LAST_AGGREGATION_ONE_DAY))).build();
    }

    public void save() {
    }

    @JsonIgnore
    public void updateInternal() {
        if (this.lastAggregationRawData != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_RAW_DATA, this.lastAggregationRawData);
        }
        if (this.lastAggregationOneMinute != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_ONE_MINUTE, this.lastAggregationOneMinute);
        }
        if (this.lastAggregationFiveMinutes != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_FIVE_MINUTES, this.lastAggregationFiveMinutes);
        }
        if (this.lastAggregationOneHour != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_ONE_HOUR, this.lastAggregationOneHour);
        }
        if (this.lastAggregationSixHours != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_SIX_HOURS, this.lastAggregationSixHours);
        }
        if (this.lastAggregationTwelveHours != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_TWELVE_HOURS, this.lastAggregationTwelveHours);
        }
        if (this.lastAggregationOneDay != null) {
            MetricsSettings.updateValue(SKEY_LAST_AGGREGATION_ONE_DAY, this.lastAggregationOneDay);
        }
    }

    private static String getValue(String subKey) {
        return SettingsUtils.getValue(KEY_METRICS, subKey);
    }

    private static void updateValue(String subKey, Object value) {
        SettingsUtils.updateValue(KEY_METRICS, subKey, value);
    }

    public static MetricsSettingsBuilder builder() {
        return new MetricsSettingsBuilder();
    }

    public String toString() {
        return "MetricsSettings(lastAggregationRawData=" + this.getLastAggregationRawData() + ", lastAggregationOneMinute=" + this.getLastAggregationOneMinute() + ", lastAggregationFiveMinutes=" + this.getLastAggregationFiveMinutes() + ", lastAggregationOneHour=" + this.getLastAggregationOneHour() + ", lastAggregationSixHours=" + this.getLastAggregationSixHours() + ", lastAggregationTwelveHours=" + this.getLastAggregationTwelveHours() + ", lastAggregationOneDay=" + this.getLastAggregationOneDay() + ")";
    }

    public Long getLastAggregationRawData() {
        return this.lastAggregationRawData;
    }

    public Long getLastAggregationOneMinute() {
        return this.lastAggregationOneMinute;
    }

    public Long getLastAggregationFiveMinutes() {
        return this.lastAggregationFiveMinutes;
    }

    public Long getLastAggregationOneHour() {
        return this.lastAggregationOneHour;
    }

    public Long getLastAggregationSixHours() {
        return this.lastAggregationSixHours;
    }

    public Long getLastAggregationTwelveHours() {
        return this.lastAggregationTwelveHours;
    }

    public Long getLastAggregationOneDay() {
        return this.lastAggregationOneDay;
    }

    public MetricsSettings() {
    }

    @ConstructorProperties(value={"lastAggregationRawData", "lastAggregationOneMinute", "lastAggregationFiveMinutes", "lastAggregationOneHour", "lastAggregationSixHours", "lastAggregationTwelveHours", "lastAggregationOneDay"})
    public MetricsSettings(Long lastAggregationRawData, Long lastAggregationOneMinute, Long lastAggregationFiveMinutes, Long lastAggregationOneHour, Long lastAggregationSixHours, Long lastAggregationTwelveHours, Long lastAggregationOneDay) {
        this.lastAggregationRawData = lastAggregationRawData;
        this.lastAggregationOneMinute = lastAggregationOneMinute;
        this.lastAggregationFiveMinutes = lastAggregationFiveMinutes;
        this.lastAggregationOneHour = lastAggregationOneHour;
        this.lastAggregationSixHours = lastAggregationSixHours;
        this.lastAggregationTwelveHours = lastAggregationTwelveHours;
        this.lastAggregationOneDay = lastAggregationOneDay;
    }

    public static class MetricsSettingsBuilder {
        private Long lastAggregationRawData;
        private Long lastAggregationOneMinute;
        private Long lastAggregationFiveMinutes;
        private Long lastAggregationOneHour;
        private Long lastAggregationSixHours;
        private Long lastAggregationTwelveHours;
        private Long lastAggregationOneDay;

        MetricsSettingsBuilder() {
        }

        public MetricsSettingsBuilder lastAggregationRawData(Long lastAggregationRawData) {
            this.lastAggregationRawData = lastAggregationRawData;
            return this;
        }

        public MetricsSettingsBuilder lastAggregationOneMinute(Long lastAggregationOneMinute) {
            this.lastAggregationOneMinute = lastAggregationOneMinute;
            return this;
        }

        public MetricsSettingsBuilder lastAggregationFiveMinutes(Long lastAggregationFiveMinutes) {
            this.lastAggregationFiveMinutes = lastAggregationFiveMinutes;
            return this;
        }

        public MetricsSettingsBuilder lastAggregationOneHour(Long lastAggregationOneHour) {
            this.lastAggregationOneHour = lastAggregationOneHour;
            return this;
        }

        public MetricsSettingsBuilder lastAggregationSixHours(Long lastAggregationSixHours) {
            this.lastAggregationSixHours = lastAggregationSixHours;
            return this;
        }

        public MetricsSettingsBuilder lastAggregationTwelveHours(Long lastAggregationTwelveHours) {
            this.lastAggregationTwelveHours = lastAggregationTwelveHours;
            return this;
        }

        public MetricsSettingsBuilder lastAggregationOneDay(Long lastAggregationOneDay) {
            this.lastAggregationOneDay = lastAggregationOneDay;
            return this;
        }

        public MetricsSettings build() {
            return new MetricsSettings(this.lastAggregationRawData, this.lastAggregationOneMinute, this.lastAggregationFiveMinutes, this.lastAggregationOneHour, this.lastAggregationSixHours, this.lastAggregationTwelveHours, this.lastAggregationOneDay);
        }

        public String toString() {
            return "MetricsSettings.MetricsSettingsBuilder(lastAggregationRawData=" + this.lastAggregationRawData + ", lastAggregationOneMinute=" + this.lastAggregationOneMinute + ", lastAggregationFiveMinutes=" + this.lastAggregationFiveMinutes + ", lastAggregationOneHour=" + this.lastAggregationOneHour + ", lastAggregationSixHours=" + this.lastAggregationSixHours + ", lastAggregationTwelveHours=" + this.lastAggregationTwelveHours + ", lastAggregationOneDay=" + this.lastAggregationOneDay + ")";
        }
    }
}

