/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.alarm.IDampening;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;

public class DampeningConsecutive
implements IDampening {
    private int consecutiveMax;
    private int consecutiveCount;
    private AlarmDefinition alarmDefinition;

    public DampeningConsecutive(AlarmDefinition alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        this.consecutiveMax = Integer.valueOf(alarmDefinition.getDampeningVar1());
        this.consecutiveCount = alarmDefinition.getDampeningInternal1() == null ? 0 : Integer.valueOf(alarmDefinition.getDampeningInternal1());
    }

    public int getConsecutiveMax() {
        return this.consecutiveMax;
    }

    public int getConsecutiveCount() {
        return this.consecutiveCount;
    }

    public void setConsecutiveCount(int consecutiveCount) {
        this.consecutiveCount = consecutiveCount;
    }

    public void incrementConsecutiveCount() {
        ++this.consecutiveCount;
    }

    @Override
    public boolean evaluate() {
        return this.consecutiveCount >= this.consecutiveMax;
    }

    @Override
    public void reset() {
        this.consecutiveCount = 0;
        this.update();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(AlarmUtils.DAMPENING_TYPE.CONSECUTIVE.getText());
        builder.append("=").append("consecutiveCount:").append(this.consecutiveCount);
        builder.append(", consecutiveMax:").append(this.consecutiveMax);
        return builder.toString();
    }

    @Override
    public AlarmDefinition getAlarmDefinition() {
        return this.alarmDefinition;
    }

    @Override
    public void update() {
        this.alarmDefinition.setDampeningInternal1(String.valueOf(this.consecutiveCount));
        DaoUtils.getAlarmDefinitionDao().update(this.alarmDefinition);
    }
}

