/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.mail.EmailException;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.alarm.INotification;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.email.EmailUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationEmail
implements INotification {
    private static final Logger _logger = LoggerFactory.getLogger(NotificationEmail.class);
    private String toEmailAddress;
    private AlarmDefinition alarmDefinition;

    public NotificationEmail(AlarmDefinition alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        this.toEmailAddress = alarmDefinition.getVariable1();
    }

    public String getToEmailAddress() {
        return this.toEmailAddress;
    }

    public String toString() {
        return this.toEmailAddress;
    }

    @Override
    public AlarmDefinition getAlarmDefinition() {
        return this.alarmDefinition;
    }

    @Override
    public void execute(String actualValue) {
        if (this.toEmailAddress == null) {
            throw new RuntimeException("Cannot execute send email without email address! AlarmDefination name: " + this.alarmDefinition.getName());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("AlarmDefinition: [").append(this.alarmDefinition.getName()).append("/").append(this.alarmDefinition.getResourceType().getText()).append("] triggered!");
        String subject = builder.toString();
        builder.setLength(0);
        builder.append("<table border='0'>");
        builder.append("<tr>");
        builder.append("<td>").append("AlarmDefinition Name").append("</td>");
        builder.append("<td>").append(": ").append(this.alarmDefinition.getName()).append("</td>");
        builder.append("<tr>");
        builder.append("<tr>");
        builder.append("<td>").append("Condition").append("</td>");
        builder.append("<td>").append(": ").append(AlarmUtils.getConditionString(this.alarmDefinition)).append(AlarmUtils.getSensorUnit(this.alarmDefinition, true)).append("</td>");
        builder.append("<tr>");
        builder.append("<tr>");
        builder.append("<td>").append("Dampening").append("</td>");
        builder.append("<td>").append(": ").append(this.alarmDefinition.getDampeningString()).append("</td>");
        builder.append("<tr>");
        builder.append("<tr>");
        builder.append("<td>").append(this.alarmDefinition.getResourceType().getText()).append("</td>");
        builder.append("<td>").append(": ").append(AlarmUtils.getResourceString(this.alarmDefinition, false)).append("</td>");
        builder.append("<tr>");
        builder.append("<tr>");
        builder.append("<td>").append("Sensor Value").append("</td>");
        builder.append("<td>").append(": ").append(actualValue).append(AlarmUtils.getSensorUnit(this.alarmDefinition, false)).append("</td>");
        builder.append("<tr>");
        builder.append("<tr>");
        builder.append("<td>").append("Triggered at").append("</td>");
        builder.append("<td>").append(": ").append(new SimpleDateFormat(ObjectFactory.getAppProperties().getDateFormat()).format(new Date())).append("</td>");
        builder.append("<tr>");
        builder.append("</table>");
        String message = null;
        try {
            message = new String(Files.readAllBytes(Paths.get("../conf/templates/emailTemplateAlarm.html", new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            _logger.error("Exception, ", (Throwable)ex);
            message = ex.getMessage();
        }
        try {
            EmailUtils.sendSimpleEmail(this.toEmailAddress, subject, message.replaceAll("\\$alarmInfo", builder.toString()));
        }
        catch (EmailException ex) {
            _logger.error("Error on sending email, ", (Throwable)ex);
        }
    }
}

