/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.mapper.About;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.api.jaxrs.utils.StatusJVM;
import org.mycontroller.standalone.api.jaxrs.utils.StatusOS;
import org.mycontroller.standalone.mysensors.MySensorsRawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"user"})
public class MyControllerHandler {
    private static final Logger _logger = LoggerFactory.getLogger(MyControllerHandler.class);

    @OPTIONS
    @Path(value="/{path:.*}")
    public Response sendPreFlightResponse() {
        _logger.trace("Called sendPreFlightResponse...");
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/ping")
    public Response ping() {
        return RestUtils.getResponse(Response.Status.OK, "Hello!");
    }

    @GET
    @Path(value="/timestamp")
    public Response timestamp() {
        return RestUtils.getResponse(Response.Status.OK, System.currentTimeMillis());
    }

    @GET
    @Path(value="/time")
    public Response time() {
        return RestUtils.getResponse(Response.Status.OK, new Date().toString());
    }

    @GET
    @Path(value="/about")
    public Response about() {
        return RestUtils.getResponse(Response.Status.OK, new About());
    }

    @GET
    @Path(value="/gatewayInfo")
    public Response serialport() {
        return RestUtils.getResponse(Response.Status.OK, null);
    }

    @POST
    @Path(value="/sendRawMessage")
    public Response sendRawMessage(MySensorsRawMessage mySensorsRawMessage) {
        try {
            mySensorsRawMessage.setTxMessage(true);
            ObjectFactory.getRawMessageQueue().putMessage(mySensorsRawMessage.getRawMessage());
            return RestUtils.getResponse(Response.Status.OK);
        }
        catch (Exception ex) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError(ex.getMessage()));
        }
    }

    @GET
    @Path(value="/osStatus")
    public Response getOsStatus() {
        return RestUtils.getResponse(Response.Status.OK, new StatusOS());
    }

    @GET
    @Path(value="/jvmStatus")
    public Response getJvmStatus() {
        return RestUtils.getResponse(Response.Status.OK, new StatusJVM());
    }
}

