/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.ForwardPayloadDao;
import org.mycontroller.standalone.db.tables.ForwardPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardPayloadDaoImpl
extends BaseAbstractDaoImpl<ForwardPayload, Integer>
implements ForwardPayloadDao {
    private static final Logger _logger = LoggerFactory.getLogger(ForwardPayloadDaoImpl.class);

    public ForwardPayloadDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, ForwardPayload.class);
    }

    @Override
    public List<ForwardPayload> getAllBySourceSensor(Integer sourceSensorId, Boolean enabled) {
        List<Integer> ids = DaoUtils.getSensorVariableDao().getSensorVariableIds(sourceSensorId);
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            if (enabled != null) {
                queryBuilder.where().in("sourceId", ids).and().eq("enabled", (Object)enabled);
            } else {
                queryBuilder.where().in("sourceId", ids);
            }
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<ForwardPayload> getAllBySourceSensor(Integer sourceSensorId) {
        return this.getAllBySourceSensor(sourceSensorId, null);
    }

    @Override
    public List<ForwardPayload> getAllByDestinationSensor(Integer destinationSensorId) {
        List<Integer> ids = DaoUtils.getSensorVariableDao().getSensorVariableIds(destinationSensorId);
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().in("destinationId", ids);
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void deleteBySensorId(Integer sensorId) {
        try {
            List<Integer> ids = DaoUtils.getSensorVariableDao().getSensorVariableIds(sensorId);
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().in("sourceId", ids).or().in("destinationId", ids);
            Integer deleteCount = deleteBuilder.delete();
            _logger.debug("Deleted SensorId:[{}], delete count:{}", (Object)sensorId, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete SensorId:{}", (Object)sensorId, (Object)ex);
        }
    }

    @Override
    public void enable(List<Integer> ids) {
        this.enableDisable(ids, true);
    }

    @Override
    public void disable(List<Integer> ids) {
        this.enableDisable(ids, false);
    }

    private void enableDisable(List<Integer> ids, boolean enabled) {
        try {
            UpdateBuilder updateBuilder = this.getDao().updateBuilder();
            updateBuilder.updateColumnValue("enabled", (Object)enabled).where().in("id", ids);
            int updateCount = updateBuilder.update();
            _logger.debug("Updated rows count:{}", (Object)updateCount);
        }
        catch (SQLException ex) {
            _logger.error("Failed to update, Ids:{}", ids, (Object)ex);
        }
    }

    @Override
    public List<ForwardPayload> getAll(Integer sensorVariableId) {
        try {
            return this.getDao().queryForEq("sourceId", (Object)sensorVariableId);
        }
        catch (SQLException ex) {
            _logger.error("unable to featch getAll for selected id, ", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<ForwardPayload> getAllEnabled(Integer sensorVariableId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("enabled", (Object)true).and().eq("sourceId", (Object)sensorVariableId);
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to featch getAll for selected id, ", (Throwable)ex);
            return null;
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }

    @Override
    public ForwardPayload get(ForwardPayload tdao) {
        return (ForwardPayload)this.getById(tdao.getId());
    }

    @Override
    public List<ForwardPayload> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }
}

