/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.db.SensorUtils;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.metrics.MetricsUtils;

@DatabaseTable(tableName="sensor_variable")
public class SensorVariable {
    public static final String KEY_ID = "id";
    public static final String KEY_SENSOR_DB_ID = "sensorDbId";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_VARIABLE_TYPE = "variableType";
    public static final String KEY_VALUE = "value";
    public static final String KEY_METRIC = "metricType";
    public static final String KEY_UNIT = "unit";
    @DatabaseField(generatedId=true, columnName="id")
    private Integer id;
    @DatabaseField(columnName="sensorDbId", canBeNull=false, uniqueCombo=true, foreign=true, maxForeignAutoRefreshLevel=3, foreignAutoRefresh=true)
    private Sensor sensor;
    @DatabaseField(columnName="variableType", canBeNull=false, uniqueCombo=true, dataType=DataType.ENUM_STRING)
    private MYCMessages.MESSAGE_TYPE_SET_REQ variableType;
    @DatabaseField(columnName="metricType", canBeNull=false, dataType=DataType.ENUM_STRING)
    private MetricsUtils.METRIC_TYPE metricType = MetricsUtils.METRIC_TYPE.NONE;
    @DatabaseField(columnName="timestamp", canBeNull=true)
    private Long timestamp;
    @DatabaseField(columnName="value", canBeNull=true)
    private String value;
    @DatabaseField(columnName="unit", canBeNull=true)
    private String unit;

    public SensorVariable updateUnitAndMetricType() {
        if (this.unit == null) {
            String unit = SensorUtils.getUnit(this.variableType);
            String string = this.unit = unit == null ? "" : unit;
        }
        if (this.metricType == null) {
            this.metricType = MYCMessages.getMetricType(this.variableType);
        }
        return this;
    }

    public static SensorVariableBuilder builder() {
        return new SensorVariableBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public MYCMessages.MESSAGE_TYPE_SET_REQ getVariableType() {
        return this.variableType;
    }

    public MetricsUtils.METRIC_TYPE getMetricType() {
        return this.metricType;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSensor(Sensor sensor) {
        this.sensor = sensor;
    }

    public void setVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ variableType) {
        this.variableType = variableType;
    }

    public void setMetricType(MetricsUtils.METRIC_TYPE metricType) {
        this.metricType = metricType;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensorVariable)) {
            return false;
        }
        SensorVariable other = (SensorVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Sensor this$sensor = this.getSensor();
        Sensor other$sensor = other.getSensor();
        if (this$sensor == null ? other$sensor != null : !((Object)this$sensor).equals(other$sensor)) {
            return false;
        }
        MYCMessages.MESSAGE_TYPE_SET_REQ this$variableType = this.getVariableType();
        MYCMessages.MESSAGE_TYPE_SET_REQ other$variableType = other.getVariableType();
        if (this$variableType == null ? other$variableType != null : !((Object)((Object)this$variableType)).equals((Object)other$variableType)) {
            return false;
        }
        MetricsUtils.METRIC_TYPE this$metricType = this.getMetricType();
        MetricsUtils.METRIC_TYPE other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !((Object)((Object)this$metricType)).equals((Object)other$metricType)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SensorVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Sensor $sensor = this.getSensor();
        result = result * 59 + ($sensor == null ? 43 : ((Object)$sensor).hashCode());
        MYCMessages.MESSAGE_TYPE_SET_REQ $variableType = this.getVariableType();
        result = result * 59 + ($variableType == null ? 43 : ((Object)((Object)$variableType)).hashCode());
        MetricsUtils.METRIC_TYPE $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : ((Object)((Object)$metricType)).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }

    public SensorVariable() {
    }

    @ConstructorProperties(value={"id", "sensor", "variableType", "metricType", "timestamp", "value", "unit"})
    public SensorVariable(Integer id, Sensor sensor, MYCMessages.MESSAGE_TYPE_SET_REQ variableType, MetricsUtils.METRIC_TYPE metricType, Long timestamp, String value, String unit) {
        this.id = id;
        this.sensor = sensor;
        this.variableType = variableType;
        this.metricType = metricType;
        this.timestamp = timestamp;
        this.value = value;
        this.unit = unit;
    }

    public String toString() {
        return "SensorVariable(id=" + this.getId() + ", sensor=" + this.getSensor() + ", variableType=" + (Object)((Object)this.getVariableType()) + ", metricType=" + (Object)((Object)this.getMetricType()) + ", timestamp=" + this.getTimestamp() + ", value=" + this.getValue() + ", unit=" + this.getUnit() + ")";
    }

    public static class SensorVariableBuilder {
        private Integer id;
        private Sensor sensor;
        private MYCMessages.MESSAGE_TYPE_SET_REQ variableType;
        private MetricsUtils.METRIC_TYPE metricType;
        private Long timestamp;
        private String value;
        private String unit;

        SensorVariableBuilder() {
        }

        public SensorVariableBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public SensorVariableBuilder sensor(Sensor sensor) {
            this.sensor = sensor;
            return this;
        }

        public SensorVariableBuilder variableType(MYCMessages.MESSAGE_TYPE_SET_REQ variableType) {
            this.variableType = variableType;
            return this;
        }

        public SensorVariableBuilder metricType(MetricsUtils.METRIC_TYPE metricType) {
            this.metricType = metricType;
            return this;
        }

        public SensorVariableBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SensorVariableBuilder value(String value) {
            this.value = value;
            return this;
        }

        public SensorVariableBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public SensorVariable build() {
            return new SensorVariable(this.id, this.sensor, this.variableType, this.metricType, this.timestamp, this.value, this.unit);
        }

        public String toString() {
            return "SensorVariable.SensorVariableBuilder(id=" + this.id + ", sensor=" + this.sensor + ", variableType=" + (Object)((Object)this.variableType) + ", metricType=" + (Object)((Object)this.metricType) + ", timestamp=" + this.timestamp + ", value=" + this.value + ", unit=" + this.unit + ")";
        }
    }
}

