/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataEventListener;
import com.pi4j.io.serial.SerialFactory;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.serialport.SerialDataListenerPi4j;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortPi4jImpl
implements IGateway {
    private static Logger _logger = LoggerFactory.getLogger((String)SerialPortPi4jImpl.class.getName());
    private SerialDataListenerPi4j dataListenerPi4J;
    private GatewaySerial gateway = null;
    private Serial serial;

    public SerialPortPi4jImpl(GatewaySerial gateway) {
        this.gateway = gateway;
        this.initialize();
    }

    @Override
    public synchronized void write(RawMessage rawMessage) {
        try {
            this.serial.write(rawMessage.getGWBytes());
        }
        catch (Exception ex) {
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            _logger.error("exception on pi4j serialport,", (Throwable)ex);
        }
    }

    private void initialize() {
        try {
            this.serial = SerialFactory.createInstance();
            this.dataListenerPi4J = new SerialDataListenerPi4j(this.gateway);
            this.serial.addListener(new SerialDataEventListener[]{this.dataListenerPi4J});
            this.serial.open(this.gateway.getPortName(), this.gateway.getBaudRate().intValue());
            _logger.debug("Serial port gateway initialized, Gateway[{}]", (Object)this.gateway);
            this.gateway.setStatus(AppProperties.STATE.UP, "Connected Successfully");
            this.gateway.updateGateway();
        }
        catch (Exception ex) {
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            _logger.error("Failed to load serial port,", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        if (this.serial.isOpen()) {
            try {
                if (this.dataListenerPi4J != null) {
                    this.serial.removeListener(new SerialDataEventListener[]{this.dataListenerPi4J});
                }
                this.serial.close();
                _logger.debug("serialPort{} closed", (Object)this.gateway.getPortName());
            }
            catch (Exception ex) {
                _logger.error("exception on pi4j serialport,", (Throwable)ex);
            }
        } else {
            _logger.debug("serialPort{} already closed, nothing to do.", (Object)this.gateway.getPortName());
        }
    }

    @Override
    public GatewaySerial getGateway() {
        return this.gateway;
    }
}

