/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.metrics;

import java.util.List;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.MetricsBinaryTypeDevice;
import org.mycontroller.standalone.db.tables.MetricsDoubleTypeDevice;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.metrics.MetricsUtils;
import org.mycontroller.standalone.settings.MetricsSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAggregationBase {
    private static final Logger _logger = LoggerFactory.getLogger((String)MetricsAggregationBase.class.getName());
    private static boolean isAggregationRunning = false;

    private void aggregateForBucket(MetricsUtils.AGGREGATION_TYPE aggregationType, MetricsUtils.AGGREGATION_TYPE sourceAggregationType, Long fromTimestamp, Long toTimestamp) {
        if (aggregationType == null) {
            _logger.warn("Should create object with valid aggregation type!");
            return;
        }
        _logger.debug("Running aggregation on this time range[from:{}, to:{}, type:{}]", new Object[]{fromTimestamp, toTimestamp, aggregationType});
        List<MetricsDoubleTypeDevice> variableIds = DaoUtils.getMetricsDoubleTypeDeviceDao().getAggregationRequiredVariableIds(sourceAggregationType, fromTimestamp, toTimestamp);
        if (variableIds == null || variableIds.isEmpty()) {
            _logger.debug("No values available for aggregation on this time range");
            return;
        }
        _logger.debug("Number of sensor variables:{}", (Object)variableIds.size());
        for (MetricsDoubleTypeDevice sensorVariable : variableIds) {
            MetricsDoubleTypeDevice metric2;
            List<MetricsDoubleTypeDevice> metrics = DaoUtils.getMetricsDoubleTypeDeviceDao().getAll(MetricsDoubleTypeDevice.builder().aggregationType(sourceAggregationType).sensorVariable(sensorVariable.getSensorVariable()).timestampFrom(fromTimestamp).timestampTo(toTimestamp).build());
            _logger.debug("Metrics:{}", metrics);
            if (metrics.size() <= 0) continue;
            int samples = 0;
            if (aggregationType == MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE) {
                samples = metrics.size();
            }
            _logger.debug("Number of records:{}", (Object)metrics.size());
            Double min = Double.MAX_VALUE;
            Double max = Double.NEGATIVE_INFINITY;
            Double sum = 0.0;
            for (MetricsDoubleTypeDevice metric2 : metrics) {
                if (aggregationType == MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE) {
                    if (metric2.getAvg() > max) {
                        max = metric2.getAvg();
                    }
                    if (metric2.getAvg() < min) {
                        min = metric2.getAvg();
                    }
                    sum = sum + metric2.getAvg();
                    continue;
                }
                if (metric2.getMax() > max) {
                    max = metric2.getMax();
                }
                if (metric2.getMin() < min) {
                    min = metric2.getMin();
                }
                sum = sum + metric2.getAvg() * (double)metric2.getSamples().intValue();
                samples += metric2.getSamples().intValue();
            }
            Double avg = sum / (double)samples;
            metric2 = MetricsDoubleTypeDevice.builder().aggregationType(aggregationType).sensorVariable(sensorVariable.getSensorVariable()).min(NumericUtils.round(min, 3)).max(NumericUtils.round(max, 3)).avg(NumericUtils.round(avg, 3)).samples(samples).timestamp(toTimestamp).build();
            DaoUtils.getMetricsDoubleTypeDeviceDao().create(metric2);
        }
        MetricsSettings metricsSettings = null;
        switch (aggregationType) {
            case ONE_MINUTE: {
                metricsSettings = MetricsSettings.builder().lastAggregationOneMinute(toTimestamp).lastAggregationRawData(toTimestamp).build();
                break;
            }
            case FIVE_MINUTES: {
                metricsSettings = MetricsSettings.builder().lastAggregationFiveMinutes(toTimestamp).build();
                break;
            }
            case ONE_HOUR: {
                metricsSettings = MetricsSettings.builder().lastAggregationOneHour(toTimestamp).build();
                break;
            }
            case SIX_HOURS: {
                metricsSettings = MetricsSettings.builder().lastAggregationSixHours(toTimestamp).build();
                break;
            }
            case TWELVE_HOURS: {
                metricsSettings = MetricsSettings.builder().lastAggregationTwelveHours(toTimestamp).build();
                break;
            }
            case ONE_DAY: {
                metricsSettings = MetricsSettings.builder().lastAggregationOneDay(toTimestamp).build();
                break;
            }
        }
        if (metricsSettings != null) {
            metricsSettings.updateInternal();
            metricsSettings = MetricsSettings.get();
            ObjectFactory.getAppProperties().setMetricsSettings(metricsSettings);
            _logger.debug("Metrics settings update successfully! new settings:{}", (Object)metricsSettings);
        } else {
            _logger.warn("metricsSettings is null cannot update");
        }
    }

    private void executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE aggregationType, MetricsUtils.AGGREGATION_TYPE sourceAggregationType, Long fromTimestamp, Long toTimestamp, Long bucketDuration) {
        while (fromTimestamp + bucketDuration <= toTimestamp) {
            this.aggregateForBucket(aggregationType, sourceAggregationType, fromTimestamp, fromTimestamp + bucketDuration);
            fromTimestamp = fromTimestamp + bucketDuration;
        }
    }

    public void runAggregation() {
        if (isAggregationRunning) {
            _logger.warn("Already a aggregation is running. Cannot run now!");
            return;
        }
        MetricsAggregationBase.setAggregationRunning(true);
        this.executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE, MetricsUtils.AGGREGATION_TYPE.RAW, ObjectFactory.getAppProperties().getMetricsSettings().getLastAggregationOneMinute(), MetricsAggregationBase.getToTime(MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE), 60000L);
        this.executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE.FIVE_MINUTES, MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE, ObjectFactory.getAppProperties().getMetricsSettings().getLastAggregationFiveMinutes(), MetricsAggregationBase.getToTime(MetricsUtils.AGGREGATION_TYPE.FIVE_MINUTES), 300000L);
        this.executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE.ONE_HOUR, MetricsUtils.AGGREGATION_TYPE.FIVE_MINUTES, ObjectFactory.getAppProperties().getMetricsSettings().getLastAggregationOneHour(), MetricsAggregationBase.getToTime(MetricsUtils.AGGREGATION_TYPE.ONE_HOUR), 3600000L);
        this.executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE.SIX_HOURS, MetricsUtils.AGGREGATION_TYPE.ONE_HOUR, ObjectFactory.getAppProperties().getMetricsSettings().getLastAggregationSixHours(), MetricsAggregationBase.getToTime(MetricsUtils.AGGREGATION_TYPE.SIX_HOURS), 21600000L);
        this.executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE.TWELVE_HOURS, MetricsUtils.AGGREGATION_TYPE.SIX_HOURS, ObjectFactory.getAppProperties().getMetricsSettings().getLastAggregationTwelveHours(), MetricsAggregationBase.getToTime(MetricsUtils.AGGREGATION_TYPE.TWELVE_HOURS), 43200000L);
        this.executeBucketByBucket(MetricsUtils.AGGREGATION_TYPE.ONE_DAY, MetricsUtils.AGGREGATION_TYPE.TWELVE_HOURS, ObjectFactory.getAppProperties().getMetricsSettings().getLastAggregationOneDay(), MetricsAggregationBase.getToTime(MetricsUtils.AGGREGATION_TYPE.ONE_DAY), 86400000L);
        this.purgeMetricTables();
        MetricsAggregationBase.setAggregationRunning(false);
    }

    public static Long getToTime(MetricsUtils.AGGREGATION_TYPE aggregationType) {
        switch (aggregationType) {
            case ONE_MINUTE: {
                return System.currentTimeMillis() - 60000L;
            }
            case FIVE_MINUTES: {
                return System.currentTimeMillis() - 21600000L;
            }
            case ONE_HOUR: {
                return System.currentTimeMillis() - 604800000L;
            }
            case SIX_HOURS: {
                return System.currentTimeMillis() - 2592000000L;
            }
            case TWELVE_HOURS: {
                return System.currentTimeMillis() - 7776000000L;
            }
            case ONE_DAY: {
                return System.currentTimeMillis() - 15552000000L;
            }
        }
        return null;
    }

    public static List<MetricsDoubleTypeDevice> getMetricsDoubleData(SensorVariable sensorVariable, Long fromTimestamp, Long toTimestamp) {
        return DaoUtils.getMetricsDoubleTypeDeviceDao().getAll(MetricsDoubleTypeDevice.builder().sensorVariable(sensorVariable).timestampFrom(fromTimestamp).timestampTo(toTimestamp).build());
    }

    public static List<MetricsBinaryTypeDevice> getMetricsBinaryData(SensorVariable sensorVariable, Long fromTimestamp) {
        MetricsBinaryTypeDevice binaryTypeDevice = MetricsBinaryTypeDevice.builder().sensorVariable(sensorVariable).build();
        if (fromTimestamp != null) {
            binaryTypeDevice.setTimestampFrom(fromTimestamp);
        }
        return DaoUtils.getMetricsBinaryTypeDeviceDao().getAll(binaryTypeDevice);
    }

    private void purgeMetricTables() {
        MetricsSettings metricsSettings = ObjectFactory.getAppProperties().getMetricsSettings();
        MetricsDoubleTypeDevice metric = MetricsDoubleTypeDevice.builder().aggregationType(MetricsUtils.AGGREGATION_TYPE.RAW).timestamp(metricsSettings.getLastAggregationOneMinute()).build();
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(metric);
        metric.setAggregationType(MetricsUtils.AGGREGATION_TYPE.ONE_MINUTE);
        metric.setTimestamp(metricsSettings.getLastAggregationFiveMinutes());
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(metric);
        metric.setAggregationType(MetricsUtils.AGGREGATION_TYPE.FIVE_MINUTES);
        metric.setTimestamp(metricsSettings.getLastAggregationOneHour());
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(metric);
        metric.setAggregationType(MetricsUtils.AGGREGATION_TYPE.ONE_HOUR);
        metric.setTimestamp(metricsSettings.getLastAggregationSixHours());
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(metric);
        metric.setAggregationType(MetricsUtils.AGGREGATION_TYPE.SIX_HOURS);
        metric.setTimestamp(metricsSettings.getLastAggregationTwelveHours());
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(metric);
        metric.setAggregationType(MetricsUtils.AGGREGATION_TYPE.TWELVE_HOURS);
        metric.setTimestamp(metricsSettings.getLastAggregationOneDay());
        DaoUtils.getMetricsDoubleTypeDeviceDao().deletePrevious(metric);
    }

    public static synchronized boolean isAggregationRunning() {
        return isAggregationRunning;
    }

    public static synchronized void setAggregationRunning(boolean isAggregationRunning) {
        MetricsAggregationBase.isAggregationRunning = isAggregationRunning;
    }
}

