/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.timer;

import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.timer.TimerUtils;

public class TimerSimple {
    public static final String VALUE_SPLITTER = ",";
    private Timer timer;
    private Integer repeatCount;
    private Long repeatInterval;
    private Integer executedCount;

    public TimerSimple(Timer timer) {
        this.timer = timer;
        String[] repeat = timer.getFrequencyData().split(VALUE_SPLITTER);
        if (repeat.length != 2) {
            throw new RuntimeException("Invalid format:" + timer.getFrequencyData());
        }
        this.repeatCount = Integer.valueOf(repeat[0]);
        this.repeatInterval = Long.valueOf(repeat[1]);
        this.executedCount = timer.getInternalVariable1() == null ? 0 : Integer.valueOf(timer.getInternalVariable1());
    }

    public TimerSimple(String name, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, String payload, Integer repeatCount, Long repeatInterval) {
        this.timer = new Timer();
        this.timer.setTimerType(TimerUtils.TIMER_TYPE.SIMPLE);
        this.timer.setEnabled(true);
        this.timer.setName(name);
        this.timer.setResourceType(resourceType);
        this.timer.setResourceId(resourceId);
        this.timer.setPayload(payload);
        this.repeatCount = repeatCount;
        this.repeatInterval = repeatInterval;
        this.timer.setFrequencyData(repeatCount + VALUE_SPLITTER + this.repeatInterval);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    public Integer getExecutedCount() {
        return this.executedCount;
    }

    public void setExecutedCount(Integer executedCount) {
        this.executedCount = executedCount;
    }

    public void incrementExecutedCount() {
        TimerSimple timerSimple = this;
        Integer n = timerSimple.executedCount;
        Integer n2 = timerSimple.executedCount = Integer.valueOf(timerSimple.executedCount + 1);
    }

    public boolean isValid() {
        if (this.repeatCount == -1) {
            return true;
        }
        return this.repeatCount > this.executedCount;
    }

    public void update() {
        this.timer.setInternalVariable1(String.valueOf(this.executedCount));
        this.timer.setEnabled(this.isValid());
        if (this.timer.getEnabled().booleanValue()) {
            DaoUtils.getTimerDao().update(this.timer);
        } else {
            TimerUtils.updateTimer(this.timer);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Repeat[Interval:").append(this.repeatInterval).append(", Count:").append(this.repeatCount).append("], Executed count:").append(this.executedCount);
        return builder.toString();
    }
}

