/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Firmware;
import org.mycontroller.standalone.db.tables.FirmwareType;
import org.mycontroller.standalone.db.tables.FirmwareVersion;
import org.mycontroller.standalone.mysensors.firmware.FirmwareUtils;

@Path(value="/rest/firmwares")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FirmwareHandler {
    @GET
    @Path(value="/types")
    public Response getAllFirmwareTypes(@QueryParam(value="name") List<String> name, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("name", name);
        QueryResponse queryResponse = DaoUtils.getFirmwareTypeDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @GET
    @Path(value="/types/{id}")
    public Response getFirmwareType(@PathParam(value="id") int id) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getFirmwareTypeDao().getById(id));
    }

    @PUT
    @Path(value="/types")
    public Response updateFirmwareType(FirmwareType firmwareType) {
        DaoUtils.getFirmwareTypeDao().update(firmwareType);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/types")
    public Response createFirmwareType(FirmwareType firmwareType) {
        DaoUtils.getFirmwareTypeDao().create(firmwareType);
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @POST
    @Path(value="/types/delete")
    public Response deleteFirmwareType(List<Integer> ids) {
        for (Integer id : ids) {
            FirmwareUtils.deleteFirmwareType(id);
        }
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/versions")
    public Response getAllFirmwareVersions(@QueryParam(value="version") List<String> version, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("version", version);
        QueryResponse queryResponse = DaoUtils.getFirmwareVersionDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @GET
    @Path(value="/versions/{id}")
    public Response getFirmwareVersion(@PathParam(value="id") int id) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getFirmwareVersionDao().getById(id));
    }

    @PUT
    @Path(value="/versions")
    public Response updateFirmwareVersion(FirmwareVersion firmwareVersion) {
        DaoUtils.getFirmwareVersionDao().update(firmwareVersion);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/versions")
    public Response createFirmwareVersion(FirmwareVersion firmwareVersion) {
        DaoUtils.getFirmwareVersionDao().create(firmwareVersion);
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @POST
    @Path(value="/versions/delete")
    public Response deleteFirmwareVersion(List<Integer> ids) {
        for (Integer id : ids) {
            FirmwareUtils.deleteFirmwareVersion(id);
        }
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/firmwares")
    public Response getAllFirmwares(@QueryParam(value="typeId") Integer typeId, @QueryParam(value="versionId") Integer versionId, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("typeId", typeId);
        filters.put("versionId", versionId);
        QueryResponse queryResponse = DaoUtils.getFirmwareDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @GET
    @Path(value="/firmwares/{id}")
    public Response getFirmware(@QueryParam(value="withData") Boolean withData, @PathParam(value="id") int id) {
        Firmware firmware = (Firmware)DaoUtils.getFirmwareDao().getById(id);
        if (withData == null || !withData.booleanValue()) {
            firmware.setData(null);
        }
        return RestUtils.getResponse(Response.Status.OK, firmware);
    }

    @PUT
    @Path(value="/firmwares")
    public Response updateFirmware(Firmware firmware) {
        FirmwareUtils.updateFirmwareFromHexString(firmware);
        firmware.setTimestamp(System.currentTimeMillis());
        DaoUtils.getFirmwareDao().update(firmware);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/firmwares")
    public Response createFirmware(Firmware firmware) {
        FirmwareUtils.createFirmware(firmware);
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @POST
    @Path(value="/firmwares/delete")
    public Response deleteFirmware(List<Integer> ids) {
        for (Integer id : ids) {
            FirmwareUtils.deleteFirmware(id);
        }
        return RestUtils.getResponse(Response.Status.OK);
    }
}

