/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.ForwardPayload;

@Path(value="/rest/forwardpayload")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"admin"})
public class ForwardPayloadHandler {
    @POST
    @Path(value="/")
    public Response add(ForwardPayload forwardPayload) {
        if (forwardPayload.getSource().getId() == forwardPayload.getDestination().getId()) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Source and destination should be different!"));
        }
        DaoUtils.getForwardPayloadDao().create(forwardPayload);
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @PUT
    @Path(value="/")
    public Response update(ForwardPayload forwardPayload) {
        if (forwardPayload.getSource().getId() == forwardPayload.getDestination().getId()) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Source and destination should be different!"));
        }
        DaoUtils.getForwardPayloadDao().update(forwardPayload);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") int id) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getForwardPayloadDao().getById(id));
    }

    @GET
    @Path(value="/")
    public Response getAll(@QueryParam(value="sourceId") Integer sourceSensorId, @QueryParam(value="destinationId") Integer destinationSensorId, @QueryParam(value="enabled") Boolean enabled, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("sourceId", sourceSensorId);
        filters.put("destinationId", destinationSensorId);
        filters.put("enabled", enabled);
        QueryResponse queryResponse = DaoUtils.getForwardPayloadDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @POST
    @Path(value="/delete")
    public Response delete(List<Integer> ids) {
        DaoUtils.getForwardPayloadDao().deleteByIds(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/enable")
    public Response enable(List<Integer> ids) {
        DaoUtils.getForwardPayloadDao().enable(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/disable")
    public Response disable(List<Integer> ids) {
        DaoUtils.getForwardPayloadDao().disable(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }
}

