/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.api.jaxrs.utils.UserMapper;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.User;

@Path(value="/rest/users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"admin"})
public class UserHandler {
    @Context
    HttpRequest request;

    @GET
    @Path(value="/{userId}")
    public Response getUser(@PathParam(value="userId") int userId) {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getUserDao().get(userId));
    }

    @GET
    @Path(value="/")
    public Response getAll() {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getUserDao().getAll());
    }

    @DELETE
    @Path(value="/{userId}")
    public Response delete(@PathParam(value="userId") int userId) {
        User user = RestUtils.getUser(this.request);
        if (user.getId() == userId) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("You cannot delete yourself"));
        }
        UserMapper.removeUser(user.getName());
        DaoUtils.getUserDao().delete(userId);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @PUT
    @Path(value="/")
    public Response update(User user) {
        User userOrg = RestUtils.getUser(this.request);
        if (user.getId() == user.getId() && userOrg.getRoleId() != user.getRoleId()) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("You cannot change your role"));
        }
        DaoUtils.getUserDao().update(user);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/")
    public Response add(User user) {
        DaoUtils.getUserDao().create(user);
        return RestUtils.getResponse(Response.Status.CREATED);
    }
}

