/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db;

import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.ResourcesLogs;
import org.mycontroller.standalone.db.tables.Timer;

public class ResourcesLogsUtils {
    private ResourcesLogsUtils() {
    }

    public static boolean isLevel(LOG_LEVEL logLevel) {
        return true;
    }

    public static void setAlarmLog(LOG_LEVEL logLevel, AlarmDefinition alarmDefinition, Boolean triggered, String errorMsg) {
        StringBuilder builder = new StringBuilder();
        if (triggered.booleanValue()) {
            builder.append("Triggered: ");
        } else {
            builder.append("Failed: ");
        }
        builder.append("Name: ").append(alarmDefinition.getName()).append(", Condition: ").append(AlarmUtils.getConditionString(alarmDefinition)).append(", Resource:").append(AlarmUtils.getResourceString(alarmDefinition, true)).append(", Notification: ").append(alarmDefinition.getNotificationString());
        if (errorMsg != null) {
            builder.append(", Error: ").append(errorMsg);
        }
        ResourcesLogs resourcesLogs = ResourcesLogs.builder().timestamp(System.currentTimeMillis()).resourceType(AppProperties.RESOURCE_TYPE.ALARM_DEFINITION).resourceId(alarmDefinition.getId()).logLevel(logLevel).logDirection(LOG_DIRECTION.INTERNAL).message(builder.toString()).build();
        DaoUtils.getResourcesLogsDao().add(resourcesLogs);
    }

    public static void setTimerLog(LOG_LEVEL logLevel, Timer timer, String errorMsg) {
        StringBuilder builder = new StringBuilder();
        if (errorMsg != null) {
            builder.append("Failed: ").append(timer.getTimerDataString()).append(", Error: ").append(errorMsg);
        } else {
            builder.append("Fired: ").append(timer.getTimerDataString());
        }
        ResourcesLogs resourcesLogs = ResourcesLogs.builder().timestamp(System.currentTimeMillis()).resourceType(AppProperties.RESOURCE_TYPE.TIMER).resourceId(timer.getId()).logLevel(logLevel).logDirection(LOG_DIRECTION.INTERNAL).message(builder.toString()).build();
        DaoUtils.getResourcesLogsDao().add(resourcesLogs);
    }

    public static void recordSensorsResourcesLog(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, LOG_LEVEL logLevel, MYCMessages.MESSAGE_TYPE messageType, boolean isTxMessage, String message) {
        ResourcesLogs resourcesLogs = ResourcesLogs.builder().timestamp(System.currentTimeMillis()).resourceType(resourceType).resourceId(resourceId).messageType(messageType).logLevel(logLevel).logDirection(isTxMessage ? LOG_DIRECTION.SENT : LOG_DIRECTION.RECEIVED).message(message).build();
        DaoUtils.getResourcesLogsDao().add(resourcesLogs);
    }

    public static enum LOG_DIRECTION {
        INTERNAL("Internal"),
        SENT("Sent"),
        RECEIVED("Received");

        private String value;

        public static LOG_DIRECTION get(int id) {
            for (LOG_DIRECTION type : LOG_DIRECTION.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private LOG_DIRECTION(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static LOG_DIRECTION fromString(String text) {
            if (text != null) {
                for (LOG_DIRECTION type : LOG_DIRECTION.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum LOG_LEVEL {
        TRACE("Trace"),
        NOTICE("Notice"),
        INFO("Info"),
        WARNING("Warning"),
        ERROR("Error");

        private String value;

        public static LOG_LEVEL get(int id) {
            for (LOG_LEVEL type : LOG_LEVEL.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private LOG_LEVEL(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static LOG_LEVEL fromString(String text) {
            if (text != null) {
                for (LOG_LEVEL type : LOG_LEVEL.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

