/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.GatewayDao;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayUtils;

public class GatewayDaoImpl
extends BaseAbstractDaoImpl<Gateway, Integer>
implements GatewayDao {
    public GatewayDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Gateway.class);
    }

    @Override
    public List<Gateway> getAllEnabled() {
        return this.getAll(null, null, true);
    }

    @Override
    public List<Gateway> getAll(GatewayUtils.TYPE type, AppProperties.NETWORK_TYPE networkType) {
        return this.getAll(type, networkType, null);
    }

    @Override
    public List<Gateway> getAll(GatewayUtils.TYPE type, AppProperties.NETWORK_TYPE networkType, Boolean enabled) {
        try {
            if (type == null && networkType == null && enabled == null) {
                return this.getDao().queryForAll();
            }
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            Where where = queryBuilder.where();
            where.gt("id", (Object)0);
            if (enabled != null) {
                where.and().eq("enabled", (Object)enabled);
            }
            if (type != null) {
                where.and().eq("type", (Object)type);
            }
            if (networkType != null) {
                where.and().eq("networkType", (Object)networkType);
            }
            queryBuilder.setWhere(where);
            List gateways = this.getDao().query(queryBuilder.prepare());
            return gateways;
        }
        catch (SQLException ex) {
            _logger.error("unable to get all gateways:[type:{}, NetworkType:{}, Enabled:{}]", new Object[]{type.getText(), networkType, enabled, ex});
            return null;
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }

    @Override
    public Gateway get(Gateway tdao) {
        return (Gateway)this.getById(tdao.getId());
    }

    @Override
    public List<Gateway> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }
}

