/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.MetricsBatteryUsageDao;
import org.mycontroller.standalone.db.tables.MetricsBatteryUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsBatteryUsageDaoImpl
extends BaseAbstractDaoImpl<MetricsBatteryUsage, Integer>
implements MetricsBatteryUsageDao {
    private static final Logger _logger = LoggerFactory.getLogger(MetricsBatteryUsageDaoImpl.class);

    public MetricsBatteryUsageDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, MetricsBatteryUsage.class);
    }

    @Override
    public void deletePrevious(MetricsBatteryUsage metric) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("nodeId", (Object)metric.getNode().getEui()).and().lt("timestamp", (Object)metric.getTimestamp());
            int count = this.getDao().delete(deleteBuilder.prepare());
            _logger.debug("Metric:[{}] deleted, Delete count:{}", (Object)metric, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete metric:[{}]", (Object)metric, (Object)ex);
        }
    }

    @Override
    public void deleteByNodeRefId(int nodeId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("nodeId", (Object)nodeId);
            int count = this.getDao().delete(deleteBuilder.prepare());
            _logger.debug("Metric-nodeEui:[{}] deleted, Delete count:{}", (Object)nodeId, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete metric-nodeEui:[{}]", (Object)nodeId, (Object)ex);
        }
    }

    @Override
    public List<MetricsBatteryUsage> getAllAfter(MetricsBatteryUsage metric) {
        try {
            return this.getDao().query(this.getDao().queryBuilder().where().eq("nodeId", (Object)metric.getNode().getEui()).and().ge("timestamp", (Object)metric.getTimestamp()).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get, metric:{}", (Object)metric, (Object)ex);
            return null;
        }
    }

    @Override
    public List<MetricsBatteryUsage> getAll(int nodeId) {
        try {
            return this.getDao().query(this.getDao().queryBuilder().where().eq("nodeId", (Object)nodeId).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to getAll, nodeEui:{}", (Object)nodeId, (Object)ex);
            return null;
        }
    }

    @Override
    public MetricsBatteryUsage get(MetricsBatteryUsage metric) {
        try {
            return (MetricsBatteryUsage)this.getDao().queryForFirst(this.getDao().queryBuilder().where().eq("nodeId", (Object)metric.getNode().getEui()).and().eq("timestamp", (Object)metric.getTimestamp()).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get, metric:{}", (Object)metric, (Object)ex);
            return null;
        }
    }

    @Override
    public MetricsBatteryUsage getLast(int nodeId) {
        try {
            return (MetricsBatteryUsage)this.getDao().queryForFirst(this.getDao().queryBuilder().limit(Long.valueOf(1L)).orderBy("id", false).where().eq("nodeId", (Object)nodeId).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to getLast, nodeEui:{}", (Object)nodeId, (Object)ex);
            return null;
        }
    }

    @Override
    public List<MetricsBatteryUsage> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }
}

