/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.UserDao;
import org.mycontroller.standalone.db.tables.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDaoImpl
extends BaseAbstractDaoImpl<User, Integer>
implements UserDao {
    private static final Logger _logger = LoggerFactory.getLogger(UserDaoImpl.class);

    public UserDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, User.class);
    }

    @Override
    public void create(User user) {
        try {
            int count = this.getDao().create((Object)user);
            _logger.debug("Created User:[{}], Create count:{}", (Object)user, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add User:[{}]", (Object)user, (Object)ex);
        }
    }

    @Override
    public void createOrUpdate(User user) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)user);
            _logger.debug("CreateOrUpdate User:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{user, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate User:[{}]", (Object)user, (Object)ex);
        }
    }

    @Override
    public void delete(User user) {
        try {
            int count = this.getDao().delete((Object)user);
            _logger.debug("User:[{}] deleted, Delete count:{}", (Object)user, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete user:[{}]", (Object)user, (Object)ex);
        }
    }

    @Override
    public void delete(int userId) {
        User user = new User(userId);
        this.delete(user);
    }

    @Override
    public void update(User user) {
        try {
            int count = this.getDao().update((Object)user);
            _logger.debug("Updated User:[{}], Update count:{}", (Object)user, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update user:[{}]", (Object)user, (Object)ex);
        }
    }

    @Override
    public List<User> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all Nodes", (Throwable)ex);
            return null;
        }
    }

    @Override
    public User get(User user) {
        if (user.getId() != null) {
            return this.get(user.getId());
        }
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            if (user.getName() != null) {
                queryBuilder.where().eq("name", (Object)user.getName());
            } else if (user.getEmail() != null) {
                queryBuilder.where().eq("email", (Object)user.getEmail());
            }
            List users = this.getDao().query(queryBuilder.prepare());
            if (users.size() > 0) {
                return (User)users.get(0);
            }
            return null;
        }
        catch (SQLException ex) {
            _logger.error("unable to get, user:{}", (Object)user, (Object)ex);
            return null;
        }
    }

    @Override
    public User get(int userId) {
        try {
            return (User)this.getDao().queryForId((Object)userId);
        }
        catch (SQLException ex) {
            _logger.error("unable to get User", (Throwable)ex);
            return null;
        }
    }

    @Override
    public User get(String userName) {
        return this.get(new User(userName));
    }
}

