/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.db.ResourcesLogsUtils;
import org.mycontroller.standalone.model.ResourceModel;

@DatabaseTable(tableName="resources_logs")
public class ResourcesLogs {
    public static final String KEY_ID = "id";
    public static final String KEY_LOG_LEVEL = "logLevel";
    public static final String KEY_RESOURCE_TYPE = "resourceType";
    public static final String KEY_RESOURCE_ID = "resourceId";
    public static final String KEY_MESSAGE_TYPE = "messageType";
    public static final String KEY_LOG_DIRECTION = "logDirection";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TIMESTAMP = "timestamp";
    @DatabaseField(generatedId=true, columnName="id")
    private Integer id;
    @DatabaseField(dataType=DataType.ENUM_INTEGER, columnName="logLevel")
    private ResourcesLogsUtils.LOG_LEVEL logLevel;
    @DatabaseField(dataType=DataType.ENUM_STRING, columnName="resourceType")
    private AppProperties.RESOURCE_TYPE resourceType;
    @DatabaseField(canBeNull=true, columnName="resourceId")
    private Integer resourceId;
    @DatabaseField(dataType=DataType.ENUM_INTEGER, columnName="messageType")
    private MYCMessages.MESSAGE_TYPE messageType;
    @DatabaseField(dataType=DataType.ENUM_INTEGER, columnName="logDirection")
    private ResourcesLogsUtils.LOG_DIRECTION logDirection;
    @DatabaseField(canBeNull=false, columnName="message")
    private String message;
    @DatabaseField(canBeNull=false, columnName="timestamp")
    private Long timestamp;

    public String getResource() {
        try {
            return new ResourceModel(this.resourceType, this.resourceId).getResourceLessDetails();
        }
        catch (Exception exception) {
            return "Resource not available!";
        }
    }

    public static ResourcesLogsBuilder builder() {
        return new ResourcesLogsBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public ResourcesLogsUtils.LOG_LEVEL getLogLevel() {
        return this.logLevel;
    }

    public AppProperties.RESOURCE_TYPE getResourceType() {
        return this.resourceType;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public MYCMessages.MESSAGE_TYPE getMessageType() {
        return this.messageType;
    }

    public ResourcesLogsUtils.LOG_DIRECTION getLogDirection() {
        return this.logDirection;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setLogLevel(ResourcesLogsUtils.LOG_LEVEL logLevel) {
        this.logLevel = logLevel;
    }

    public void setResourceType(AppProperties.RESOURCE_TYPE resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public void setMessageType(MYCMessages.MESSAGE_TYPE messageType) {
        this.messageType = messageType;
    }

    public void setLogDirection(ResourcesLogsUtils.LOG_DIRECTION logDirection) {
        this.logDirection = logDirection;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcesLogs)) {
            return false;
        }
        ResourcesLogs other = (ResourcesLogs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ResourcesLogsUtils.LOG_LEVEL this$logLevel = this.getLogLevel();
        ResourcesLogsUtils.LOG_LEVEL other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel)) {
            return false;
        }
        AppProperties.RESOURCE_TYPE this$resourceType = this.getResourceType();
        AppProperties.RESOURCE_TYPE other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        Integer this$resourceId = this.getResourceId();
        Integer other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !((Object)this$resourceId).equals(other$resourceId)) {
            return false;
        }
        MYCMessages.MESSAGE_TYPE this$messageType = this.getMessageType();
        MYCMessages.MESSAGE_TYPE other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        ResourcesLogsUtils.LOG_DIRECTION this$logDirection = this.getLogDirection();
        ResourcesLogsUtils.LOG_DIRECTION other$logDirection = other.getLogDirection();
        if (this$logDirection == null ? other$logDirection != null : !((Object)((Object)this$logDirection)).equals((Object)other$logDirection)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcesLogs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ResourcesLogsUtils.LOG_LEVEL $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        AppProperties.RESOURCE_TYPE $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        Integer $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : ((Object)$resourceId).hashCode());
        MYCMessages.MESSAGE_TYPE $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        ResourcesLogsUtils.LOG_DIRECTION $logDirection = this.getLogDirection();
        result = result * 59 + ($logDirection == null ? 43 : ((Object)((Object)$logDirection)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public ResourcesLogs() {
    }

    @ConstructorProperties(value={"id", "logLevel", "resourceType", "resourceId", "messageType", "logDirection", "message", "timestamp"})
    public ResourcesLogs(Integer id, ResourcesLogsUtils.LOG_LEVEL logLevel, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, MYCMessages.MESSAGE_TYPE messageType, ResourcesLogsUtils.LOG_DIRECTION logDirection, String message, Long timestamp) {
        this.id = id;
        this.logLevel = logLevel;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.messageType = messageType;
        this.logDirection = logDirection;
        this.message = message;
        this.timestamp = timestamp;
    }

    public String toString() {
        return "ResourcesLogs(id=" + this.getId() + ", logLevel=" + (Object)((Object)this.getLogLevel()) + ", resourceType=" + (Object)((Object)this.getResourceType()) + ", resourceId=" + this.getResourceId() + ", messageType=" + (Object)((Object)this.getMessageType()) + ", logDirection=" + (Object)((Object)this.getLogDirection()) + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class ResourcesLogsBuilder {
        private Integer id;
        private ResourcesLogsUtils.LOG_LEVEL logLevel;
        private AppProperties.RESOURCE_TYPE resourceType;
        private Integer resourceId;
        private MYCMessages.MESSAGE_TYPE messageType;
        private ResourcesLogsUtils.LOG_DIRECTION logDirection;
        private String message;
        private Long timestamp;

        ResourcesLogsBuilder() {
        }

        public ResourcesLogsBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ResourcesLogsBuilder logLevel(ResourcesLogsUtils.LOG_LEVEL logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public ResourcesLogsBuilder resourceType(AppProperties.RESOURCE_TYPE resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourcesLogsBuilder resourceId(Integer resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public ResourcesLogsBuilder messageType(MYCMessages.MESSAGE_TYPE messageType) {
            this.messageType = messageType;
            return this;
        }

        public ResourcesLogsBuilder logDirection(ResourcesLogsUtils.LOG_DIRECTION logDirection) {
            this.logDirection = logDirection;
            return this;
        }

        public ResourcesLogsBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ResourcesLogsBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ResourcesLogs build() {
            return new ResourcesLogs(this.id, this.logLevel, this.resourceType, this.resourceId, this.messageType, this.logDirection, this.message, this.timestamp);
        }

        public String toString() {
            return "ResourcesLogs.ResourcesLogsBuilder(id=" + this.id + ", logLevel=" + (Object)((Object)this.logLevel) + ", resourceType=" + (Object)((Object)this.resourceType) + ", resourceId=" + this.resourceId + ", messageType=" + (Object)((Object)this.messageType) + ", logDirection=" + (Object)((Object)this.logDirection) + ", message=" + this.message + ", timestamp=" + this.timestamp + ")";
        }
    }
}

