/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.fwpayload;

import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.tables.ForwardPayload;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteForwardPayload
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(ExecuteForwardPayload.class);
    private List<ForwardPayload> forwardPayloads;
    private Sensor sensor;
    private SensorVariable sensorVariable;

    public ExecuteForwardPayload(List<ForwardPayload> forwardPayloads, Sensor sensor, SensorVariable sensorVariable) {
        this.forwardPayloads = forwardPayloads;
        this.sensor = sensor;
        this.sensorVariable = sensorVariable;
    }

    private void execute(ForwardPayload forwardPayload) {
        _logger.debug("Sensor:[{}], Details of ForwardPayload:[{}]", (Object)this.sensor, (Object)forwardPayload);
        switch (forwardPayload.getDestination().getSensor().getNode().getGateway().getNetworkType()) {
            case MY_SENSORS: {
                ObjectFactory.getIActionEngine(AppProperties.NETWORK_TYPE.MY_SENSORS).executeForwardPayload(forwardPayload, this.sensorVariable.getValue());
                break;
            }
        }
    }

    @Override
    public void run() {
        for (ForwardPayload forwardPayload : this.forwardPayloads) {
            try {
                this.execute(forwardPayload);
            }
            catch (Exception ex) {
                _logger.error("Unable to execute ForwardPayload:[{}], Sensor:[{}]", new Object[]{forwardPayload, this.sensor, ex});
            }
        }
    }
}

