/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.ethernet;

import java.io.IOException;
import java.net.Socket;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.gateway.GatewayEthernet;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.ethernet.EthernetGatewayListener;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetGatewayActionThread
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger((String)EthernetGatewayActionThread.class.getName());
    private Socket socket = null;
    private EthernetGatewayListener ethernetGatewayListener = null;
    private boolean terminated = false;
    private boolean terminate = false;
    private boolean reconnect = false;
    private Thread ethernetGatewayListenerThread = null;
    public static final long RETRY_WAIT_TIME = 5000L;
    public static final long THREAD_TERMINATION_WAIT_TIME = 5000L;
    private GatewayEthernet gateway = null;

    public EthernetGatewayActionThread(GatewayEthernet gateway) {
        this.gateway = gateway;
        try {
            this.socket = new Socket(this.gateway.getHost(), (int)this.gateway.getPort());
            this.socket.setKeepAlive(true);
            this.ethernetGatewayListener = new EthernetGatewayListener(this.socket, this.gateway);
            this.ethernetGatewayListenerThread = new Thread(this.ethernetGatewayListener);
            this.ethernetGatewayListenerThread.start();
            _logger.info("Connected successfully with EthernetGateway[{}:{}]", (Object)gateway.getHost(), (Object)gateway.getPort());
            this.gateway.setStatus(AppProperties.STATE.UP, "Connected Successfully");
            this.gateway.updateGateway();
        }
        catch (Exception ex) {
            _logger.error("Exception, ", (Throwable)ex);
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            this.reconnect = true;
        }
    }

    public synchronized void close() {
        if (this.ethernetGatewayListener != null) {
            this.ethernetGatewayListener.setTerminate(true);
        }
        this.setTerminate(true);
        long waitTime = 5000L;
        while (!this.isTerminated() && waitTime > 0L) {
            try {
                Thread.sleep(100L);
                waitTime -= 100L;
            }
            catch (InterruptedException ex) {
                _logger.error("Error,", (Throwable)ex);
            }
        }
        if (waitTime <= 0L) {
            _logger.warn("Terminating abnormally EthernetGatewayActionThread!");
        }
        try {
            this.socket.close();
            _logger.info("EthernetGateway[{}:{}] closed", (Object)this.gateway.getHost(), (Object)this.gateway.getPort());
        }
        catch (Exception ex) {
            _logger.error("Exception,", (Throwable)ex);
        }
    }

    public synchronized void write(RawMessage rawMessage) throws GatewayException {
        try {
            this.socket.getOutputStream().write(rawMessage.getGWBytes());
            this.socket.getOutputStream().flush();
        }
        catch (IOException ex) {
            _logger.error("Exception,", (Throwable)ex);
            this.reconnect = true;
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            throw new GatewayException(IGateway.GATEWAY_STATUS.GATEWAY_ERROR.toString() + ": There is no connection with EthernetGateway!");
        }
    }

    private void reconnect() {
        _logger.debug("Reconnecting to EthernetGateway...");
        if (this.ethernetGatewayListener != null) {
            this.ethernetGatewayListener.setTerminate(true);
            _logger.debug("Waiting to terminate previous EthernetGatewayListener...");
            long waitTime = 0L;
            while (!this.ethernetGatewayListener.isTerminated() && waitTime <= 5000L && !this.isTerminate()) {
                try {
                    Thread.sleep(100L);
                    waitTime += 100L;
                }
                catch (InterruptedException ex) {
                    _logger.error("Error,", (Throwable)ex);
                }
            }
            _logger.debug("Completed: Terminate previous EthernetGatewayListener...");
            this.ethernetGatewayListener = null;
        }
        if (this.ethernetGatewayListenerThread != null && this.ethernetGatewayListenerThread.isAlive()) {
            _logger.warn("EthernetGatewayListener Thread is running and about to start another thread. Fix this issue...");
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.socket = new Socket(this.gateway.getHost(), (int)this.gateway.getPort());
            this.socket.setKeepAlive(true);
            this.ethernetGatewayListener = new EthernetGatewayListener(this.socket, this.gateway);
            this.ethernetGatewayListenerThread = new Thread(this.ethernetGatewayListener);
            this.ethernetGatewayListenerThread.start();
            this.reconnect = false;
            this.gateway.setStatus(AppProperties.STATE.UP, "Reconnected Successfully");
            this.gateway.updateGateway();
            _logger.info("Reconnected gateway successfully...");
        }
        catch (IOException ex) {
            _logger.error("Gateway Exception: {}", (Object)ex.getMessage());
            _logger.trace("Detailed exception trace", (Throwable)ex);
        }
    }

    private boolean checkAliveState() {
        return ObjectFactory.getIActionEngine(this.gateway.getNetworkType()).checkEthernetGatewayAliveState(this.gateway);
    }

    @Override
    public void run() {
        while (!this.isTerminate()) {
            try {
                if (this.reconnect) {
                    for (long retryWaitTime = 5000L; retryWaitTime > 0L && !this.isTerminate(); retryWaitTime -= 100L) {
                        Thread.sleep(100L);
                    }
                    if (this.isTerminate()) continue;
                    this.reconnect();
                    continue;
                }
                for (long aliveInterval = (long)(this.gateway.getAliveFrequency() * 1000); aliveInterval > 0L && !this.isTerminate() && !this.reconnect; aliveInterval -= 100L) {
                    Thread.sleep(100L);
                }
                if (this.isTerminate() || this.reconnect || this.checkAliveState()) continue;
                this.reconnect = true;
            }
            catch (Exception ex) {
                _logger.error("Exception,", (Throwable)ex);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    _logger.error("Exception,", (Throwable)e);
                }
            }
        }
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public synchronized void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public GatewayEthernet getGateway() {
        return this.gateway;
    }
}

