/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.mqtt;

import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.gateway.GatewayException;
import org.mycontroller.standalone.gateway.GatewayMQTT;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.mqtt.MqttCallbackListener;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttGatewayImpl
implements IGateway {
    private static final Logger _logger = LoggerFactory.getLogger((String)MqttGatewayImpl.class.getName());
    public static final long TIME_TO_WAIT = 100L;
    public static final long DISCONNECT_TIME_OUT = 1000L;
    public static final int CONNECTION_TIME_OUT = 5000;
    public static final int KEEP_ALIVE = 5000;
    public static final int MY_SENSORS_QOS = 0;
    private GatewayMQTT gateway = null;
    private IMqttClient mqttClient;
    private MqttCallbackListener mqttCallbackListener;

    public MqttGatewayImpl(Gateway gateway) {
        try {
            this.gateway = new GatewayMQTT(gateway);
            this.mqttClient = new MqttClient(this.gateway.getBrokerHost(), this.gateway.getClientId());
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setConnectionTimeout(5000);
            connectOptions.setKeepAliveInterval(5000);
            if (this.gateway.getUserName() != null && this.gateway.getUserName().length() > 0) {
                connectOptions.setUserName(this.gateway.getUserName());
                connectOptions.setPassword(this.gateway.getPassword().toCharArray());
            }
            this.mqttClient.connect(connectOptions);
            this.mqttCallbackListener = new MqttCallbackListener(this.mqttClient, this.gateway);
            this.mqttClient.setCallback((MqttCallback)this.mqttCallbackListener);
            this.mqttClient.subscribe(this.gateway.getTopicSubscribe() + "/#");
            _logger.info("MQTT Gateway[{}] connected successfully..", (Object)this.mqttClient.getServerURI());
            this.gateway.setStatus(AppProperties.STATE.UP, "Connected Successfully");
            this.gateway.updateGateway();
        }
        catch (MqttException ex) {
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            _logger.error("Unable to connect with MQTT broker gateway[{}], Reason Code: {}, Reload gateway [Id:{}, Name:{}] service once MQTT Broker gateway comes UP!", new Object[]{this.mqttClient.getServerURI(), ex.getReasonCode(), gateway.getName(), ex});
        }
    }

    @Override
    public synchronized void write(RawMessage rawMessage) throws GatewayException {
        _logger.debug("Message to send, Topic:[{}], PayLoad:[{}]", (Object)rawMessage.getSubData(), (Object)rawMessage.getData());
        try {
            MqttMessage message = new MqttMessage(rawMessage.getData().getBytes());
            message.setQos(0);
            this.mqttClient.publish(rawMessage.getSubData(), message);
        }
        catch (MqttException ex) {
            if (ex.getMessage().contains("Timed out waiting for a response from the server")) {
                _logger.debug(ex.getMessage());
            }
            _logger.error("Exception, Reason Code:{}", (Object)ex.getReasonCode(), (Object)ex);
            throw new GatewayException((Object)((Object)IGateway.GATEWAY_STATUS.GATEWAY_ERROR) + ": Reason Code: " + ex.getReasonCode() + ", Error: " + ex.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.mqttCallbackListener.setReconnect(false);
            this.mqttClient.disconnect(1000L);
            this.mqttClient.close();
        }
        catch (Exception ex) {
            _logger.error("Exception,", (Throwable)ex);
        }
    }

    @Override
    public GatewayMQTT getGateway() {
        return this.gateway;
    }
}

