/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataEventListener;
import java.io.IOException;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDataListenerPi4j
implements SerialDataEventListener {
    private static Logger _logger = LoggerFactory.getLogger((String)SerialDataListenerPi4j.class.getName());
    StringBuilder message = new StringBuilder();
    private GatewaySerial gateway;

    public SerialDataListenerPi4j(GatewaySerial gateway) {
        this.gateway = gateway;
    }

    public void dataReceived(SerialDataEvent event) {
        try {
            byte[] buffer;
            for (byte b : buffer = event.getBytes()) {
                if (b == 10 && this.message.length() > 0) {
                    String toProcess = this.message.toString();
                    _logger.debug("Received a message:[{}]", (Object)toProcess);
                    ObjectFactory.getRawMessageQueue().putMessage(new RawMessage(this.gateway.getId(), toProcess));
                    this.message.setLength(0);
                    continue;
                }
                if (b != 10) {
                    _logger.trace("Received a char:[{}]", (Object)Character.valueOf((char)b));
                    this.message.append((char)b);
                    continue;
                }
                if (this.message.length() >= 1000) {
                    _logger.warn("Serial receive buffer size reached to MAX level[{} chars], Now clearing the buffer. Existing data:[{}]", (Object)1000, (Object)this.message.toString());
                    this.message.setLength(0);
                    continue;
                }
                _logger.debug("Received MESSAGE_SPLITTER and current message length is ZERO! Nothing to do");
            }
        }
        catch (IOException ex) {
            _logger.error("exception on pi4j data event, ", (Throwable)ex);
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            this.message.setLength(0);
        }
        catch (Exception ex) {
            _logger.error("Exception,", (Object)ex.getMessage());
            this.message.setLength(0);
        }
    }
}

