/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.message;

import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static Logger _logger = LoggerFactory.getLogger((String)MessageUtils.class.getName());

    private MessageUtils() {
    }

    public static synchronized void sendMessgaeToGateway(RawMessage rawMessage) {
        try {
            if (ObjectFactory.getGateway(rawMessage.getGatewayId()) != null) {
                ObjectFactory.getGateway(rawMessage.getGatewayId()).write(rawMessage);
            } else {
                _logger.error("Selected gateway not available! Gateway:[{}]", DaoUtils.getGatewayDao().getById(rawMessage.getGatewayId()));
            }
        }
        catch (Exception ex) {
            _logger.error("Message send failed! Message:[{}]", (Object)rawMessage, (Object)ex);
        }
    }
}

