/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.scheduler;

import com.xeiam.sundial.SundialJobScheduler;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.SystemJob;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.jobs.NodeAliveStatusJob;
import org.mycontroller.standalone.timer.TimerSimple;
import org.mycontroller.standalone.timer.TimerUtils;
import org.mycontroller.standalone.timer.jobs.TimerJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerUtils {
    public static final String JOB_DATA = "job-data";
    public static final String SYSTEM_JOB_REF = "SYS_";
    public static final String TIMER_JOB_REF = "TIMER_";
    public static final String CRON_TRIGGER_REF = "_Cron_Trigger";
    private static final long FROM_TIME_DELAY = 1000L;
    private static final Logger _logger = LoggerFactory.getLogger(SchedulerUtils.class);

    private SchedulerUtils() {
    }

    public static void startScheduler() {
        SundialJobScheduler.startScheduler();
        _logger.debug("SundialJobScheduler started.Jobs:[{}]", (Object)SundialJobScheduler.getAllJobNames());
        List<SystemJob> systemJobs = DaoUtils.getSystemJobDao().getAllEnabled();
        for (SystemJob systemJob : systemJobs) {
            SchedulerUtils.addSystemJob(systemJob);
        }
        List<Timer> timers = DaoUtils.getTimerDao().getAllEnabled();
        for (Timer timer : timers) {
            try {
                SchedulerUtils.loadTimerJob(timer);
            }
            catch (Exception ex) {
                _logger.error("Unable to load timer[{}]", (Object)timer, (Object)ex);
            }
        }
        SchedulerUtils.startNodeAliveCheckJob();
    }

    public static List<String> getJobs() {
        return SundialJobScheduler.getAllJobNames();
    }

    public static void stop() {
        SundialJobScheduler.shutdown();
        _logger.debug("Scheduler stopped...");
    }

    public static String getSystemJobName(SystemJob systemJob) {
        return SYSTEM_JOB_REF + systemJob.getId() + "_" + systemJob.getName();
    }

    public static void addSystemJob(SystemJob systemJob) {
        String jobName = SchedulerUtils.getSystemJobName(systemJob);
        SundialJobScheduler.addJob((String)jobName, (String)systemJob.getClassName());
        SundialJobScheduler.addCronTrigger((String)SchedulerUtils.getCronTriggerName(jobName), (String)jobName, (String)systemJob.getCron());
        _logger.debug("New job added:{}", (Object)systemJob);
    }

    public static void removeSystemJob(SystemJob systemJob) {
        SchedulerUtils.removeJob(SchedulerUtils.getSystemJobName(systemJob));
    }

    public static void removeJob(String jobName) {
        SundialJobScheduler.removeJob((String)jobName);
        SundialJobScheduler.removeTrigger((String)SchedulerUtils.getCronTriggerName(jobName));
        _logger.debug("Job removed:[Name:{},CronName:{}]", (Object)jobName, (Object)SchedulerUtils.getCronTriggerName(jobName));
    }

    public static String getTimerJobName(Timer timer) {
        if (timer.getId() != null) {
            return TIMER_JOB_REF + timer.getId() + "_" + timer.getName();
        }
        return "TIMER__" + timer.getName();
    }

    public static String getCronTriggerName(String jobName) {
        return jobName + CRON_TRIGGER_REF;
    }

    public static synchronized void loadTimerJob(Timer timer) {
        if (!timer.getEnabled().booleanValue()) {
            _logger.debug("Timer[{}] disabled. No action needed", (Object)timer);
            return;
        }
        if (timer.getValidityTo() != null && timer.getValidityTo() <= System.currentTimeMillis()) {
            _logger.warn("This timer job expired! Timer:[{}]", (Object)timer);
            return;
        }
        HashMap<String, Timer> jobData = new HashMap<String, Timer>();
        jobData.put("timer_referance_key", timer);
        String jobName = SchedulerUtils.getTimerJobName(timer);
        SundialJobScheduler.addJob((String)jobName, (String)TimerJob.class.getName(), jobData, (boolean)false);
        Calendar timeCal = null;
        Calendar sunssCal = null;
        if (TimerUtils.TIMER_TYPE.CRON != timer.getTimerType() && TimerUtils.TIMER_TYPE.SIMPLE != timer.getTimerType()) {
            timeCal = Calendar.getInstance();
            timeCal.setTimeInMillis(timer.getTriggerTime());
            sunssCal = Calendar.getInstance();
        }
        switch (timer.getTimerType()) {
            case CRON: 
            case SIMPLE: 
            case NORMAL: {
                break;
            }
            case BEFORE_SUNRISE: {
                sunssCal.setTime(TimerUtils.getSunriseTime());
                sunssCal.add(11, -timeCal.get(11));
                sunssCal.add(12, -timeCal.get(12));
                sunssCal.add(13, -timeCal.get(13));
                timeCal = sunssCal;
                break;
            }
            case AFTER_SUNRISE: {
                sunssCal.setTime(TimerUtils.getSunriseTime());
                sunssCal.add(11, timeCal.get(11));
                sunssCal.add(12, timeCal.get(12));
                sunssCal.add(13, timeCal.get(13));
                timeCal = sunssCal;
                break;
            }
            case BEFORE_SUNSET: {
                sunssCal.setTime(TimerUtils.getSunsetTime());
                sunssCal.add(11, -timeCal.get(11));
                sunssCal.add(12, -timeCal.get(12));
                sunssCal.add(13, -timeCal.get(13));
                timeCal = sunssCal;
                break;
            }
            case AFTER_SUNSET: {
                sunssCal.setTime(TimerUtils.getSunsetTime());
                sunssCal.add(11, timeCal.get(11));
                sunssCal.add(12, timeCal.get(12));
                sunssCal.add(13, timeCal.get(13));
                timeCal = sunssCal;
                break;
            }
        }
        String cronExpression = null;
        if (TimerUtils.TIMER_TYPE.CRON == timer.getTimerType()) {
            cronExpression = timer.getFrequencyData();
        } else if (TimerUtils.TIMER_TYPE.SIMPLE != timer.getTimerType()) {
            cronExpression = SchedulerUtils.getCronExpression(timeCal.get(13), timeCal.get(12), timeCal.get(11), timer);
        }
        if (timer.getValidityFrom() != null && timer.getValidityFrom() <= System.currentTimeMillis()) {
            timer.setValidityFrom(System.currentTimeMillis() + 1000L);
        }
        if (TimerUtils.TIMER_TYPE.SIMPLE == timer.getTimerType()) {
            TimerSimple timerSimple = new TimerSimple(timer);
            if (timerSimple.isValid()) {
                SundialJobScheduler.addSimpleTrigger((String)SchedulerUtils.getCronTriggerName(jobName), (String)jobName, (int)timerSimple.getRepeatCount(), (long)timerSimple.getRepeatInterval(), (Date)(timer.getValidityFrom() != null ? new Date(timer.getValidityFrom()) : new Date(System.currentTimeMillis() + timerSimple.getRepeatInterval())), (Date)(timer.getValidityTo() != null ? new Date(timer.getValidityTo()) : null));
                _logger.debug("New simple timer job added:[{}], CornExpression:[{}]", (Object)timer, (Object)cronExpression);
            } else {
                _logger.warn("Invalid timer job:[{}]", (Object)timer);
            }
        } else {
            SundialJobScheduler.addCronTrigger((String)SchedulerUtils.getCronTriggerName(jobName), (String)jobName, (String)cronExpression, (Date)(timer.getValidityFrom() != null ? new Date(timer.getValidityFrom()) : null), (Date)(timer.getValidityTo() != null ? new Date(timer.getValidityTo()) : null));
            _logger.debug("New timer job added:[{}], CornExpression:[{}]", (Object)timer, (Object)cronExpression);
        }
    }

    public static String getCronExpression(int sec, int min, int hour, Timer timer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sec).append(" ").append(min).append(" ").append(hour).append(" ");
        switch (timer.getFrequencyType()) {
            case DAILY: 
            case WEEKLY: {
                String[] days;
                stringBuilder.append("? * ");
                for (String day : days = timer.getFrequencyData().split(",")) {
                    stringBuilder.append(TimerUtils.WEEK_DAY.fromString(day).getText()).append(",");
                }
                stringBuilder.delete(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1);
                break;
            }
            case MONTHLY: {
                stringBuilder.append(timer.getFrequencyData());
                stringBuilder.append(" * ?");
                break;
            }
        }
        return stringBuilder.toString();
    }

    public static synchronized void unloadTimerJob(Timer timer) {
        SchedulerUtils.removeJob(SchedulerUtils.getTimerJobName(timer));
    }

    public static synchronized void unloadTimerJobs(List<Timer> timers) {
        for (Timer timer : timers) {
            SchedulerUtils.unloadTimerJob(timer);
        }
    }

    public static synchronized void reloadTimerJob(Timer timer) {
        SchedulerUtils.unloadTimerJob(timer);
        SchedulerUtils.loadTimerJob(timer);
    }

    public static void startNodeAliveCheckJob() {
        SundialJobScheduler.addJob((String)"node_alive_status_job", (String)NodeAliveStatusJob.class.getName());
        SundialJobScheduler.addSimpleTrigger((String)"node_alive_status_trigger", (String)"node_alive_status_job", (int)-1, (long)ObjectFactory.getAppProperties().getControllerSettings().getAliveCheckInterval());
    }

    public static void stopNodeAliveCheckJob() {
        SundialJobScheduler.removeJob((String)"node_alive_status_job");
    }

    public static void reloadMySensorHearbeatJob() {
        SchedulerUtils.stopNodeAliveCheckJob();
        SchedulerUtils.startNodeAliveCheckJob();
    }
}

