/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.timer.jobs;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.JobContext;
import com.xeiam.sundial.exceptions.JobInterruptException;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.PayloadOperation;
import org.mycontroller.standalone.db.ResourcesLogsUtils;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.model.ResourceModel;
import org.mycontroller.standalone.timer.TimerSimple;
import org.mycontroller.standalone.timer.TimerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerJob
extends Job {
    private static final Logger _logger = LoggerFactory.getLogger(TimerJob.class);
    public static final String TIMER_REF = "timer_referance_key";

    private void executeTimer(Timer timer) {
        if (timer.getId() != null && timer.getTimerType() == TimerUtils.TIMER_TYPE.SIMPLE) {
            TimerSimple timerSimple = new TimerSimple(timer);
            timerSimple.incrementExecutedCount();
            timerSimple.update();
        }
        PayloadOperation payloadOperation = new PayloadOperation(timer.getPayload());
        ResourceModel resourceModel = new ResourceModel(timer.getResourceType(), timer.getResourceId());
        if (resourceModel.getResourceType() == AppProperties.RESOURCE_TYPE.GATEWAY) {
            GatewayUtils.executeGatewayOperation(resourceModel, payloadOperation);
        } else {
            ObjectFactory.getIActionEngine(resourceModel.getNetworkType()).executeSendPayload(resourceModel, payloadOperation);
        }
    }

    public void doRun() throws JobInterruptException {
        JobContext context = this.getJobContext();
        Timer timer = (Timer)context.map.get(TIMER_REF);
        _logger.debug("Executing timer:[{}]", (Object)timer);
        try {
            this.executeTimer(timer);
            if (timer.getId() != null) {
                ResourcesLogsUtils.setTimerLog(ResourcesLogsUtils.LOG_LEVEL.INFO, timer, null);
            }
        }
        catch (Exception ex) {
            if (timer.getId() != null) {
                ResourcesLogsUtils.setTimerLog(ResourcesLogsUtils.LOG_LEVEL.ERROR, timer, ex.getMessage());
            }
            _logger.error("Exception, ", (Throwable)ex);
        }
    }
}

