/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.robocode.battle.BaseBattle;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.battle.Command;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.battle.peer.BulletPeer;
import net.sf.robocode.battle.peer.ContestantPeer;
import net.sf.robocode.battle.peer.RobotPeer;
import net.sf.robocode.battle.peer.TeamPeer;
import net.sf.robocode.battle.snapshot.TurnSnapshot;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.settings.ISettingsManager;
import robocode.BattleEndedEvent;
import robocode.BattleResults;
import robocode.BattleRules;
import robocode.Event;
import robocode.RobotDeathEvent;
import robocode.WinEvent;
import robocode.control.RandomFactory;
import robocode.control.RobotResults;
import robocode.control.RobotSpecification;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.RoundEndedEvent;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;
import robocode.control.events.TurnStartedEvent;
import robocode.control.snapshot.BulletState;
import robocode.control.snapshot.ITurnSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Battle
extends BaseBattle {
    private final IHostManager hostManager;
    private final long cpuConstant;
    private int inactiveTurnCount;
    private double inactivityEnergy;
    private boolean parallelOn;
    static final int DEBUG_TURN_WAIT = 600000;
    private long millisWait;
    private int microWait;
    private int robotsCount;
    private List<RobotPeer> robots = new ArrayList<RobotPeer>();
    private List<ContestantPeer> contestants = new ArrayList<ContestantPeer>();
    private final List<BulletPeer> bullets = new CopyOnWriteArrayList<BulletPeer>();
    private int activeRobots;
    private final List<RobotPeer> deathRobots = new CopyOnWriteArrayList<RobotPeer>();
    private final boolean isDebugging = System.getProperty("debug", "false").equals("true");
    private double[][] initialRobotPositions;

    public Battle(ISettingsManager properties, IBattleManager battleManager, IHostManager hostManager, ICpuManager cpuManager, BattleEventDispatcher eventDispatcher) {
        super(properties, battleManager, eventDispatcher);
        this.hostManager = hostManager;
        this.cpuConstant = cpuManager.getCpuConstant();
    }

    public void setup(RobotSpecification[] battlingRobotsList, BattleProperties battleProperties, boolean paused) {
        this.isPaused = paused;
        this.battleRules = HiddenAccess.createRules((int)battleProperties.getBattlefieldWidth(), (int)battleProperties.getBattlefieldHeight(), (int)battleProperties.getNumRounds(), (double)battleProperties.getGunCoolingRate(), (long)battleProperties.getInactivityTime());
        this.robotsCount = battlingRobotsList.length;
        this.computeInitialPositions(battleProperties.getInitialPositions());
        this.createPeers(battlingRobotsList);
    }

    private void createPeers(RobotSpecification[] battlingRobotsList) {
        Integer order;
        String name;
        int i;
        Hashtable<String, Integer> countedNames = new Hashtable<String, Integer>();
        ArrayList<String> teams = new ArrayList<String>();
        ArrayList<String> teamDuplicates = new ArrayList<String>();
        ArrayList<Integer> robotDuplicates = new ArrayList<Integer>();
        for (RobotSpecification specification : battlingRobotsList) {
            String name2 = ((IRobotRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)specification)).getUniqueFullClassNameWithVersion();
            if (countedNames.containsKey(name2)) {
                int value = (Integer)countedNames.get(name2);
                countedNames.put(name2, value == 1 ? 3 : value + 1);
            } else {
                countedNames.put(name2, 1);
            }
            String teamFullName = HiddenAccess.getRobotTeamName((RobotSpecification)specification);
            if (teamFullName == null || teams.contains(teamFullName)) continue;
            teams.add(teamFullName);
            String teamName = teamFullName.substring(0, teamFullName.length() - 6);
            if (countedNames.containsKey(teamName)) {
                int value = (Integer)countedNames.get(teamName);
                countedNames.put(teamName, value == 1 ? 3 : value + 1);
                continue;
            }
            countedNames.put(teamName, 1);
        }
        Hashtable teamMembers = new Hashtable();
        for (i = teams.size() - 1; i >= 0; --i) {
            String teamFullName = (String)teams.get(i);
            name = teamFullName.substring(0, teamFullName.length() - 6);
            order = (Integer)countedNames.get(name);
            String newTeamName = name;
            if (order > 1) {
                newTeamName = name + " (" + (order - 1) + ")";
            }
            teamDuplicates.add(0, newTeamName);
            teamMembers.put(teamFullName, new ArrayList());
            countedNames.put(name, order - 1);
        }
        for (i = battlingRobotsList.length - 1; i >= 0; --i) {
            RobotSpecification specification = battlingRobotsList[i];
            name = ((IRobotRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)specification)).getUniqueFullClassNameWithVersion();
            order = (Integer)countedNames.get(name);
            int duplicate = -1;
            String newName = name;
            if (order > 1) {
                duplicate = order - 2;
                newName = name + " (" + (order - 1) + ")";
            }
            countedNames.put(name, order - 1);
            robotDuplicates.add(0, duplicate);
            String teamFullName = HiddenAccess.getRobotTeamName((RobotSpecification)specification);
            if (teamFullName == null) continue;
            List members = (List)teamMembers.get(teamFullName);
            members.add(newName);
        }
        Hashtable<String, TeamPeer> namedTeams = new Hashtable<String, TeamPeer>();
        for (int i2 = 0; i2 < battlingRobotsList.length; ++i2) {
            RobotSpecification specification;
            specification = battlingRobotsList[i2];
            TeamPeer team = null;
            String teamFullName = HiddenAccess.getRobotTeamName((RobotSpecification)specification);
            int cindex = this.contestants.size();
            if (teamFullName != null) {
                if (!namedTeams.containsKey(teamFullName)) {
                    int teamIndex = teams.indexOf(teamFullName);
                    String newTeamName = (String)teamDuplicates.get(teamIndex);
                    team = new TeamPeer(newTeamName, (List)teamMembers.get(teamFullName), this.contestants.size());
                    namedTeams.put(teamFullName, team);
                    this.contestants.add(team);
                } else {
                    team = (TeamPeer)namedTeams.get(teamFullName);
                    if (team != null) {
                        cindex = team.getContestIndex();
                    }
                }
            }
            Integer duplicate = (Integer)robotDuplicates.get(i2);
            RobotPeer robotPeer = new RobotPeer(this, this.hostManager, specification, duplicate, team, this.robots.size(), cindex);
            this.robots.add(robotPeer);
            if (team != null) continue;
            this.contestants.add(robotPeer);
        }
    }

    public void registerDeathRobot(RobotPeer r) {
        this.deathRobots.add(r);
    }

    public BattleRules getBattleRules() {
        return this.battleRules;
    }

    public int getRobotsCount() {
        return this.robotsCount;
    }

    public boolean isDebugging() {
        return this.isDebugging;
    }

    public void removeBullet(BulletPeer bullet) {
        this.bullets.remove(bullet);
    }

    public void addBullet(BulletPeer bullet) {
        this.bullets.add(bullet);
    }

    public void resetInactiveTurnCount(double energyLoss) {
        if (energyLoss < 0.0) {
            return;
        }
        this.inactivityEnergy += energyLoss;
        while (this.inactivityEnergy >= 10.0) {
            this.inactivityEnergy -= 10.0;
            this.inactiveTurnCount = 0;
        }
    }

    public int getActiveRobots() {
        return this.activeRobots;
    }

    @Override
    public void cleanup() {
        if (this.contestants != null) {
            this.contestants.clear();
            this.contestants = null;
        }
        if (this.robots != null) {
            this.robots.clear();
            this.robots = null;
        }
        super.cleanup();
        this.battleManager = null;
        for (int i = 4; i >= 0; --i) {
            System.gc();
        }
    }

    @Override
    protected void initializeBattle() {
        super.initializeBattle();
        this.parallelOn = System.getProperty("PARALLEL", "false").equals("true");
        if (this.parallelOn) {
            double parallelConstant = this.robots.size() / Runtime.getRuntime().availableProcessors();
            if (parallelConstant < 1.0) {
                parallelConstant = 1.0;
            }
            long waitTime = (long)((double)this.cpuConstant * parallelConstant);
            this.millisWait = waitTime / 1000000L;
            this.microWait = (int)(waitTime % 1000000L);
        } else {
            this.millisWait = this.cpuConstant / 1000000L;
            this.microWait = (int)(this.cpuConstant % 1000000L);
        }
        if (this.microWait == 0) {
            this.microWait = 1;
        }
    }

    @Override
    protected void finalizeBattle() {
        this.eventDispatcher.onBattleFinished(new BattleFinishedEvent(this.isAborted()));
        if (!this.isAborted()) {
            this.eventDispatcher.onBattleCompleted(new BattleCompletedEvent(this.battleRules, this.computeBattleResults()));
        }
        for (RobotPeer robotPeer : this.robots) {
            robotPeer.cleanup();
        }
        this.hostManager.resetThreadManager();
        super.finalizeBattle();
    }

    @Override
    protected void preloadRound() {
        super.preloadRound();
        for (RobotPeer robotPeer : this.robots) {
            robotPeer.initializeRound(this.robots, this.initialRobotPositions);
            robotPeer.println("=========================");
            robotPeer.println("Round " + (this.getRoundNum() + 1) + " of " + this.getNumRounds());
            robotPeer.println("=========================");
        }
        if (this.getRoundNum() == 0) {
            this.eventDispatcher.onBattleStarted(new BattleStartedEvent(this.battleRules, this.robots.size(), false));
            if (this.isPaused()) {
                this.eventDispatcher.onBattlePaused(new BattlePausedEvent());
            }
        }
        this.computeActiveRobots();
        this.hostManager.resetThreadManager();
    }

    @Override
    protected void initializeRound() {
        super.initializeRound();
        this.inactiveTurnCount = 0;
        long waitTime = Math.min(300L * this.cpuConstant, 10000000000L);
        for (RobotPeer robotPeer : this.getRobotsAtRandom()) {
            robotPeer.getRobotStatistics().initialize();
            robotPeer.startRound(waitTime);
        }
        Logger.logMessage((String)"");
        TurnSnapshot snapshot = new TurnSnapshot(this, this.robots, this.bullets, false);
        this.eventDispatcher.onRoundStarted(new RoundStartedEvent((ITurnSnapshot)snapshot, this.getRoundNum()));
    }

    @Override
    protected void finalizeRound() {
        super.finalizeRound();
        for (RobotPeer robotPeer : this.robots) {
            robotPeer.waitForStop();
            robotPeer.getRobotStatistics().generateTotals();
        }
        this.bullets.clear();
        this.eventDispatcher.onRoundEnded(new RoundEndedEvent(this.getRoundNum(), this.currentTime, this.totalTurns));
    }

    @Override
    protected void initializeTurn() {
        super.initializeTurn();
        this.eventDispatcher.onTurnStarted(new TurnStartedEvent());
    }

    @Override
    protected void runTurn() {
        super.runTurn();
        this.loadCommands();
        this.updateBullets();
        this.updateRobots();
        this.handleDeadRobots();
        if (this.isAborted() || this.oneTeamRemaining()) {
            this.shutdownTurn();
        }
        ++this.inactiveTurnCount;
        this.computeActiveRobots();
        this.publishStatuses();
        this.wakeupRobots();
    }

    @Override
    protected void shutdownTurn() {
        if (this.getEndTimer() == 0) {
            if (this.isAborted()) {
                for (RobotPeer robotPeer : this.getRobotsAtRandom()) {
                    if (robotPeer.isDead()) continue;
                    robotPeer.println("SYSTEM: game aborted.");
                }
            } else if (this.oneTeamRemaining()) {
                boolean leaderFirsts = false;
                TeamPeer winningTeam = null;
                robocode.RoundEndedEvent roundEndedEvent = new robocode.RoundEndedEvent(this.getRoundNum(), this.currentTime, this.totalTurns);
                for (RobotPeer robotPeer : this.getRobotsAtRandom()) {
                    robotPeer.addEvent((Event)roundEndedEvent);
                    if (robotPeer.isDead() || robotPeer.isWinner()) continue;
                    robotPeer.getRobotStatistics().scoreLastSurvivor();
                    robotPeer.setWinner(true);
                    robotPeer.println("SYSTEM: " + robotPeer.getName() + " wins the round.");
                    robotPeer.addEvent((Event)new WinEvent());
                    if (robotPeer.getTeamPeer() == null) continue;
                    if (robotPeer.isTeamLeader()) {
                        leaderFirsts = true;
                        continue;
                    }
                    winningTeam = robotPeer.getTeamPeer();
                }
                if (!leaderFirsts && winningTeam != null) {
                    winningTeam.getTeamLeader().getRobotStatistics().scoreFirsts();
                }
            }
        }
        if (this.getEndTimer() == 1 && (this.isAborted() || this.isLastRound())) {
            ArrayList<RobotPeer> orderedRobots = new ArrayList<RobotPeer>(this.robots);
            Collections.sort(orderedRobots);
            Collections.reverse(orderedRobots);
            for (int rank = 0; rank < this.robots.size(); ++rank) {
                RobotPeer robotPeer = (RobotPeer)orderedRobots.get(rank);
                robotPeer.getStatistics().setRank(rank + 1);
                BattleResults resultsForRobot = robotPeer.getStatistics().getFinalResults();
                robotPeer.addEvent((Event)new BattleEndedEvent(this.isAborted(), resultsForRobot));
            }
        }
        if (this.getEndTimer() > 120) {
            for (RobotPeer robotPeer : this.robots) {
                robotPeer.setHalt(true);
            }
        }
        super.shutdownTurn();
    }

    @Override
    protected void finalizeTurn() {
        this.eventDispatcher.onTurnEnded(new TurnEndedEvent((ITurnSnapshot)new TurnSnapshot(this, this.robots, this.bullets, true)));
        super.finalizeTurn();
    }

    private BattleResults[] computeBattleResults() {
        ArrayList<RobotResults> results = new ArrayList<RobotResults>();
        ArrayList<ContestantPeer> orderedContestants = new ArrayList<ContestantPeer>(this.contestants);
        Collections.sort(orderedContestants);
        Collections.reverse(orderedContestants);
        for (int i = 0; i < this.contestants.size(); ++i) {
            results.add(null);
        }
        for (int rank = 0; rank < this.contestants.size(); ++rank) {
            RobotSpecification robotSpec = null;
            ContestantPeer contestant = (ContestantPeer)orderedContestants.get(rank);
            contestant.getStatistics().setRank(rank + 1);
            BattleResults battleResults = contestant.getStatistics().getFinalResults();
            if (contestant instanceof RobotPeer) {
                robotSpec = ((RobotPeer)contestant).getRobotSpecification();
            } else if (contestant instanceof TeamPeer) {
                robotSpec = ((TeamPeer)contestant).getTeamLeader().getRobotSpecification();
            }
            results.set(contestant.getContestIndex(), new RobotResults(robotSpec, battleResults));
        }
        return results.toArray(new BattleResults[results.size()]);
    }

    private List<RobotPeer> getRobotsAtRandom() {
        ArrayList<RobotPeer> shuffledList = new ArrayList<RobotPeer>(this.robots);
        Collections.shuffle(shuffledList, RandomFactory.getRandom());
        return shuffledList;
    }

    private List<BulletPeer> getBulletsAtRandom() {
        ArrayList<BulletPeer> shuffledList = new ArrayList<BulletPeer>(this.bullets);
        Collections.shuffle(shuffledList, RandomFactory.getRandom());
        return shuffledList;
    }

    private List<RobotPeer> getDeathRobotsAtRandom() {
        ArrayList<RobotPeer> shuffledList = new ArrayList<RobotPeer>(this.deathRobots);
        Collections.shuffle(shuffledList, RandomFactory.getRandom());
        return shuffledList;
    }

    private void loadCommands() {
        for (RobotPeer robotPeer : this.robots) {
            robotPeer.performLoadCommands();
        }
    }

    private void updateBullets() {
        for (BulletPeer bullet : this.getBulletsAtRandom()) {
            bullet.update(this.getRobotsAtRandom(), this.getBulletsAtRandom());
            if (bullet.getState() != BulletState.INACTIVE) continue;
            this.bullets.remove(bullet);
        }
    }

    private void updateRobots() {
        boolean zap;
        boolean bl = zap = (long)this.inactiveTurnCount > this.battleRules.getInactivityTime();
        double zapEnergy = this.isAborted() ? 5.0 : (zap ? 0.1 : 0.0);
        for (RobotPeer robotPeer : this.getRobotsAtRandom()) {
            robotPeer.performMove(this.getRobotsAtRandom(), zapEnergy);
        }
        for (RobotPeer robotPeer : this.getRobotsAtRandom()) {
            robotPeer.performScan(this.getRobotsAtRandom());
        }
    }

    private void handleDeadRobots() {
        for (RobotPeer deadRobot : this.getDeathRobotsAtRandom()) {
            if (deadRobot.getTeamPeer() == null) {
                deadRobot.getRobotStatistics().scoreRobotDeath(this.getActiveContestantCount(deadRobot));
            } else {
                boolean teammatesalive = false;
                for (RobotPeer tm : this.robots) {
                    if (tm.getTeamPeer() != deadRobot.getTeamPeer() || tm.isDead()) continue;
                    teammatesalive = true;
                    break;
                }
                if (!teammatesalive) {
                    deadRobot.getRobotStatistics().scoreRobotDeath(this.getActiveContestantCount(deadRobot));
                }
            }
            for (RobotPeer robotPeer : this.getRobotsAtRandom()) {
                if (robotPeer.isDead()) continue;
                robotPeer.addEvent((Event)new RobotDeathEvent(deadRobot.getName()));
                if (robotPeer.getTeamPeer() != null && robotPeer.getTeamPeer() == deadRobot.getTeamPeer()) continue;
                robotPeer.getRobotStatistics().scoreSurvival();
            }
        }
        this.deathRobots.clear();
    }

    private void publishStatuses() {
        for (RobotPeer robotPeer : this.robots) {
            robotPeer.publishStatus(this.currentTime);
        }
    }

    private void computeActiveRobots() {
        int ar = 0;
        for (RobotPeer robotPeer : this.robots) {
            if (robotPeer.isDead()) continue;
            ++ar;
        }
        this.activeRobots = ar;
    }

    private void wakeupRobots() {
        List<RobotPeer> robotsAtRandom = this.getRobotsAtRandom();
        if (this.parallelOn) {
            this.wakeupParallel(robotsAtRandom);
        } else {
            this.wakeupSerial(robotsAtRandom);
        }
    }

    private void wakeupSerial(List<RobotPeer> robotsAtRandom) {
        for (RobotPeer robotPeer : robotsAtRandom) {
            if (!robotPeer.isRunning()) continue;
            robotPeer.waitWakeup();
            if (!robotPeer.isAlive()) continue;
            if (this.isDebugging || robotPeer.isPaintEnabled() || robotPeer.isPaintRecorded()) {
                robotPeer.waitSleeping(600000L, 1);
            } else if (this.currentTime == 1) {
                robotPeer.waitSleeping(this.millisWait * 10L, 1);
            } else {
                robotPeer.waitSleeping(this.millisWait, this.microWait);
            }
            robotPeer.setSkippedTurns();
        }
    }

    private void wakeupParallel(List<RobotPeer> robotsAtRandom) {
        for (RobotPeer robotPeer : robotsAtRandom) {
            if (!robotPeer.isRunning()) continue;
            robotPeer.waitWakeup();
        }
        for (RobotPeer robotPeer : robotsAtRandom) {
            if (!robotPeer.isRunning() || !robotPeer.isAlive()) continue;
            if (this.isDebugging || robotPeer.isPaintEnabled() || robotPeer.isPaintRecorded()) {
                robotPeer.waitSleeping(600000L, 1);
                continue;
            }
            robotPeer.waitSleeping(this.millisWait, this.microWait);
        }
        for (RobotPeer robotPeer : robotsAtRandom) {
            if (!robotPeer.isAlive()) continue;
            robotPeer.setSkippedTurns();
        }
    }

    private int getActiveContestantCount(RobotPeer peer) {
        int count = 0;
        block0: for (ContestantPeer c : this.contestants) {
            if (c instanceof RobotPeer && !((RobotPeer)c).isDead()) {
                ++count;
                continue;
            }
            if (!(c instanceof TeamPeer) || c == peer.getTeamPeer()) continue;
            for (RobotPeer robotPeer : (TeamPeer)c) {
                if (robotPeer.isDead()) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    private void computeInitialPositions(String initialPositions) {
        this.initialRobotPositions = null;
        if (initialPositions == null || initialPositions.trim().length() == 0) {
            return;
        }
        ArrayList<String> positions = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([^,(]*[(][^)]*[)])?[^,]*,?");
        Matcher matcher = pattern.matcher(initialPositions);
        while (matcher.find()) {
            String pos = matcher.group();
            if (pos.length() <= 0) continue;
            positions.add(pos);
        }
        if (positions.size() == 0) {
            return;
        }
        this.initialRobotPositions = new double[positions.size()][3];
        for (int i = 0; i < positions.size(); ++i) {
            String[] coords = ((String)positions.get(i)).split(",");
            Random random = RandomFactory.getRandom();
            double x = 40.0 + random.nextDouble() * (double)(this.battleRules.getBattlefieldWidth() - 80);
            double y = 40.0 + random.nextDouble() * (double)(this.battleRules.getBattlefieldHeight() - 80);
            double heading = Math.PI * 2 * random.nextDouble();
            int len = coords.length;
            if (len >= 1) {
                try {
                    x = Double.parseDouble(coords[0].replaceAll("[\\D]", ""));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (len >= 2) {
                    try {
                        y = Double.parseDouble(coords[1].replaceAll("[\\D]", ""));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (len >= 3) {
                        try {
                            heading = Math.toRadians(Double.parseDouble(coords[2].replaceAll("[\\D]", "")));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
            }
            this.initialRobotPositions[i][0] = x;
            this.initialRobotPositions[i][1] = y;
            this.initialRobotPositions[i][2] = heading;
        }
    }

    private boolean oneTeamRemaining() {
        if (this.getActiveRobots() <= 1) {
            return true;
        }
        boolean found = false;
        TeamPeer currentTeam = null;
        for (RobotPeer currentRobot : this.robots) {
            if (currentRobot.isDead()) continue;
            if (!found) {
                found = true;
                currentTeam = currentRobot.getTeamPeer();
                continue;
            }
            if (currentTeam == null && currentRobot.getTeamPeer() == null) {
                return false;
            }
            if (currentTeam == currentRobot.getTeamPeer()) continue;
            return false;
        }
        return true;
    }

    public void killRobot(int robotIndex) {
        this.sendCommand(new KillRobotCommand(robotIndex));
    }

    @Override
    public void setPaintEnabled(int robotIndex, boolean enable) {
        this.sendCommand(new EnableRobotPaintCommand(robotIndex, enable));
    }

    public void setAllPaintRecorded(boolean enable) {
        this.sendCommand(new AllRobotsPaintRecordCommand(enable));
    }

    public void setSGPaintEnabled(int robotIndex, boolean enable) {
        this.sendCommand(new EnableRobotSGPaintCommand(robotIndex, enable));
    }

    public void sendInteractiveEvent(Event e) {
        this.sendCommand(new SendInteractiveEventCommand(e));
    }

    private class SendInteractiveEventCommand
    extends Command {
        public final Event event;

        SendInteractiveEventCommand(Event event) {
            this.event = event;
        }

        public void execute() {
            for (RobotPeer robotPeer : Battle.this.robots) {
                if (!robotPeer.isInteractiveRobot()) continue;
                robotPeer.addEvent(this.event);
            }
        }
    }

    private class EnableRobotSGPaintCommand
    extends BaseBattle.RobotCommand {
        final boolean enableSGPaint;

        EnableRobotSGPaintCommand(int robotIndex, boolean enableSGPaint) {
            super(robotIndex);
            this.enableSGPaint = enableSGPaint;
        }

        public void execute() {
            ((RobotPeer)Battle.this.robots.get(this.robotIndex)).setSGPaintEnabled(this.enableSGPaint);
        }
    }

    private class EnableRobotPaintCommand
    extends BaseBattle.RobotCommand {
        final boolean enablePaint;

        EnableRobotPaintCommand(int robotIndex, boolean enablePaint) {
            super(robotIndex);
            this.enablePaint = enablePaint;
        }

        public void execute() {
            ((RobotPeer)Battle.this.robots.get(this.robotIndex)).setPaintEnabled(this.enablePaint);
        }
    }

    private class AllRobotsPaintRecordCommand
    extends Command {
        final boolean enablePaintRecord;

        AllRobotsPaintRecordCommand(boolean enablePaintRecord) {
            this.enablePaintRecord = enablePaintRecord;
        }

        public void execute() {
            for (RobotPeer robot : Battle.this.robots) {
                robot.setPaintRecorded(this.enablePaintRecord);
            }
        }
    }

    private class KillRobotCommand
    extends BaseBattle.RobotCommand {
        KillRobotCommand(int robotIndex) {
            super(robotIndex);
        }

        public void execute() {
            ((RobotPeer)Battle.this.robots.get(this.robotIndex)).kill();
        }
    }
}

