/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.peer;

import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.robocode.battle.Battle;
import net.sf.robocode.battle.BoundingRectangle;
import net.sf.robocode.battle.peer.BulletPeer;
import net.sf.robocode.battle.peer.ContestantPeer;
import net.sf.robocode.battle.peer.ContestantStatistics;
import net.sf.robocode.battle.peer.ExplosionPeer;
import net.sf.robocode.battle.peer.IRobotPeerBattle;
import net.sf.robocode.battle.peer.RobotStatistics;
import net.sf.robocode.battle.peer.TeamPeer;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.events.EventQueue;
import net.sf.robocode.host.proxies.IHostingRobotProxy;
import net.sf.robocode.io.Logger;
import net.sf.robocode.peer.BadBehavior;
import net.sf.robocode.peer.BulletCommand;
import net.sf.robocode.peer.BulletStatus;
import net.sf.robocode.peer.DebugProperty;
import net.sf.robocode.peer.ExecCommands;
import net.sf.robocode.peer.ExecResults;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.peer.TeamMessage;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.serialization.RbSerializer;
import robocode.BattleRules;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotStatus;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.control.RandomFactory;
import robocode.control.RobotSpecification;
import robocode.control.snapshot.BulletState;
import robocode.control.snapshot.RobotState;
import robocode.exception.AbortedException;
import robocode.exception.DeathException;
import robocode.exception.WinException;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RobotPeer
implements IRobotPeerBattle,
IRobotPeer {
    public static final int WIDTH = 40;
    public static final int HEIGHT = 40;
    private static final int HALF_WIDTH_OFFSET = 18;
    private static final int HALF_HEIGHT_OFFSET = 18;
    private static final int MAX_SKIPPED_TURNS = 30;
    private static final int MAX_SKIPPED_TURNS_WITH_IO = 240;
    private Battle battle;
    private RobotStatistics statistics;
    private final TeamPeer teamPeer;
    private final RobotSpecification robotSpecification;
    private IHostingRobotProxy robotProxy;
    private AtomicReference<RobotStatus> status = new AtomicReference();
    private AtomicReference<ExecCommands> commands = new AtomicReference();
    private AtomicReference<EventQueue> events = new AtomicReference<EventQueue>(new EventQueue());
    private AtomicReference<List<TeamMessage>> teamMessages = new AtomicReference(new ArrayList());
    private AtomicReference<List<BulletStatus>> bulletUpdates = new AtomicReference(new ArrayList());
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final StringBuilder battleText = new StringBuilder(1024);
    private final StringBuilder proxyText = new StringBuilder(1024);
    private RobotStatics statics;
    private BattleRules battleRules;
    private ExecCommands currentCommands;
    private double lastHeading;
    private double lastGunHeading;
    private double lastRadarHeading;
    private double energy;
    private double velocity;
    private double bodyHeading;
    private double radarHeading;
    private double gunHeading;
    private double gunHeat;
    private double x;
    private double y;
    private int skippedTurns;
    private boolean scan;
    private boolean turnedRadarWithGun;
    private boolean isIORobot;
    private boolean isPaintRecorded;
    private boolean isPaintEnabled;
    private boolean sgPaintEnabled;
    private final AtomicBoolean isSleeping = new AtomicBoolean(false);
    private final AtomicBoolean halt = new AtomicBoolean(false);
    private boolean isExecFinishedAndDisabled;
    private boolean isEnergyDrained;
    private boolean isWinner;
    private boolean inCollision;
    private boolean isOverDriving;
    private RobotState state;
    private final Arc2D scanArc;
    private final BoundingRectangle boundingBox;
    private final RbSerializer rbSerializer;
    ByteBuffer bidirectionalBuffer;

    public RobotPeer(Battle battle, IHostManager hostManager, RobotSpecification robotSpecification, int duplicate, TeamPeer team, int index, int contestantIndex) {
        if (team != null) {
            team.add(this);
        }
        this.rbSerializer = new RbSerializer();
        this.battle = battle;
        this.boundingBox = new BoundingRectangle();
        this.scanArc = new Arc2D.Double();
        this.teamPeer = team;
        this.state = RobotState.ACTIVE;
        this.battleRules = battle.getBattleRules();
        this.robotSpecification = robotSpecification;
        boolean isLeader = this.teamPeer != null && this.teamPeer.size() == 1;
        String teamName = team == null ? null : team.getName();
        List<String> teamMembers = team == null ? null : team.getMemberNames();
        this.statics = new RobotStatics(robotSpecification, duplicate, isLeader, this.battleRules, teamName, teamMembers, index, contestantIndex);
        this.statistics = new RobotStatistics(this, battle.getRobotsCount());
        this.robotProxy = (IHostingRobotProxy)hostManager.createRobotProxy(robotSpecification, this.statics, (IRobotPeer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String s) {
        StringBuilder stringBuilder = this.proxyText;
        synchronized (stringBuilder) {
            this.battleText.append(s);
            this.battleText.append("\n");
        }
    }

    public void print(Throwable ex) {
        StackTraceElement[] trace;
        this.println(ex.toString());
        for (StackTraceElement aTrace : trace = ex.getStackTrace()) {
            this.println("\tat " + aTrace);
        }
        Throwable ourCause = ex.getCause();
        if (ourCause != null) {
            this.print(ourCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProxy(String s) {
        StringBuilder stringBuilder = this.proxyText;
        synchronized (stringBuilder) {
            this.proxyText.append(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readOutText() {
        StringBuilder stringBuilder = this.proxyText;
        synchronized (stringBuilder) {
            String robotText = this.battleText.toString() + this.proxyText.toString();
            this.battleText.setLength(0);
            this.proxyText.setLength(0);
            return robotText;
        }
    }

    @Override
    public RobotStatistics getRobotStatistics() {
        return this.statistics;
    }

    @Override
    public ContestantStatistics getStatistics() {
        return this.statistics;
    }

    public RobotSpecification getRobotSpecification() {
        return this.robotSpecification;
    }

    public boolean isDroid() {
        return this.statics.isDroid();
    }

    public boolean isJuniorRobot() {
        return this.statics.isJuniorRobot();
    }

    public boolean isInteractiveRobot() {
        return this.statics.isInteractiveRobot();
    }

    public boolean isPaintRobot() {
        return this.statics.isPaintRobot();
    }

    public boolean isAdvancedRobot() {
        return this.statics.isAdvancedRobot();
    }

    public boolean isTeamRobot() {
        return this.statics.isTeamRobot();
    }

    @Override
    public String getName() {
        return this.statics.getName();
    }

    public String getShortName() {
        return this.statics.getShortName();
    }

    public String getVeryShortName() {
        return this.statics.getVeryShortName();
    }

    public int getIndex() {
        return this.statics.getIndex();
    }

    @Override
    public int getContestIndex() {
        return this.statics.getContestIndex();
    }

    @Override
    public void setPaintEnabled(boolean enabled) {
        this.isPaintEnabled = enabled;
    }

    public void setPaintRecorded(boolean enabled) {
        this.isPaintRecorded = enabled;
    }

    public boolean isPaintRecorded() {
        return this.isPaintRecorded;
    }

    public boolean isPaintEnabled() {
        return this.isPaintEnabled;
    }

    @Override
    public void setSGPaintEnabled(boolean enabled) {
        this.sgPaintEnabled = enabled;
    }

    public boolean isSGPaintEnabled() {
        return this.sgPaintEnabled;
    }

    public RobotState getState() {
        return this.state;
    }

    public void setState(RobotState state) {
        this.state = state;
    }

    @Override
    public boolean isDead() {
        return this.state == RobotState.DEAD;
    }

    @Override
    public boolean isAlive() {
        return this.state != RobotState.DEAD;
    }

    @Override
    public boolean isWinner() {
        return this.isWinner;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public boolean isSleeping() {
        return this.isSleeping.get();
    }

    public boolean getHalt() {
        return this.halt.get();
    }

    @Override
    public void setHalt(boolean value) {
        this.halt.set(value);
    }

    public BoundingRectangle getBoundingBox() {
        return this.boundingBox;
    }

    public Arc2D getScanArc() {
        return this.scanArc;
    }

    public double getGunHeading() {
        return this.gunHeading;
    }

    public double getBodyHeading() {
        return this.bodyHeading;
    }

    public double getRadarHeading() {
        return this.radarHeading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getGunHeat() {
        return this.gunHeat;
    }

    public int getBodyColor() {
        return this.commands.get().getBodyColor();
    }

    public int getRadarColor() {
        return this.commands.get().getRadarColor();
    }

    public int getGunColor() {
        return this.commands.get().getGunColor();
    }

    public int getBulletColor() {
        return this.commands.get().getBulletColor();
    }

    public int getScanColor() {
        return this.commands.get().getScanColor();
    }

    @Override
    public TeamPeer getTeamPeer() {
        return this.teamPeer;
    }

    public String getTeamName() {
        return this.statics.getTeamName();
    }

    @Override
    public boolean isTeamLeader() {
        return this.statics.isTeamLeader();
    }

    public void setupBuffer(ByteBuffer bidirectionalBuffer) {
        this.bidirectionalBuffer = bidirectionalBuffer;
    }

    public void setupThread() {
        Thread.currentThread().setName(this.getName());
    }

    public void executeImplSerial() throws IOException {
        ExecCommands commands = (ExecCommands)this.rbSerializer.deserialize(this.bidirectionalBuffer);
        ExecResults results = this.executeImpl(commands);
        this.bidirectionalBuffer.clear();
        this.rbSerializer.serializeToBuffer(this.bidirectionalBuffer, (byte)5, (Object)results);
    }

    public void waitForBattleEndImplSerial() throws IOException {
        ExecCommands commands = (ExecCommands)this.rbSerializer.deserialize(this.bidirectionalBuffer);
        ExecResults results = this.waitForBattleEndImpl(commands);
        this.bidirectionalBuffer.clear();
        this.rbSerializer.serializeToBuffer(this.bidirectionalBuffer, (byte)5, (Object)results);
    }

    public final ExecResults executeImpl(ExecCommands newCommands) {
        this.validateCommands(newCommands);
        if (!this.isExecFinishedAndDisabled) {
            this.commands.set(new ExecCommands(newCommands, true));
            this.printProxy(newCommands.getOutputText());
        } else {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.battle.isAborted()) {
            this.isExecFinishedAndDisabled = true;
            throw new AbortedException();
        }
        if (this.isDead()) {
            this.isExecFinishedAndDisabled = true;
            throw new DeathException();
        }
        if (this.getHalt()) {
            this.isExecFinishedAndDisabled = true;
            if (this.isWinner) {
                throw new WinException();
            }
            throw new AbortedException();
        }
        this.waitForNextRound();
        ExecCommands resCommands = new ExecCommands(this.commands.get(), false);
        RobotStatus resStatus = this.status.get();
        boolean shouldWait = this.battle.isAborted() || this.battle.isLastRound() && this.isWinner();
        return new ExecResults(resCommands, resStatus, this.readoutEvents(), this.readoutTeamMessages(), this.readoutBullets(), this.getHalt(), shouldWait, this.isPaintEnabled() || this.isPaintRecorded);
    }

    public final ExecResults waitForBattleEndImpl(ExecCommands newCommands) {
        if (!this.getHalt()) {
            this.commands.set(new ExecCommands(newCommands, true));
            this.printProxy(newCommands.getOutputText());
            this.waitForNextRound();
        }
        ExecCommands resCommands = new ExecCommands(this.commands.get(), false);
        RobotStatus resStatus = this.status.get();
        boolean shouldWait = this.battle.isAborted() || this.battle.isLastRound() && !this.isWinner();
        this.readoutTeamMessages();
        return new ExecResults(resCommands, resStatus, this.readoutEvents(), new ArrayList(), this.readoutBullets(), this.getHalt(), shouldWait, false);
    }

    private void validateCommands(ExecCommands newCommands) {
        if (Double.isNaN(newCommands.getMaxTurnRate())) {
            this.println("You cannot setMaxTurnRate to: " + newCommands.getMaxTurnRate());
        }
        newCommands.setMaxTurnRate(Math.min(Math.abs(newCommands.getMaxTurnRate()), Rules.MAX_TURN_RATE_RADIANS));
        if (Double.isNaN(newCommands.getMaxVelocity())) {
            this.println("You cannot setMaxVelocity to: " + newCommands.getMaxVelocity());
        }
        newCommands.setMaxVelocity(Math.min(Math.abs(newCommands.getMaxVelocity()), 8.0));
    }

    private List<Event> readoutEvents() {
        return (List)this.events.getAndSet(new EventQueue());
    }

    private List<TeamMessage> readoutTeamMessages() {
        return this.teamMessages.getAndSet(new ArrayList());
    }

    private List<BulletStatus> readoutBullets() {
        return this.bulletUpdates.getAndSet(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextRound() {
        AtomicBoolean atomicBoolean = this.isSleeping;
        synchronized (atomicBoolean) {
            this.isSleeping.set(true);
            this.isSleeping.notifyAll();
            try {
                this.isSleeping.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.isSleeping.set(false);
            this.isSleeping.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitWakeup() {
        AtomicBoolean atomicBoolean = this.isSleeping;
        synchronized (atomicBoolean) {
            if (this.isSleeping()) {
                this.isSleeping.notifyAll();
                try {
                    this.isSleeping.wait(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWakeupNoWait() {
        AtomicBoolean atomicBoolean = this.isSleeping;
        synchronized (atomicBoolean) {
            if (this.isSleeping()) {
                this.isSleeping.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSleeping(long millisWait, int microWait) {
        AtomicBoolean atomicBoolean = this.isSleeping;
        synchronized (atomicBoolean) {
            if (!this.isSleeping()) {
                try {
                    for (long i = millisWait; i > 0L && !this.isSleeping() && this.isRunning(); --i) {
                        this.isSleeping.wait(0L, 999999);
                    }
                    if (!this.isSleeping()) {
                        this.isSleeping.wait(0L, microWait);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Logger.logMessage((String)("Wait for " + this.getName() + " interrupted."));
                }
            }
        }
    }

    @Override
    public void setSkippedTurns() {
        if (this.isSleeping() || !this.isRunning() || this.battle.isDebugging() || this.isPaintEnabled()) {
            this.skippedTurns = 0;
        } else {
            this.println("SYSTEM: " + this.getShortName() + " skipped turn " + this.battle.getTime());
            ++this.skippedTurns;
            this.events.get().clear(false);
            if (!this.isDead()) {
                this.addEvent((Event)new SkippedTurnEvent((long)this.battle.getTime()));
            }
            if (!this.isIORobot && this.skippedTurns > 30 || this.isIORobot && this.skippedTurns > 240) {
                this.println("SYSTEM: " + this.getShortName() + " has not performed any actions in a reasonable amount of time.");
                this.println("SYSTEM: No score will be generated.");
                this.setHalt(true);
                this.waitWakeupNoWait();
                this.punishBadBehavior(BadBehavior.SKIPPED_TOO_MANY_TURNS);
                this.robotProxy.forceStopThread();
            }
        }
    }

    @Override
    public void initializeRound(List<RobotPeer> robots, double[][] initialRobotPositions) {
        boolean valid = false;
        if (initialRobotPositions != null && this.statics.getIndex() >= 0 && this.statics.getIndex() < initialRobotPositions.length) {
            double[] pos = initialRobotPositions[this.statics.getIndex()];
            this.x = pos[0];
            this.y = pos[1];
            this.gunHeading = this.radarHeading = (this.bodyHeading = pos[2]);
            this.updateBoundingBox();
            valid = this.validSpot(robots);
        }
        if (!valid) {
            Random random = RandomFactory.getRandom();
            for (int j = 0; j < 1000; ++j) {
                this.x = 40.0 + random.nextDouble() * (double)(this.battleRules.getBattlefieldWidth() - 80);
                this.y = 40.0 + random.nextDouble() * (double)(this.battleRules.getBattlefieldHeight() - 80);
                this.gunHeading = this.radarHeading = (this.bodyHeading = Math.PI * 2 * random.nextDouble());
                this.updateBoundingBox();
                if (this.validSpot(robots)) break;
            }
        }
        this.setState(RobotState.ACTIVE);
        this.isWinner = false;
        this.velocity = 0.0;
        this.energy = this.statics.isTeamLeader() && this.statics.isDroid() ? 220.0 : (this.statics.isTeamLeader() ? 200.0 : (this.statics.isDroid() ? 120.0 : 100.0));
        this.gunHeat = 3.0;
        this.setHalt(false);
        this.isExecFinishedAndDisabled = false;
        this.isEnergyDrained = false;
        this.scan = false;
        this.inCollision = false;
        this.scanArc.setAngleStart(0.0);
        this.scanArc.setAngleExtent(0.0);
        this.scanArc.setFrame(-100.0, -100.0, 1.0, 1.0);
        this.skippedTurns = 0;
        this.status = new AtomicReference();
        this.readoutEvents();
        this.readoutTeamMessages();
        this.readoutBullets();
        this.battleText.setLength(0);
        this.proxyText.setLength(0);
        ExecCommands newExecCommands = new ExecCommands();
        newExecCommands.copyColors(this.commands.get());
        this.commands = new AtomicReference<ExecCommands>(newExecCommands);
    }

    private boolean validSpot(List<RobotPeer> robots) {
        for (RobotPeer otherRobot : robots) {
            if (otherRobot == null || otherRobot == this || !this.getBoundingBox().intersects(otherRobot.getBoundingBox())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRound(long waitTime) {
        AtomicBoolean atomicBoolean = this.isSleeping;
        synchronized (atomicBoolean) {
            try {
                Logger.logMessage((String)".", (boolean)false);
                ExecCommands newExecCommands = new ExecCommands();
                newExecCommands.copyColors(this.commands.get());
                this.currentCommands = newExecCommands;
                int others = this.battle.getActiveRobots() - (this.isAlive() ? 1 : 0);
                RobotStatus stat = HiddenAccess.createStatus((double)this.energy, (double)this.x, (double)this.y, (double)this.bodyHeading, (double)this.gunHeading, (double)this.radarHeading, (double)this.velocity, (double)this.currentCommands.getBodyTurnRemaining(), (double)this.currentCommands.getRadarTurnRemaining(), (double)this.currentCommands.getGunTurnRemaining(), (double)this.currentCommands.getDistanceRemaining(), (double)this.gunHeat, (int)others, (int)this.battle.getRoundNum(), (int)this.battle.getNumRounds(), (long)this.battle.getTime());
                this.status.set(stat);
                this.robotProxy.startRound(this.currentCommands, stat);
                if (!this.battle.isDebugging()) {
                    this.isSleeping.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                }
            }
            catch (InterruptedException e) {
                Logger.logMessage((String)("Wait for " + this.getName() + " interrupted."));
                Thread.currentThread().interrupt();
            }
        }
        if (!this.isSleeping() && !this.battle.isDebugging()) {
            Logger.logMessage((String)("\n" + this.getName() + " still has not started after " + waitTime / 100000L + " ms... giving up."));
        }
    }

    @Override
    public void performLoadCommands() {
        this.currentCommands = this.commands.get();
        this.fireBullets(this.currentCommands.getBullets());
        if (this.currentCommands.isScan()) {
            this.scan = true;
        }
        if (this.currentCommands.isIORobot()) {
            this.isIORobot = true;
        }
        if (this.currentCommands.isMoved()) {
            this.currentCommands.setMoved(false);
        }
    }

    private void fireBullets(List<BulletCommand> bulletCommands) {
        BulletPeer newBullet = null;
        for (BulletCommand bulletCmd : bulletCommands) {
            if (Double.isNaN(bulletCmd.getPower())) {
                this.println("SYSTEM: You cannot call fire(NaN)");
                continue;
            }
            if (this.gunHeat > 0.0 || this.energy == 0.0) {
                return;
            }
            double firePower = Math.min(this.energy, Math.min(Math.max(bulletCmd.getPower(), 0.1), 3.0));
            this.updateEnergy(-firePower);
            this.gunHeat += Rules.getGunHeat((double)firePower);
            newBullet = new BulletPeer(this, this.battleRules, bulletCmd.getBulletId());
            newBullet.setPower(firePower);
            if (!this.turnedRadarWithGun || !bulletCmd.isFireAssistValid() || this.statics.isAdvancedRobot()) {
                newBullet.setHeading(this.gunHeading);
            } else {
                newBullet.setHeading(bulletCmd.getFireAssistAngle());
            }
            newBullet.setX(this.x);
            newBullet.setY(this.y);
        }
        if (newBullet != null) {
            this.battle.addBullet(newBullet);
        }
    }

    @Override
    public final void performMove(List<RobotPeer> robots, double zapEnergy) {
        if (this.isDead()) {
            return;
        }
        this.setState(RobotState.ACTIVE);
        this.updateGunHeat();
        this.lastHeading = this.bodyHeading;
        this.lastGunHeading = this.gunHeading;
        this.lastRadarHeading = this.radarHeading;
        double lastX = this.x;
        double lastY = this.y;
        if (!this.inCollision) {
            this.updateHeading();
        }
        this.updateGunHeading();
        this.updateRadarHeading();
        this.updateMovement();
        this.checkWallCollision();
        this.checkRobotCollision(robots);
        if (!this.scan) {
            boolean bl = this.scan = this.lastHeading != this.bodyHeading || this.lastGunHeading != this.gunHeading || this.lastRadarHeading != this.radarHeading || lastX != this.x || lastY != this.y;
        }
        if (this.isDead()) {
            return;
        }
        if (zapEnergy != 0.0) {
            this.zap(zapEnergy);
        }
    }

    @Override
    public void performScan(List<RobotPeer> robots) {
        if (this.isDead()) {
            return;
        }
        this.turnedRadarWithGun = false;
        if (this.scan) {
            this.scan(this.lastRadarHeading, robots);
            this.turnedRadarWithGun = this.lastGunHeading == this.lastRadarHeading && this.gunHeading == this.radarHeading;
            this.scan = false;
        }
        if (this.statics.isTeamRobot() && this.teamPeer != null) {
            for (TeamMessage teamMessage : this.currentCommands.getTeamMessages()) {
                for (RobotPeer member : this.teamPeer) {
                    if (!this.checkDispatchToMember(member, teamMessage.recipient)) continue;
                    member.addTeamMessage(teamMessage);
                }
            }
        }
        this.currentCommands = null;
        this.lastHeading = -1.0;
        this.lastGunHeading = -1.0;
        this.lastRadarHeading = -1.0;
    }

    private void addTeamMessage(TeamMessage message) {
        List<TeamMessage> queue = this.teamMessages.get();
        queue.add(message);
    }

    private boolean checkDispatchToMember(RobotPeer member, String recipient) {
        if (member.isAlive()) {
            if (recipient == null) {
                if (member != this) {
                    return true;
                }
            } else {
                int nl = recipient.length();
                String currentName = member.statics.getName();
                if (currentName.length() >= nl && currentName.substring(0, nl).equals(recipient)) {
                    return true;
                }
                String currentClassName = member.statics.getFullClassName();
                if (currentClassName.length() >= nl && currentClassName.substring(0, nl).equals(recipient)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void checkRobotCollision(List<RobotPeer> robots) {
        this.inCollision = false;
        for (RobotPeer otherRobot : robots) {
            boolean teamFire;
            if (otherRobot == null || otherRobot == this || otherRobot.isDead() || !this.boundingBox.intersects(otherRobot.boundingBox)) continue;
            double angle = Math.atan2(otherRobot.x - this.x, otherRobot.y - this.y);
            double movedx = this.velocity * Math.sin(this.bodyHeading);
            double movedy = this.velocity * Math.cos(this.bodyHeading);
            double bearing = Utils.normalRelativeAngle((double)(angle - this.bodyHeading));
            if (!(this.velocity > 0.0 && bearing > -1.5707963267948966 && bearing < 1.5707963267948966) && (!(this.velocity < 0.0) || !(bearing < -1.5707963267948966) && !(bearing > 1.5707963267948966))) continue;
            this.inCollision = true;
            boolean atFault = true;
            this.velocity = 0.0;
            this.currentCommands.setDistanceRemaining(0.0);
            this.x -= movedx;
            this.y -= movedy;
            boolean bl = teamFire = this.teamPeer != null && this.teamPeer == otherRobot.teamPeer;
            if (!teamFire) {
                this.statistics.scoreRammingDamage(otherRobot.getName());
            }
            this.updateEnergy(-0.6);
            otherRobot.updateEnergy(-0.6);
            if (otherRobot.energy == 0.0 && otherRobot.isAlive()) {
                double bonus;
                otherRobot.kill();
                if (!teamFire && (bonus = this.statistics.scoreRammingKill(otherRobot.getName())) > 0.0) {
                    this.println("SYSTEM: Ram bonus for killing " + otherRobot.getName() + ": " + (int)(bonus + 0.5));
                }
            }
            this.addEvent((Event)new HitRobotEvent(otherRobot.getName(), Utils.normalRelativeAngle((double)(angle - this.bodyHeading)), otherRobot.energy, atFault));
            otherRobot.addEvent((Event)new HitRobotEvent(this.getName(), Utils.normalRelativeAngle((double)(Math.PI + angle - otherRobot.getBodyHeading())), this.energy, false));
        }
        if (this.inCollision) {
            this.setState(RobotState.HIT_ROBOT);
        }
    }

    private void checkWallCollision() {
        boolean hitWall = false;
        double fixx = 0.0;
        double fixy = 0.0;
        double angle = 0.0;
        if (this.x > this.getBattleFieldWidth() - 18.0) {
            hitWall = true;
            fixx = this.getBattleFieldWidth() - 18.0 - this.x;
            angle = Utils.normalRelativeAngle((double)(1.5707963267948966 - this.bodyHeading));
        }
        if (this.x < 18.0) {
            hitWall = true;
            fixx = 18.0 - this.x;
            angle = Utils.normalRelativeAngle((double)(4.71238898038469 - this.bodyHeading));
        }
        if (this.y > this.getBattleFieldHeight() - 18.0) {
            hitWall = true;
            fixy = this.getBattleFieldHeight() - 18.0 - this.y;
            angle = Utils.normalRelativeAngle((double)(-this.bodyHeading));
        }
        if (this.y < 18.0) {
            hitWall = true;
            fixy = 18.0 - this.y;
            angle = Utils.normalRelativeAngle((double)(Math.PI - this.bodyHeading));
        }
        if (hitWall) {
            this.addEvent((Event)new HitWallEvent(angle));
            if (this.bodyHeading % 1.5707963267948966 != 0.0) {
                double tanHeading = Math.tan(this.bodyHeading);
                if (fixx == 0.0) {
                    fixx = fixy * tanHeading;
                } else if (fixy == 0.0) {
                    fixy = fixx / tanHeading;
                } else if (Math.abs(fixx / tanHeading) > Math.abs(fixy)) {
                    fixy = fixx / tanHeading;
                } else if (Math.abs(fixy * tanHeading) > Math.abs(fixx)) {
                    fixx = fixy * tanHeading;
                }
            }
            this.x += fixx;
            this.y += fixy;
            double d = 18.0 >= this.x ? 18.0 : (this.x = this.getBattleFieldWidth() - 18.0 < this.x ? this.getBattleFieldWidth() - 18.0 : this.x);
            double d2 = 18.0 >= this.y ? 18.0 : (this.y = this.getBattleFieldHeight() - 18.0 < this.y ? this.getBattleFieldHeight() - 18.0 : this.y);
            if (this.statics.isAdvancedRobot()) {
                this.setEnergy(this.energy - Rules.getWallHitDamage((double)this.velocity), false);
            }
            this.updateBoundingBox();
            this.currentCommands.setDistanceRemaining(0.0);
            this.velocity = 0.0;
        }
        if (hitWall) {
            this.setState(RobotState.HIT_WALL);
        }
    }

    private double getBattleFieldHeight() {
        return this.battleRules.getBattlefieldHeight();
    }

    private double getBattleFieldWidth() {
        return this.battleRules.getBattlefieldWidth();
    }

    public void updateBoundingBox() {
        this.boundingBox.setRect(this.x - 20.0 + 2.0, this.y - 20.0 + 2.0, 36.0, 36.0);
    }

    @Override
    public void addEvent(Event event) {
        if (this.isRunning()) {
            EventQueue queue = this.events.get();
            if (!(queue.size() <= 256 || event instanceof DeathEvent || event instanceof WinEvent || event instanceof SkippedTurnEvent)) {
                this.println("Not adding to " + this.statics.getShortName() + "'s queue, exceeded " + 256 + " events in queue.");
                queue.clear((long)(this.battle.getTime() - 2));
                return;
            }
            queue.add((Object)event);
        }
    }

    private void updateGunHeading() {
        if (this.currentCommands.getGunTurnRemaining() > 0.0) {
            if (this.currentCommands.getGunTurnRemaining() < Rules.GUN_TURN_RATE_RADIANS) {
                this.gunHeading += this.currentCommands.getGunTurnRemaining();
                this.radarHeading += this.currentCommands.getGunTurnRemaining();
                if (this.currentCommands.isAdjustRadarForGunTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - this.currentCommands.getGunTurnRemaining());
                }
                this.currentCommands.setGunTurnRemaining(0.0);
            } else {
                this.gunHeading += Rules.GUN_TURN_RATE_RADIANS;
                this.radarHeading += Rules.GUN_TURN_RATE_RADIANS;
                this.currentCommands.setGunTurnRemaining(this.currentCommands.getGunTurnRemaining() - Rules.GUN_TURN_RATE_RADIANS);
                if (this.currentCommands.isAdjustRadarForGunTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - Rules.GUN_TURN_RATE_RADIANS);
                }
            }
        } else if (this.currentCommands.getGunTurnRemaining() < 0.0) {
            if (this.currentCommands.getGunTurnRemaining() > -Rules.GUN_TURN_RATE_RADIANS) {
                this.gunHeading += this.currentCommands.getGunTurnRemaining();
                this.radarHeading += this.currentCommands.getGunTurnRemaining();
                if (this.currentCommands.isAdjustRadarForGunTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - this.currentCommands.getGunTurnRemaining());
                }
                this.currentCommands.setGunTurnRemaining(0.0);
            } else {
                this.gunHeading -= Rules.GUN_TURN_RATE_RADIANS;
                this.radarHeading -= Rules.GUN_TURN_RATE_RADIANS;
                this.currentCommands.setGunTurnRemaining(this.currentCommands.getGunTurnRemaining() + Rules.GUN_TURN_RATE_RADIANS);
                if (this.currentCommands.isAdjustRadarForGunTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() + Rules.GUN_TURN_RATE_RADIANS);
                }
            }
        }
        this.gunHeading = Utils.normalAbsoluteAngle((double)this.gunHeading);
    }

    private void updateHeading() {
        boolean normalizeHeading = true;
        double turnRate = Math.min(this.currentCommands.getMaxTurnRate(), (0.4 + 0.6 * (1.0 - Math.abs(this.velocity) / 8.0)) * Rules.MAX_TURN_RATE_RADIANS);
        if (this.currentCommands.getBodyTurnRemaining() > 0.0) {
            if (this.currentCommands.getBodyTurnRemaining() < turnRate) {
                this.bodyHeading += this.currentCommands.getBodyTurnRemaining();
                this.gunHeading += this.currentCommands.getBodyTurnRemaining();
                this.radarHeading += this.currentCommands.getBodyTurnRemaining();
                if (this.currentCommands.isAdjustGunForBodyTurn()) {
                    this.currentCommands.setGunTurnRemaining(this.currentCommands.getGunTurnRemaining() - this.currentCommands.getBodyTurnRemaining());
                }
                if (this.currentCommands.isAdjustRadarForBodyTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - this.currentCommands.getBodyTurnRemaining());
                }
                this.currentCommands.setBodyTurnRemaining(0.0);
            } else {
                this.bodyHeading += turnRate;
                this.gunHeading += turnRate;
                this.radarHeading += turnRate;
                this.currentCommands.setBodyTurnRemaining(this.currentCommands.getBodyTurnRemaining() - turnRate);
                if (this.currentCommands.isAdjustGunForBodyTurn()) {
                    this.currentCommands.setGunTurnRemaining(this.currentCommands.getGunTurnRemaining() - turnRate);
                }
                if (this.currentCommands.isAdjustRadarForBodyTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - turnRate);
                }
            }
        } else if (this.currentCommands.getBodyTurnRemaining() < 0.0) {
            if (this.currentCommands.getBodyTurnRemaining() > -turnRate) {
                this.bodyHeading += this.currentCommands.getBodyTurnRemaining();
                this.gunHeading += this.currentCommands.getBodyTurnRemaining();
                this.radarHeading += this.currentCommands.getBodyTurnRemaining();
                if (this.currentCommands.isAdjustGunForBodyTurn()) {
                    this.currentCommands.setGunTurnRemaining(this.currentCommands.getGunTurnRemaining() - this.currentCommands.getBodyTurnRemaining());
                }
                if (this.currentCommands.isAdjustRadarForBodyTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - this.currentCommands.getBodyTurnRemaining());
                }
                this.currentCommands.setBodyTurnRemaining(0.0);
            } else {
                this.bodyHeading -= turnRate;
                this.gunHeading -= turnRate;
                this.radarHeading -= turnRate;
                this.currentCommands.setBodyTurnRemaining(this.currentCommands.getBodyTurnRemaining() + turnRate);
                if (this.currentCommands.isAdjustGunForBodyTurn()) {
                    this.currentCommands.setGunTurnRemaining(this.currentCommands.getGunTurnRemaining() + turnRate);
                }
                if (this.currentCommands.isAdjustRadarForBodyTurn()) {
                    this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() + turnRate);
                }
            }
        } else {
            normalizeHeading = false;
        }
        if (normalizeHeading) {
            this.bodyHeading = this.currentCommands.getBodyTurnRemaining() == 0.0 ? Utils.normalNearAbsoluteAngle((double)this.bodyHeading) : Utils.normalAbsoluteAngle((double)this.bodyHeading);
        }
        if (Double.isNaN(this.bodyHeading)) {
            Logger.realErr.println("HOW IS HEADING NAN HERE");
        }
    }

    private void updateRadarHeading() {
        if (this.currentCommands.getRadarTurnRemaining() > 0.0) {
            if (this.currentCommands.getRadarTurnRemaining() < Rules.RADAR_TURN_RATE_RADIANS) {
                this.radarHeading += this.currentCommands.getRadarTurnRemaining();
                this.currentCommands.setRadarTurnRemaining(0.0);
            } else {
                this.radarHeading += Rules.RADAR_TURN_RATE_RADIANS;
                this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() - Rules.RADAR_TURN_RATE_RADIANS);
            }
        } else if (this.currentCommands.getRadarTurnRemaining() < 0.0) {
            if (this.currentCommands.getRadarTurnRemaining() > -Rules.RADAR_TURN_RATE_RADIANS) {
                this.radarHeading += this.currentCommands.getRadarTurnRemaining();
                this.currentCommands.setRadarTurnRemaining(0.0);
            } else {
                this.radarHeading -= Rules.RADAR_TURN_RATE_RADIANS;
                this.currentCommands.setRadarTurnRemaining(this.currentCommands.getRadarTurnRemaining() + Rules.RADAR_TURN_RATE_RADIANS);
            }
        }
        this.radarHeading = Utils.normalAbsoluteAngle((double)this.radarHeading);
    }

    private void updateMovement() {
        double distance = this.currentCommands.getDistanceRemaining();
        if (Double.isNaN(distance)) {
            distance = 0.0;
        }
        this.velocity = this.getNewVelocity(this.velocity, distance);
        if (Utils.isNear((double)this.velocity, (double)0.0) && this.isOverDriving) {
            this.currentCommands.setDistanceRemaining(0.0);
            distance = 0.0;
            this.isOverDriving = false;
        }
        if (Math.signum(distance * this.velocity) != -1.0) {
            this.isOverDriving = this.getDistanceTraveledUntilStop(this.velocity) > Math.abs(distance);
        }
        this.currentCommands.setDistanceRemaining(distance - this.velocity);
        if (this.velocity != 0.0) {
            this.x += this.velocity * Math.sin(this.bodyHeading);
            this.y += this.velocity * Math.cos(this.bodyHeading);
            this.updateBoundingBox();
        }
    }

    private double getDistanceTraveledUntilStop(double velocity) {
        double distance = 0.0;
        velocity = Math.abs(velocity);
        while (velocity > 0.0) {
            velocity = this.getNewVelocity(velocity, 0.0);
            distance += velocity;
        }
        return distance;
    }

    private double getNewVelocity(double velocity, double distance) {
        if (distance < 0.0) {
            return -this.getNewVelocity(-velocity, -distance);
        }
        double goalVel = distance == Double.POSITIVE_INFINITY ? this.currentCommands.getMaxVelocity() : Math.min(RobotPeer.getMaxVelocity(distance), this.currentCommands.getMaxVelocity());
        if (velocity >= 0.0) {
            return Math.max(velocity - 2.0, Math.min(goalVel, velocity + 1.0));
        }
        return Math.max(velocity - 1.0, Math.min(goalVel, velocity + RobotPeer.maxDecel(-velocity)));
    }

    static final double getMaxVelocity(double distance) {
        double decelTime = Math.max(1.0, Math.ceil((Math.sqrt(4.0 * distance + 1.0) - 1.0) / 2.0));
        if (decelTime == Double.POSITIVE_INFINITY) {
            return 8.0;
        }
        double decelDist = decelTime / 2.0 * (decelTime - 1.0) * 2.0;
        return (decelTime - 1.0) * 2.0 + (distance - decelDist) / decelTime;
    }

    private static double maxDecel(double speed) {
        double decelTime = speed / 2.0;
        double accelTime = 1.0 - decelTime;
        return Math.min(1.0, decelTime) * 2.0 + Math.max(0.0, accelTime) * 1.0;
    }

    private void updateGunHeat() {
        this.gunHeat -= this.battleRules.getGunCoolingRate();
        if (this.gunHeat < 0.0) {
            this.gunHeat = 0.0;
        }
    }

    private void scan(double lastRadarHeading, List<RobotPeer> robots) {
        if (this.statics.isDroid()) {
            return;
        }
        double startAngle = lastRadarHeading;
        double scanRadians = this.getRadarHeading() - startAngle;
        if (scanRadians < -Math.PI) {
            scanRadians = Math.PI * 2 + scanRadians;
        } else if (scanRadians > Math.PI) {
            scanRadians -= Math.PI * 2;
        }
        startAngle -= 1.5707963267948966;
        startAngle = Utils.normalAbsoluteAngle((double)startAngle);
        this.scanArc.setArc(this.x - 1200.0, this.y - 1200.0, 2400.0, 2400.0, 180.0 * startAngle / Math.PI, 180.0 * scanRadians / Math.PI, 2);
        for (RobotPeer otherRobot : robots) {
            if (otherRobot == null || otherRobot == this || otherRobot.isDead() || !this.intersects(this.scanArc, otherRobot.boundingBox)) continue;
            double dx = otherRobot.x - this.x;
            double dy = otherRobot.y - this.y;
            double angle = Math.atan2(dx, dy);
            double dist = Math.hypot(dx, dy);
            ScannedRobotEvent event = new ScannedRobotEvent(otherRobot.getName(), otherRobot.energy, Utils.normalRelativeAngle((double)(angle - this.getBodyHeading())), dist, otherRobot.getBodyHeading(), otherRobot.getVelocity());
            this.addEvent((Event)event);
        }
    }

    private boolean intersects(Arc2D arc, Rectangle2D rect) {
        return rect.intersectsLine(arc.getCenterX(), arc.getCenterY(), arc.getStartPoint().getX(), arc.getStartPoint().getY()) || arc.intersects(rect);
    }

    private void zap(double zapAmount) {
        if (this.energy == 0.0) {
            this.kill();
            return;
        }
        this.energy -= Math.abs(zapAmount);
        if (this.energy < 0.1) {
            this.energy = 0.0;
            this.currentCommands.setDistanceRemaining(0.0);
            this.currentCommands.setBodyTurnRemaining(0.0);
        }
    }

    public void setRunning(boolean value) {
        this.isRunning.set(value);
    }

    public void drainEnergy() {
        this.setEnergy(0.0, true);
        this.isEnergyDrained = true;
    }

    public void punishBadBehavior(BadBehavior badBehavior) {
        this.setState(RobotState.DEAD);
        this.statistics.setInactive();
        IRobotRepositoryItem repositoryItem = (IRobotRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)this.robotSpecification);
        StringBuffer message = new StringBuffer(this.getName()).append(' ');
        boolean disableInRepository = false;
        switch (badBehavior) {
            case CANNOT_START: {
                message.append("could not be started or loaded.");
                disableInRepository = true;
                break;
            }
            case UNSTOPPABLE: {
                message.append("cannot be stopped.");
                break;
            }
            case SKIPPED_TOO_MANY_TURNS: {
                message.append("has skipped too many turns.");
                break;
            }
            case SECURITY_VIOLATION: {
                message.append("has caused a security violation.");
                disableInRepository = true;
            }
        }
        if (disableInRepository) {
            repositoryItem.setValid(false);
            message.append(" This ").append(repositoryItem.isTeam() ? "team" : "robot").append(" has been banned and will not be allowed to participate in battles.");
        }
        Logger.logMessage((String)message.toString());
    }

    public void updateEnergy(double delta) {
        if (!this.isExecFinishedAndDisabled && !this.isEnergyDrained || delta < 0.0) {
            this.setEnergy(this.energy + delta, true);
        }
    }

    private void setEnergy(double newEnergy, boolean resetInactiveTurnCount) {
        if (resetInactiveTurnCount && this.energy != newEnergy) {
            this.battle.resetInactiveTurnCount(this.energy - newEnergy);
        }
        this.energy = newEnergy;
        if (this.energy < 0.01) {
            this.energy = 0.0;
            ExecCommands localCommands = this.commands.get();
            localCommands.setDistanceRemaining(0.0);
            localCommands.setBodyTurnRemaining(0.0);
        }
    }

    @Override
    public void setWinner(boolean newWinner) {
        this.isWinner = newWinner;
    }

    @Override
    public void kill() {
        this.battle.resetInactiveTurnCount(10.0);
        if (this.isAlive()) {
            this.addEvent((Event)new DeathEvent());
            if (this.statics.isTeamLeader()) {
                for (RobotPeer teammate : this.teamPeer) {
                    if (teammate.isDead() || teammate == this) continue;
                    teammate.updateEnergy(-30.0);
                    BulletPeer sBullet = new BulletPeer(this, this.battleRules, -1);
                    sBullet.setState(BulletState.HIT_VICTIM);
                    sBullet.setX(teammate.x);
                    sBullet.setY(teammate.y);
                    sBullet.setVictim(teammate);
                    sBullet.setPower(4.0);
                    this.battle.addBullet(sBullet);
                }
            }
            this.battle.registerDeathRobot(this);
            ExplosionPeer fake = new ExplosionPeer(this, this.battleRules);
            this.battle.addBullet(fake);
        }
        this.updateEnergy(-this.energy);
        this.setState(RobotState.DEAD);
    }

    @Override
    public void waitForStop() {
        this.robotProxy.waitForStopThread();
    }

    @Override
    public void cleanup() {
        this.battle = null;
        if (this.robotProxy != null) {
            this.robotProxy.cleanup();
            this.robotProxy = null;
        }
        if (this.statistics != null) {
            this.statistics.cleanup();
            this.statistics = null;
        }
        this.status = null;
        this.commands = null;
        this.events = null;
        this.teamMessages = null;
        this.bulletUpdates = null;
        this.battleText.setLength(0);
        this.proxyText.setLength(0);
        this.statics = null;
        this.battleRules = null;
    }

    public Object getGraphicsCalls() {
        return this.commands.get().getGraphicsCalls();
    }

    public boolean isTryingToPaint() {
        return this.commands.get().isTryingToPaint();
    }

    public List<DebugProperty> getDebugProperties() {
        return this.commands.get().getDebugProperties();
    }

    @Override
    public void publishStatus(long currentTurn) {
        ExecCommands currentCommands = this.commands.get();
        int others = this.battle.getActiveRobots() - (this.isAlive() ? 1 : 0);
        RobotStatus stat = HiddenAccess.createStatus((double)this.energy, (double)this.x, (double)this.y, (double)this.bodyHeading, (double)this.gunHeading, (double)this.radarHeading, (double)this.velocity, (double)currentCommands.getBodyTurnRemaining(), (double)currentCommands.getRadarTurnRemaining(), (double)currentCommands.getGunTurnRemaining(), (double)currentCommands.getDistanceRemaining(), (double)this.gunHeat, (int)others, (int)this.battle.getRoundNum(), (int)this.battle.getNumRounds(), (long)this.battle.getTime());
        this.status.set(stat);
    }

    public void addBulletStatus(BulletStatus bulletStatus) {
        if (this.isAlive()) {
            this.bulletUpdates.get().add(bulletStatus);
        }
    }

    @Override
    public int compareTo(ContestantPeer cp) {
        double myScore = this.statistics.getTotalScore();
        double hisScore = cp.getStatistics().getTotalScore();
        if (this.statistics.isInRound()) {
            myScore += this.statistics.getCurrentScore();
            hisScore += cp.getStatistics().getCurrentScore();
        }
        if (myScore < hisScore) {
            return -1;
        }
        if (myScore > hisScore) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return this.statics.getShortName() + "(" + (int)this.energy + ") X" + (int)this.x + " Y" + (int)this.y + " " + this.state.toString() + (this.isSleeping() ? " sleeping " : "") + (this.isRunning() ? " running" : "") + (this.getHalt() ? " halted" : "");
    }
}

