/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.robocode.serialization.IXmlSerializable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader {
    SAXParser parser;
    final InputStream input;
    final Stack<Element> elements = new Stack();
    final Stack<IXmlSerializable> items = new Stack();
    final Stack<Dictionary<String, Element>> elementNames = new Stack();
    final Stack<Dictionary<String, Attribute>> attributeNames = new Stack();
    IXmlSerializable result;

    public XmlReader(InputStream input) throws SAXException, ParserConfigurationException {
        this.input = input;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.parser = factory.newSAXParser();
    }

    private Object deserialize(IXmlSerializable prototype) throws IOException, SAXException {
        this.elementNames.push(new Hashtable());
        this.attributeNames.push(new Hashtable());
        this.items.push(null);
        this.elements.push(new ListElement(){

            public IXmlSerializable read(XmlReader reader) {
                return null;
            }

            public void add(IXmlSerializable child) {
                XmlReader.this.result = child;
            }

            public void close() {
            }
        });
        prototype.readXml(this);
        this.parser.parse(this.input, (DefaultHandler)new Handler(this));
        this.items.pop();
        this.elements.pop();
        this.elementNames.pop();
        this.attributeNames.pop();
        return this.result;
    }

    public Element expect(String name, Element element) {
        this.elementNames.peek().put(name, element);
        return element;
    }

    public Attribute expect(String name, Attribute attribute) {
        this.attributeNames.peek().put(name, attribute);
        return attribute;
    }

    public static Object deserialize(InputStream input, IXmlSerializable prototype) throws IOException {
        try {
            XmlReader xr = new XmlReader(input);
            return xr.deserialize(prototype);
        }
        catch (SAXException e) {
            throw new IOException();
        }
        catch (ParserConfigurationException e) {
            throw new IOException();
        }
    }

    public static interface Attribute {
        public void read(String var1);
    }

    public static interface ListElement
    extends ElementClose {
        public void add(IXmlSerializable var1);
    }

    public static interface ElementClose
    extends Element {
        public void close();
    }

    public static interface Element {
        public IXmlSerializable read(XmlReader var1);
    }

    private class Handler
    extends DefaultHandler {
        final XmlReader parent;

        public Handler(XmlReader parent) {
            this.parent = parent;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Element element;
            Dictionary<String, Element> names = XmlReader.this.elementNames.peek();
            Element element2 = element = names == null ? null : names.get(qName);
            if (element != null) {
                XmlReader.this.elements.push(element);
                XmlReader.this.elementNames.push(new Hashtable());
                XmlReader.this.attributeNames.push(new Hashtable());
                IXmlSerializable item = element.read(this.parent);
                item.readXml(this.parent);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attribute attribute = XmlReader.this.attributeNames.peek().get(attributes.getQName(i));
                    if (attribute == null) continue;
                    attribute.read(attributes.getValue(i));
                }
                XmlReader.this.items.push(item);
            } else {
                XmlReader.this.items.push(null);
                XmlReader.this.elements.push(null);
                XmlReader.this.elementNames.push(null);
                XmlReader.this.attributeNames.push(null);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            Element element;
            XmlReader.this.elements.pop();
            IXmlSerializable item = XmlReader.this.items.peek();
            Element parentElement = XmlReader.this.elements.peek();
            if (parentElement instanceof ListElement) {
                ListElement le = (ListElement)parentElement;
                le.add(item);
            }
            XmlReader.this.items.pop();
            XmlReader.this.elementNames.pop();
            XmlReader.this.attributeNames.pop();
            Dictionary<String, Element> names = XmlReader.this.elementNames.peek();
            Element element2 = element = names == null ? null : names.get(qName);
            if (element != null && element instanceof ElementClose) {
                ElementClose ec = (ElementClose)element;
                ec.close();
            }
        }
    }
}

