/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphanumericComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(String str1, String str2) {
        if (str1 == null) {
            return str2 == null ? 0 : 1;
        }
        if (str2 == null) {
            return -1;
        }
        if (str1.equals(str2)) {
            return 0;
        }
        int result = 0;
        int index = 0;
        String tok1;
        while ((result = AlphanumericComparator.compareTokens(tok1 = AlphanumericComparator.readToken(str1, index), AlphanumericComparator.readToken(str2, index))) == 0) {
            index += tok1.length();
        }
        return result;
    }

    private static String readToken(String input, int startIndex) {
        int index;
        if (input == null || startIndex >= input.length()) {
            return null;
        }
        if (Character.isDigit(input.charAt(startIndex))) {
            for (index = startIndex + 1; index < input.length() && Character.isDigit(input.charAt(index)); ++index) {
            }
        } else {
            while (index < input.length() && !Character.isDigit(input.charAt(index))) {
                ++index;
            }
        }
        return input.substring(startIndex, index);
    }

    private static int compareTokens(String tok1, String tok2) {
        if (tok1 == null) {
            return tok2 == null ? 0 : 1;
        }
        if (tok2 == null) {
            return -1;
        }
        if (Character.isDigit(tok1.charAt(0))) {
            if (Character.isDigit(tok2.charAt(0))) {
                return (int)(Long.parseLong(tok1) - Long.parseLong(tok2));
            }
            return -1;
        }
        if (Character.isDigit(tok2.charAt(0))) {
            return 1;
        }
        int result = tok1.toUpperCase().compareTo(tok2.toUpperCase());
        if (result != 0) {
            return result;
        }
        return tok1.compareTo(tok2);
    }

    public static void main(String ... args) {
        String[] strings = new String[]{null, "", " ", "alpha2", "alpha1", "bEtA", "BeTa", "alpha", "Alpha2", "Alpha1", "Alpha", "1.2", "1.22", "1.22A", "1.3", "2.10a.1", "2.1.1", "2.10", "2.1a", "2.10.2", "1c", "1h", "1p", "alpha", "beta", "alPHA", "beTA", "ALpha", "BEta", "ALPHA", "BETA"};
        Arrays.sort(strings, new AlphanumericComparator());
        for (String s : strings) {
            System.out.println(s == null ? "<null>" : '\"' + s + '\"');
        }
    }
}

