/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IRobotClassLoader;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import robocode.robotinterfaces.IBasicRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotClassLoader
extends URLClassLoader
implements IRobotClassLoader {
    public static final String untrustedURL = "http://robocode.sf.net/untrusted";
    private static final boolean IS_SECURITY_ON = !System.getProperty("NOSECURITY", "false").equals("true");
    private static final PermissionCollection EMPTY_PERMISSIONS = new Permissions();
    protected final URL robotClassPath;
    protected final String fullClassName;
    private ClassLoader parent;
    private CodeSource codeSource;
    private IHostedThread robotProxy;
    protected Class<?> robotClass;
    private Set<String> referencedClasses = new HashSet<String>();
    private String[] staticRobotInstanceWarning;

    public RobotClassLoader(URL robotClassPath, String robotFullClassName) {
        super(new URL[]{robotClassPath}, Container.systemLoader);
        this.fullClassName = robotFullClassName;
        this.robotClassPath = robotClassPath;
        this.parent = this.getParent();
        try {
            this.codeSource = new CodeSource(new URL(untrustedURL), (Certificate[])null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setRobotProxy(Object robotProxy) {
        this.robotProxy = (IHostedThread)robotProxy;
    }

    @Override
    public synchronized void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (name.startsWith("java.lang")) {
            return super.loadClass(name, resolve);
        }
        if (IS_SECURITY_ON) {
            this.testPackages(name);
        }
        if (!name.startsWith("robocode") && (result = this.loadRobotClassLocaly(name, resolve)) != null) {
            return result;
        }
        return this.parent.loadClass(name);
    }

    private void testPackages(String name) throws ClassNotFoundException {
        if (name.startsWith("net.sf.robocode")) {
            String message = "Robots are not allowed to reference Robocode engine in package: net.sf.robocode";
            this.punishSecurityViolation("Robots are not allowed to reference Robocode engine in package: net.sf.robocode");
            throw new ClassNotFoundException("Robots are not allowed to reference Robocode engine in package: net.sf.robocode");
        }
        if (name.startsWith("robocode.control")) {
            String message = "Robots are not allowed to reference Robocode engine in package: robocode.control";
            this.punishSecurityViolation("Robots are not allowed to reference Robocode engine in package: robocode.control");
            throw new ClassNotFoundException("Robots are not allowed to reference Robocode engine in package: robocode.control");
        }
        if (IS_SECURITY_ON && name.startsWith("javax.swing")) {
            String message = "Robots are not allowed to reference Robocode engine in package: javax.swing";
            this.punishSecurityViolation("Robots are not allowed to reference Robocode engine in package: javax.swing");
            throw new ClassNotFoundException("Robots are not allowed to reference Robocode engine in package: javax.swing");
        }
    }

    private Class<?> loadRobotClassLocaly(String name, boolean resolve) throws ClassNotFoundException {
        ByteBuffer resource;
        Class<?> result = this.findLoadedClass(name);
        if (result == null && (resource = this.findLocalResource(name)) != null) {
            result = this.defineClass(name, resource, this.codeSource);
            if (resolve) {
                this.resolveClass(result);
            }
            ClassAnalyzer.getReferencedClasses(resource, this.referencedClasses);
        }
        return result;
    }

    private ByteBuffer findLocalResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ByteBuffer run() {
                String path = name.replace('.', '/').concat(".class");
                URL url = RobotClassLoader.this.findResource(path);
                ByteBuffer result = null;
                InputStream is = null;
                BufferedInputStream bis = null;
                if (url != null) {
                    try {
                        URLConnection connection = URLJarCollector.openConnection((URL)url);
                        is = connection.getInputStream();
                        bis = new BufferedInputStream(is);
                        result = ByteBuffer.allocate(8192);
                        boolean done = false;
                        while (true) {
                            int res;
                            if ((res = bis.read(result.array(), result.position(), result.remaining())) == -1) {
                                done = true;
                            } else {
                                result.position(result.position() + res);
                                if (result.remaining() != 0) continue;
                            }
                            result.flip();
                            if (!done) {
                                result = ByteBuffer.allocate(result.capacity() * 2).put(result);
                            }
                            if (done) break;
                        }
                        FileUtil.cleanupStream((Object)bis);
                    }
                    catch (IOException e) {
                        Logger.logError((Throwable)e);
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    finally {
                        FileUtil.cleanupStream(bis);
                        FileUtil.cleanupStream((Object)is);
                    }
                    FileUtil.cleanupStream((Object)is);
                }
                return result;
            }
        });
    }

    private void punishSecurityViolation(String message) {
        if (this.robotProxy != null) {
            this.robotProxy.punishSecurityViolation(message);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (IS_SECURITY_ON) {
            return EMPTY_PERMISSIONS;
        }
        return super.getPermissions(codesource);
    }

    public String[] getReferencedClasses() {
        return this.referencedClasses.toArray(new String[this.referencedClasses.size()]);
    }

    public synchronized Class<?> loadRobotMainClass(boolean resolve) throws ClassNotFoundException {
        try {
            if (this.robotClass == null) {
                this.robotClass = this.loadClass(this.fullClassName, resolve);
                if (!IBasicRobot.class.isAssignableFrom(this.robotClass)) {
                    return null;
                }
                if (resolve) {
                    HashSet<String> clone;
                    this.robotClass.getMethods();
                    do {
                        clone = new HashSet<String>(this.referencedClasses);
                        for (String reference : clone) {
                            this.testPackages(reference);
                            if (RobotClassLoader.isSystemClass(reference)) continue;
                            this.loadClass(reference, true);
                        }
                    } while (this.referencedClasses.size() != clone.size());
                }
            } else {
                this.warnIfStaticRobotInstanceFields();
            }
        }
        catch (Throwable e) {
            this.robotClass = null;
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        return this.robotClass;
    }

    public IBasicRobot createRobotInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.loadRobotMainClass(true);
        return (IBasicRobot)this.robotClass.newInstance();
    }

    public void cleanup() {
        for (String className : this.getReferencedClasses()) {
            this.cleanStaticReferences(className);
        }
        this.parent = null;
        this.codeSource = null;
        this.robotProxy = null;
        this.robotClass = null;
        this.referencedClasses = null;
    }

    private void cleanStaticReferences(String className) {
        if (RobotClassLoader.isSystemClass(className)) {
            return;
        }
        Class<?> type = null;
        try {
            type = this.loadRobotClassLocaly(className, false);
        }
        catch (Throwable t) {
            return;
        }
        if (type != null) {
            for (Field field : RobotClassLoader.getAllFields(new ArrayList<Field>(), type)) {
                if (!RobotClassLoader.isStaticReference(field)) continue;
                this.cleanStaticReference(field);
            }
        }
    }

    private void warnIfStaticRobotInstanceFields() {
        if (this.staticRobotInstanceWarning == null) {
            ArrayList<Field> staticRobotReferences = new ArrayList<Field>();
            for (String className : this.referencedClasses) {
                if (RobotClassLoader.isSystemClass(className)) continue;
                Class<?> type = null;
                try {
                    type = this.loadRobotClassLocaly(className, false);
                }
                catch (Throwable t) {
                    continue;
                }
                if (type == null) continue;
                for (Field field : RobotClassLoader.getAllFields(new ArrayList<Field>(), type)) {
                    if (!RobotClassLoader.isStaticReference(field) || !IBasicRobot.class.isAssignableFrom(field.getType())) continue;
                    staticRobotReferences.add(field);
                }
            }
            if (staticRobotReferences.size() > 0) {
                StringBuilder buf = new StringBuilder();
                buf.append(this.fullClassName + " uses static reference to a robot with the following field(s):");
                for (Field field : staticRobotReferences) {
                    buf.append("\n\t").append(field.getDeclaringClass().getName()).append('.').append(field.getName()).append(", which points to a ").append(field.getType().getName());
                }
                this.staticRobotInstanceWarning = new String[]{buf.toString(), "Static references to robots can cause unwanted behaviour with the robot using these.", "Please change static robot references to non-static references and recompile the robot."};
            } else {
                this.staticRobotInstanceWarning = new String[0];
            }
        } else if (this.staticRobotInstanceWarning.length == 0) {
            return;
        }
        if (this.robotProxy != null) {
            for (String line : this.staticRobotInstanceWarning) {
                this.robotProxy.getOut().println("SYSTEM: " + line);
            }
        }
    }

    private void cleanStaticReference(Field field) {
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            int modifiers = modifiersField.getInt(field);
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
            field.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        if (type == null || RobotClassLoader.isSystemClass(type.getName())) {
            return fields;
        }
        try {
            for (Field field : type.getDeclaredFields()) {
                fields.add(field);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (type.getSuperclass() != null) {
            fields = RobotClassLoader.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private static boolean isSystemClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("robocode.") || className.startsWith("net.sf.robocode.") || className.startsWith("tested.robots.");
    }

    private static boolean isStaticReference(Field field) {
        return Modifier.isStatic(field.getModifiers()) && !field.getType().isPrimitive() && !field.isEnumConstant() && !field.isSynthetic();
    }
}

