/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.security.LoggingThreadGroup;
import robocode.exception.RobotException;

public class RobotThreadManager {
    private final IHostedThread robotProxy;
    private Thread runThread;
    private LoggingThreadGroup runThreadGroup;
    private Object awtForThreadGroup;
    private final Map<Thread, Disposal> disposeAppContextThreadMap = new HashMap<Thread, Disposal>();

    public RobotThreadManager(IHostedThread robotProxy) {
        this.robotProxy = robotProxy;
        this.createThreadGroup();
    }

    public void cleanup() {
        try {
            if (this.runThread == null || !this.runThread.isAlive()) {
                if (!this.discardAWT()) {
                    this.runThreadGroup.destroy();
                }
            } else {
                Logger.logWarning((String)("Could not destroy " + this.runThread.getName()));
            }
        }
        catch (Exception e) {
            Logger.logError((String)("Could not destroy " + this.runThreadGroup.getName()), (Throwable)e);
        }
    }

    public void initAWT() {
        if (this.awtForThreadGroup == null) {
            this.awtForThreadGroup = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return RobotThreadManager.this.createNewAppContext();
                }
            });
        }
    }

    public boolean discardAWT() {
        boolean res = false;
        if (this.awtForThreadGroup != null && !(this.awtForThreadGroup instanceof Integer)) {
            res = this.disposeAppContext(this.awtForThreadGroup);
            this.awtForThreadGroup = null;
        }
        return res;
    }

    public void checkRunThread() {
        if (Thread.currentThread() != this.runThread) {
            throw new RobotException("You cannot take action in this thread!");
        }
    }

    public void start(IThreadManager threadManager) {
        try {
            threadManager.addThreadGroup((ThreadGroup)this.runThreadGroup, this.robotProxy);
            this.runThread = new Thread((ThreadGroup)this.runThreadGroup, this.robotProxy, this.robotProxy.getStatics().getName());
            this.runThread.setDaemon(true);
            this.runThread.setPriority(4);
            this.runThread.setContextClassLoader(this.robotProxy.getRobotClassloader());
            this.runThread.start();
        }
        catch (Exception e) {
            Logger.logError((String)"Exception starting thread", (Throwable)e);
        }
    }

    public boolean waitForStop() {
        boolean isAlive = false;
        if (this.runThread != null && this.runThread.isAlive()) {
            this.runThread.interrupt();
            this.waitForStop(this.runThread);
            isAlive = this.runThread.isAlive();
        }
        Thread[] threads = new Thread[100];
        this.runThreadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || thread == this.runThread || !thread.isAlive()) continue;
            thread.interrupt();
            this.waitForStop(thread);
            isAlive |= thread.isAlive();
        }
        if (isAlive) {
            if (!System.getProperty("NOSECURITY", "false").equals("true")) {
                Logger.logError((String)("Robot " + this.robotProxy.getStatics().getName() + " is not stopping.  Forcing a stop."));
                return this.forceStop();
            }
            Logger.logError((String)("Robot " + this.robotProxy.getStatics().getName() + " is still running.  Not stopping it because security is off."));
        }
        return true;
    }

    public boolean forceStop() {
        int res = this.stopSteps(this.runThread);
        Thread[] threads = new Thread[100];
        this.runThreadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || thread == this.runThread || !thread.isAlive()) continue;
            res += this.stopSteps(thread);
        }
        if (res > 0) {
            this.robotProxy.println("SYSTEM: This robot has been stopped.  No score will be generated.");
            this.createThreadGroup();
        }
        this.runThread = null;
        return res == 0;
    }

    private int stopSteps(Thread t) {
        if (t != null && t.isAlive()) {
            this.interrupt(t);
            if (t.isAlive()) {
                this.stop(t);
            }
            if (t.isAlive()) {
                Logger.logWarning((String)("Unable to stop thread: " + this.runThread.getName()));
            } else {
                Logger.logMessage((String)(this.robotProxy.getStatics().getName() + " has been stopped."));
            }
            return 1;
        }
        return 0;
    }

    private void stop(Thread t) {
        if (t != null) {
            t.stop();
            try {
                t.join(1500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void interrupt(Thread t) {
        if (t != null) {
            try {
                t.setPriority(1);
            }
            catch (NullPointerException e) {
                Logger.logError((String)"Sometimes this occurs in the Java core?!", (Throwable)e);
            }
            t.interrupt();
            try {
                t.join(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void waitForStop(Thread thread) {
        for (int j = 0; j < 100 && thread.isAlive(); ++j) {
            if (j == 50) {
                Logger.logMessage((String)("Waiting for robot " + this.robotProxy.getStatics().getName() + " to stop thread " + thread.getName()));
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void createThreadGroup() {
        this.runThreadGroup = new LoggingThreadGroup(this.robotProxy.getStatics().getName());
        this.runThreadGroup.setMaxPriority(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createNewAppContext() {
        if (!this.disposeAppContextThreadMap.containsKey(Thread.currentThread())) {
            this.disposeAppContextThreadMap.put(Thread.currentThread(), new Disposal());
        }
        try {
            Disposal disposal;
            Class<?> sunToolkit = ClassLoader.getSystemClassLoader().loadClass("sun.awt.SunToolkit");
            Disposal disposal2 = disposal = this.disposeAppContextThreadMap.get(Thread.currentThread());
            synchronized (disposal2) {
                while (disposal.isDisposing) {
                    try {
                        disposal.wait();
                    }
                    catch (InterruptedException e) {
                        return -1;
                    }
                }
            }
            return sunToolkit.getDeclaredMethod("createNewAppContext", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return -1;
        }
        catch (NoSuchMethodException e) {
            throw new Error("Looks like SunVM but unable to assure secured AWTQueue, sorry", e);
        }
        catch (InvocationTargetException e) {
            throw new Error("Looks like SunVM but unable to assure secured AWTQueue, sorry", e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Looks like SunVM but unable to assure secured AWTQueue, sorry", e);
        }
    }

    public boolean disposeAppContext(final Object appContext) {
        if (System.getProperty("java.awt.headless", "false").equals("true")) {
            return false;
        }
        try {
            final Class<?> sunToolkit = ClassLoader.getSystemClassLoader().loadClass("sun.awt.AppContext");
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Disposal disposal = (Disposal)RobotThreadManager.this.disposeAppContextThreadMap.get(Thread.currentThread());
                    try {
                        if (disposal != null) {
                            Disposal disposal2 = disposal;
                            synchronized (disposal2) {
                                disposal.isDisposing = true;
                                disposal.notifyAll();
                            }
                        }
                        sunToolkit.getDeclaredMethod("dispose", new Class[0]).invoke(appContext, new Object[0]);
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e);
                    }
                    finally {
                        if (disposal != null) {
                            Disposal disposal3 = disposal;
                            synchronized (disposal3) {
                                disposal.isDisposing = false;
                                disposal.notifyAll();
                            }
                        }
                    }
                }
            }, "DisposeAppContext").start();
            return true;
        }
        catch (ClassNotFoundException e) {
            Logger.logError((Throwable)e);
            return false;
        }
    }

    private static class Disposal {
        boolean isDisposing;

        private Disposal() {
        }
    }
}

