/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.TeamItem;
import net.sf.robocode.repository.root.BaseRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.repository.root.handlers.RootHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private Hashtable<String, IRepositoryRoot> roots = new Hashtable();
    private Hashtable<String, IItem> items = new Hashtable();
    private Hashtable<String, IItem> oldItems = new Hashtable();
    private final IRepositoryManager manager;

    public Database(IRepositoryManager manager) {
        this.manager = manager;
    }

    public boolean update(File robotsDir, List<File> devDirs, boolean updateInvalid) {
        int prev = this.items.size();
        Hashtable<String, IRepositoryRoot> newroots = new Hashtable<String, IRepositoryRoot>();
        RootHandler.openHandlers();
        RootHandler.visitDirectories(robotsDir, false, newroots, this.roots, this, updateInvalid);
        for (File dir : devDirs) {
            RootHandler.visitDirectories(dir, true, newroots, this.roots, this, updateInvalid);
        }
        for (IRepositoryRoot oldRoot : this.roots.values()) {
            this.moveOldItems(oldRoot);
        }
        this.roots = newroots;
        this.oldItems = new Hashtable();
        RootHandler.closeHandlers();
        System.gc();
        return prev != this.items.size();
    }

    public boolean update(String itemKey, boolean force) {
        IItem item = this.items.get(itemKey);
        if (item != null) {
            item.getRoot().update(item, force);
            return true;
        }
        return false;
    }

    public void putItem(String itemKey, IItem item) {
        List<String> friendlyUrls;
        if (itemKey != null) {
            this.items.put(itemKey, item);
        }
        if ((friendlyUrls = item.getFriendlyUrls()) != null) {
            for (String friendly : friendlyUrls) {
                if (friendly == null) continue;
                IItem conflict = this.items.get(friendly);
                if (conflict != null) {
                    if (item.compareTo(conflict) <= 0) continue;
                    this.items.put(friendly, item);
                    continue;
                }
                this.items.put(friendly, item);
            }
        }
    }

    public IItem getItem(String itemKey) {
        return this.items.get(itemKey);
    }

    public IItem getOldItem(String itemKey) {
        return this.oldItems.get(itemKey);
    }

    public void moveOldItems(IRepositoryRoot root) {
        ArrayList<Map.Entry<String, IItem>> move = new ArrayList<Map.Entry<String, IItem>>();
        for (Map.Entry<String, IItem> entry : this.items.entrySet()) {
            if (entry.getValue().getRoot() != root) continue;
            move.add(entry);
        }
        for (Map.Entry<String, IItem> entry : move) {
            this.oldItems.put(entry.getKey(), entry.getValue());
            this.items.remove(entry.getKey());
        }
    }

    public List<TeamItem> filterTeams(List<IRepositoryItem> selectedRobots) {
        ArrayList<TeamItem> result = new ArrayList<TeamItem>();
        for (IRepositoryItem item : selectedRobots) {
            if (!item.isTeam()) continue;
            result.add((TeamItem)item);
        }
        return result;
    }

    public List<RobotItem> expandTeams(List<IRepositoryItem> selectedRobots) {
        ArrayList<RobotItem> result = new ArrayList<RobotItem>();
        for (IRepositoryItem item : selectedRobots) {
            if (item.isTeam()) {
                result.addAll(this.expandTeam((TeamItem)item));
                continue;
            }
            result.add((RobotItem)item);
        }
        return result;
    }

    public List<RobotItem> expandTeam(TeamItem team) {
        ArrayList<RobotItem> result = new ArrayList<RobotItem>();
        StringTokenizer teamTokenizer = new StringTokenizer(team.getMembers(), ",");
        while (teamTokenizer.hasMoreTokens()) {
            String botNameAndVersion = teamTokenizer.nextToken();
            int versionIndex = botNameAndVersion.indexOf(32);
            String botPath = versionIndex < 0 ? botNameAndVersion : botNameAndVersion.substring(0, versionIndex);
            botPath = botPath.replace('.', '/');
            String teamBot = team.getRoot().getRootUrl() + botPath;
            IItem res = this.getItem(teamBot);
            if (res != null && res instanceof RobotItem) {
                result.add((RobotItem)res);
                continue;
            }
            res = this.getItem(botNameAndVersion);
            if (res != null && res instanceof RobotItem) {
                result.add((RobotItem)res);
                continue;
            }
            Logger.logError((String)("Can't find robot: " + botNameAndVersion));
        }
        return result;
    }

    public List<IRepositoryItem> filterSpecifications(boolean onlyWithSource, boolean onlyWithPackage, boolean onlyRobots, boolean onlyDevelopment, boolean onlyNotDevelopment, boolean onlyInJar) {
        ArrayList<IRepositoryItem> res = new ArrayList<IRepositoryItem>();
        for (IItem item : this.items.values()) {
            IRepositoryItem spec = (IRepositoryItem)item;
            if (!item.isValid() || onlyWithSource && !spec.isJavaSourceIncluded() || onlyWithPackage && spec.getFullPackage() == null || onlyInJar && !spec.isInJar() || onlyRobots && !(item instanceof RobotItem) || onlyDevelopment && !spec.isDevelopmentVersion() || onlyNotDevelopment && spec.isDevelopmentVersion() || res.contains(spec)) continue;
            res.add(spec);
        }
        Collections.sort(res);
        return res;
    }

    public List<IRepositoryItem> getAllSpecifications() {
        ArrayList<IRepositoryItem> res = new ArrayList<IRepositoryItem>();
        for (IItem item : this.items.values()) {
            IRepositoryItem spec = (IRepositoryItem)item;
            if (!item.isValid() || res.contains(spec)) continue;
            res.add(spec);
        }
        return res;
    }

    public List<IRepositoryItem> getSelectedSpecifications(String selectedRobots) {
        ArrayList<IRepositoryItem> result = new ArrayList<IRepositoryItem>();
        StringTokenizer tokenizer = new StringTokenizer(selectedRobots, ",");
        while (tokenizer.hasMoreTokens()) {
            String bot = tokenizer.nextToken();
            IItem item = this.getItem(bot);
            if (item != null) {
                if (item.isValid()) {
                    result.add((IRepositoryItem)item);
                    continue;
                }
                Logger.logError((String)("Can't load " + bot + ", because it is invalid robot or team."));
                continue;
            }
            Logger.logError((String)("Can't find " + bot));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        block7: {
            LinkedList<IItem> uniqueitems = new LinkedList<IItem>();
            LinkedList<IRepositoryRoot> uniqueroots = new LinkedList<IRepositoryRoot>();
            for (IItem item : this.items.values()) {
                if (uniqueitems.contains(item)) continue;
                uniqueitems.add(item);
            }
            for (IRepositoryRoot root : this.roots.values()) {
                uniqueroots.add(root);
            }
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                fos = new FileOutputStream(new File(this.manager.getRobotsDirectory(), "robot.database"));
                oos = new ObjectOutputStream(fos);
                oos.writeObject(uniqueroots);
                oos.writeObject(uniqueitems);
                FileUtil.cleanupStream((Object)oos);
            }
            catch (IOException e) {
                Logger.logError((String)"Can't save robot database", (Throwable)e);
                break block7;
            }
            finally {
                FileUtil.cleanupStream(oos);
                FileUtil.cleanupStream(fos);
            }
            FileUtil.cleanupStream((Object)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database load(IRepositoryManager manager) {
        Database database;
        File file;
        ObjectInputStream ois;
        FileInputStream fis;
        block7: {
            fis = null;
            ois = null;
            file = new File(manager.getRobotsDirectory(), "robot.database");
            if (file.exists()) break block7;
            Database database2 = null;
            FileUtil.cleanupStream(ois);
            FileUtil.cleanupStream(fis);
            return database2;
        }
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            List uniqueroots = (List)ois.readObject();
            List uniqueitems = (List)ois.readObject();
            Database res = new Database(manager);
            for (IRepositoryRoot root : uniqueroots) {
                ((BaseRoot)root).setDatabase(res);
                res.roots.put(root.toString(), root);
            }
            for (IItem item : uniqueitems) {
                res.putItem(item.getFullUrl().toString(), item);
            }
            database = res;
        }
        catch (Throwable t) {
            Database database3;
            try {
                Logger.logError((String)("Can't load robot database: " + t.getMessage()));
                database3 = null;
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream(ois);
                FileUtil.cleanupStream(fis);
                throw throwable;
            }
            FileUtil.cleanupStream(ois);
            FileUtil.cleanupStream((Object)fis);
            return database3;
        }
        FileUtil.cleanupStream((Object)ois);
        FileUtil.cleanupStream((Object)fis);
        return database;
    }
}

